/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration;

import com.alexecollins.docker.orchestration.model.Conf;
import com.alexecollins.docker.orchestration.model.Id;
import com.alexecollins.docker.orchestration.model.Item;
import com.alexecollins.docker.orchestration.util.Filters;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileOrchestrator.class);
    private final FileFilter filter;
    private final Properties properties;
    private final File workDir;
    private final File rootDir;

    FileOrchestrator(File workDir, File rootDir, FileFilter fileFilter, Properties properties) {
        if (workDir == null) {
            throw new IllegalArgumentException("Working output directory is null");
        }
        if (rootDir == null) {
            throw new IllegalArgumentException("Root project directory is null");
        }
        if (fileFilter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        this.workDir = workDir;
        this.rootDir = rootDir;
        this.filter = fileFilter;
        this.properties = properties;
    }

    File prepare(Id id, File dockerFolder, Conf conf) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        File destDir = new File(this.workDir, dockerFolder.getName());
        this.copyDirectoryToDirectory(dockerFolder, destDir);
        Filters.filter(destDir, this.filter, this.properties);
        for (Item item : conf.getPackaging().getAdd()) {
            File fileEntry = new File(this.rootDir, item.getPath());
            this.copyFileEntry(destDir, fileEntry);
            if (!item.shouldFilter()) continue;
            Filters.filter(fileEntry, this.filter, this.properties);
        }
        return destDir;
    }

    private void copyFileEntry(File destDir, File fileEntry) throws IOException {
        LOGGER.info(" - add " + fileEntry);
        if (fileEntry.isDirectory()) {
            this.copyDirectoryToDirectory(fileEntry, new File(destDir, fileEntry.getName()));
        } else {
            Path targetPath = destDir.isDirectory() ? destDir.toPath().resolve(fileEntry.toPath().getFileName()) : destDir.toPath();
            Files.copy(fileEntry.toPath(), targetPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void copyDirectoryToDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        Files.walkFileTree(sourceDirectory.toPath(), (Set<FileVisitOption>)ImmutableSet.of((Object)((Object)FileVisitOption.FOLLOW_LINKS)), 1000, new CopyFileVisitor(destinationDirectory.toPath()));
    }

    private static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            }
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }
    }
}

