/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration;

import com.alexecollins.docker.orchestration.DockerOrchestrator;
import com.alexecollins.docker.orchestration.OrchestrationException;
import com.alexecollins.docker.orchestration.model.Id;
import com.alexecollins.docker.orchestration.model.LogPattern;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;

public class PatternMatchingStartupResultCallback
extends LogContainerResultCallback {
    private final Logger logger;
    private final Id id;
    private final StopWatch watch;
    private final List<LogPattern> pendingPatterns;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIAL);

    public PatternMatchingStartupResultCallback(Logger logger, List<LogPattern> pendingPatterns, Id id) {
        this.pendingPatterns = Collections.synchronizedList(Lists.newLinkedList(pendingPatterns));
        this.id = id;
        this.logger = logger;
        this.watch = new StopWatch();
        this.watch.start();
    }

    public void onNext(Frame item) {
        if (this.isCanceled()) {
            return;
        }
        String line = new String(item.getPayload()).trim();
        Iterator<LogPattern> iterator = this.pendingPatterns.iterator();
        while (iterator.hasNext()) {
            LogPattern logPattern = iterator.next();
            if (!logPattern.getPattern().matcher(line).find()) continue;
            this.logger.info("Waited {} for \"{}\"", (Object)this.watch, (Object)logPattern.getPattern().toString());
            iterator.remove();
        }
        if (this.pendingPatterns.isEmpty()) {
            this.watch.stop();
            this.onComplete();
            return;
        }
        for (LogPattern logPattern : this.pendingPatterns) {
            if (this.watch.getTime() < (long)logPattern.getTimeout()) continue;
            throw new OrchestrationException(String.format("timeout after %d while waiting for \"%s\" in %s's logs", logPattern.getTimeout(), logPattern.getPattern(), this.id));
        }
    }

    public void onComplete() {
        if (this.isCanceled() || this.isComplete()) {
            return;
        }
        this.state.compareAndSet(State.INITIAL, State.COMPLETE);
        if (!this.pendingPatterns.isEmpty()) {
            throw new OrchestrationException(String.format("%s's log ended before %s appeared in output", this.id, DockerOrchestrator.logPatternsToString(this.pendingPatterns)));
        }
        super.onComplete();
    }

    public boolean isComplete() {
        return this.state.get() == State.COMPLETE;
    }

    public void cancel() {
        this.state.compareAndSet(State.INITIAL, State.CANCELED);
    }

    public boolean isCanceled() {
        return this.state.get() == State.CANCELED;
    }

    private static enum State {
        INITIAL,
        COMPLETE,
        CANCELED;

    }
}

