/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration;

import com.alexecollins.docker.orchestration.Confs;
import com.alexecollins.docker.orchestration.OrchestrationException;
import com.alexecollins.docker.orchestration.model.Conf;
import com.alexecollins.docker.orchestration.model.ContainerConf;
import com.alexecollins.docker.orchestration.model.Id;
import com.alexecollins.docker.orchestration.util.Links;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Repo {
    private static final Logger LOG = LoggerFactory.getLogger(Repo.class);
    private static ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
    private final String user;
    private final String project;
    private final File src;
    private final Map<Id, Conf> confs = new LinkedHashMap<Id, Conf>();

    Repo(String user, String project, File src, Properties properties) {
        if (user == null) {
            throw new IllegalArgumentException("user is null");
        }
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        if (src == null) {
            throw new IllegalArgumentException("src is null");
        }
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("src " + src + " does not exist or is directory");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        this.user = user;
        this.project = project;
        this.src = src;
        if (src.isDirectory()) {
            this.readDockerConf(src, properties);
            this.ensureEmptyFolderConfs(src);
            this.readChildConfs(src, properties);
        }
    }

    private static Conf readConfFile(File confFile, Properties properties) throws IOException {
        return confFile.length() > 0L ? (Conf)MAPPER.readValue(Confs.replacingReader(confFile, properties), Conf.class) : new Conf();
    }

    private void readDockerConf(File src, Properties properties) {
        File dockerConf = new File(src, "docker.yml");
        if (dockerConf.exists()) {
            LOG.info("reading " + dockerConf);
            try {
                this.confs.putAll(Confs.read(dockerConf, properties));
            }
            catch (IOException e) {
                throw new OrchestrationException(e);
            }
        }
    }

    private void readChildConfs(File src, Properties properties) {
        for (Id id : this.confs.keySet()) {
            File confFile = new File(src, id + "/conf.yml");
            if (!confFile.exists()) continue;
            LOG.info("reading " + confFile);
            try {
                this.confs.put(id, Repo.readConfFile(confFile, properties));
            }
            catch (IOException e) {
                throw new OrchestrationException(e);
            }
        }
    }

    private void ensureEmptyFolderConfs(File src) {
        for (File file : src.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)) {
            Id id = new Id(file.getName());
            if (this.confs.containsKey(id)) continue;
            this.confs.put(id, new Conf());
        }
    }

    public String tag(Id id) {
        Conf conf = this.conf(id);
        return conf.hasTag() ? conf.getTag() : this.imageName(id);
    }

    public List<String> tags(Id id) {
        Conf conf = this.conf(id);
        return conf.hasTag() ? conf.getTags() : Collections.singletonList(this.imageName(id));
    }

    String imageName(Id id) {
        return this.user + "/" + this.project + "_" + id;
    }

    String containerName(Id id) {
        ContainerConf container = this.confs.get(id).getContainer();
        return container.hasName() ? container.getName() : this.defaultContainerName(id);
    }

    String defaultContainerName(Id id) {
        return "/" + this.project + "_" + id;
    }

    private File src() {
        return this.src;
    }

    File src(Id id) {
        return new File(this.src(), id.toString());
    }

    List<Id> ids(boolean reverse) {
        LinkedHashMap<Id, List<Id>> links = new LinkedHashMap<Id, List<Id>>();
        for (Id id : this.confs.keySet()) {
            links.put(id, Links.ids(this.confs.get(id).getLinks()));
        }
        List<Id> out = this.sort(links);
        if (reverse) {
            Collections.reverse(out);
        }
        return out;
    }

    List<Id> sort(Map<Id, List<Id>> links) {
        LinkedList<Id> in = new LinkedList<Id>(links.keySet());
        LinkedList<Id> out = new LinkedList<Id>();
        LinkedList linkErrors = Lists.newLinkedList();
        for (Map.Entry<Id, List<Id>> entry : links.entrySet()) {
            HashSet linkedImages = Sets.newHashSet((Iterable)entry.getValue());
            Sets.SetView difference = Sets.difference((Set)linkedImages, links.keySet());
            if (!difference.isEmpty()) {
                linkErrors.add("Missing linked containers in " + entry.getKey() + ": " + difference);
            }
            HashSet seenIds = Sets.newHashSet();
            for (Id id : linkedImages) {
                String linkName = id.toString().replaceFirst("[^:]+:", "");
                if (seenIds.contains(linkName)) {
                    linkErrors.add("Configuration for " + entry.getKey() + " contains " + linkName + " multiple times (" + id.toString() + ")");
                }
                seenIds.add(linkName);
            }
        }
        if (!linkErrors.isEmpty()) {
            throw new IllegalStateException(Joiner.on((char)'\n').join((Iterable)linkErrors));
        }
        while (!in.isEmpty()) {
            boolean hit = false;
            Iterator iterator = in.iterator();
            while (iterator.hasNext()) {
                Id id = (Id)iterator.next();
                if (!out.containsAll((Collection)links.get(id))) continue;
                out.add(id);
                iterator.remove();
                hit = true;
            }
            if (hit) continue;
            throw new IllegalStateException("dependency error (e.g. circular dependency) amongst " + in);
        }
        return out;
    }

    Conf conf(Id id) {
        return this.confs.get(id);
    }
}

