/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Frame;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;

class Tail
implements ResultCallback<Frame> {
    private final Logger logger;
    private final LogContainerCmd logContainerCmd;
    private int numLines = 0;
    private int maxLines = Integer.MAX_VALUE;
    private volatile boolean cancelled;

    Tail(DockerClient docker, Container container, Logger logger) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null");
        this.logger = logger;
        this.logContainerCmd = docker.logContainerCmd(container.getId()).withStdErr().withStdOut().withTailAll();
    }

    public void onStart(Closeable closeable) {
    }

    public void onNext(Frame object) {
        if (this.numLines < this.maxLines && !this.cancelled) {
            this.logger.info(object.toString());
            ++this.numLines;
        }
    }

    public void onError(Throwable throwable) {
        this.cancelled = true;
        throw new RuntimeException(throwable);
    }

    public void onComplete() {
    }

    public void close() throws IOException {
        this.cancelled = true;
    }

    void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public void start() {
        this.logContainerCmd.exec((ResultCallback)this);
    }
}

