/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration.util;

import com.alexecollins.docker.orchestration.util.PropertiesTokenResolver;
import com.alexecollins.docker.orchestration.util.TokenReplacingReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Comparator;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;

public final class Filters {
    private Filters() {
    }

    public static void filter(File file, FileFilter fileFilter, Properties properties) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file " + file + " does not exist");
        }
        if (fileFilter == null) {
            throw new IllegalArgumentException("fileFilter is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                Filters.filter(child, fileFilter, properties);
            }
        } else if (fileFilter.accept(file)) {
            File outFile = new File(file + ".tmp");
            try (TokenReplacingReader in = new TokenReplacingReader(new BufferedReader(new FileReader(file)), new PropertiesTokenResolver(properties));
                 FileWriter out = new FileWriter(outFile);){
                IOUtils.copy((Reader)in, (Writer)out);
            }
            Filters.move(outFile, file);
        }
    }

    public static String filter(String l, Properties properties) {
        try {
            return IOUtils.toString((Reader)new TokenReplacingReader(new StringReader(l), new PropertiesTokenResolver(properties)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void move(File from, File to) throws IOException {
        to.delete();
        if (!from.renameTo(to)) {
            throw new IOException("failed to move " + from + " to " + to);
        }
    }

    static int maxKeyLength(Properties properties) {
        TreeSet<Object> t = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        t.addAll(properties.keySet());
        return t.last().toString().length();
    }
}

