/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pinger {
    private static final Logger logger = LoggerFactory.getLogger(Pinger.class);

    private Pinger() {
    }

    public static boolean ping(URI uri, Pattern pattern, int timeout, boolean sslVerify) {
        long start = System.currentTimeMillis();
        while (!Pinger.ping(uri, pattern, sslVerify)) {
            if (System.currentTimeMillis() - start > (long)timeout) {
                return false;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static boolean ping(URI uri, int timeout) {
        return Pinger.ping(uri, null, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ping(URI uri, Pattern pattern, boolean sslVerify) {
        HttpURLConnection c = (HttpURLConnection)uri.toURL().openConnection();
        c.setRequestProperty("Accept", "*/*");
        if (c instanceof HttpsURLConnection && !sslVerify) {
            ((HttpsURLConnection)c).setSSLSocketFactory(Pinger.getInsecureSSLSocketFactory());
            ((HttpsURLConnection)c).setHostnameVerifier(Pinger.getInsecureHostnameVerifier());
        }
        c.connect();
        try {
            boolean bl = c.getResponseCode() == 200 && (pattern == null || pattern.matcher(Pinger.readAll(c.getInputStream())).find());
            c.disconnect();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                c.disconnect();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    private static String readAll(InputStream inputStream) {
        return new Scanner(inputStream).useDelimiter("\\A").next();
    }

    private static final SSLSocketFactory getInsecureSSLSocketFactory() {
        SSLSocketFactory sslSocketFactory = null;
        try {
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tm, null);
            return context.getSocketFactory();
        }
        catch (KeyManagementException e) {
            logger.error("Failed to initialise SSLContext", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("No TLS algorithm support", (Throwable)e);
        }
        return sslSocketFactory;
    }

    private static HostnameVerifier getInsecureHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }
}

