/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.orchestration.model;

import com.alexecollins.docker.orchestration.model.Id;

public class VolumeFrom {
    private final String value;

    public VolumeFrom(String value) {
        this.value = value;
    }

    public Id getId() {
        return new Id(this.value.replaceFirst(":.*", ""));
    }

    public boolean isReadWrite() {
        return !this.value.contains(":") || "rw".equals(this.value.replaceFirst(".*:", ""));
    }

    public boolean isReadOnly() {
        return this.value.contains(":") && "ro".equals(this.value.replaceFirst(".*:", ""));
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeFrom volume = (VolumeFrom)o;
        return this.value.equals(volume.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

