/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.mojo;

import com.alexecollins.docker.orchestration.DefinitionFilter;
import com.alexecollins.docker.orchestration.DockerOrchestrator;
import com.alexecollins.docker.orchestration.ExcludeFilter;
import com.alexecollins.docker.orchestration.model.BuildFlag;
import com.alexecollins.docker.util.MavenLogAppender;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class AbstractDockerMojo
extends AbstractMojo {
    @Parameter(property="docker.host")
    private String host;
    @Parameter(defaultValue="${project.artifactId}", property="docker.prefix")
    private String prefix;
    @Parameter(defaultValue="src/main/docker", property="docker.src")
    private String src;
    @Parameter(property="docker.version")
    private String version;
    @Parameter(property="docker.username", defaultValue="${user.name}")
    private String username;
    @Parameter(property="docker.password")
    private String password;
    @Parameter(property="docker.serverAddress")
    private String serverAddress;
    @Parameter(property="docker.email")
    private String email;
    @Parameter(defaultValue="false", property="docker.removeIntermediateImages")
    private boolean removeIntermediateImages;
    @Parameter(defaultValue="true", property="docker.cache")
    private boolean cache = true;
    @Parameter(defaultValue="false", property="docker.quiet")
    private boolean quiet;
    @Parameter(defaultValue="false", property="docker.pull")
    private boolean pull;
    @Parameter(defaultValue="false", property="docker.permissionErrorTolerant")
    private boolean permissionErrorTolerant;
    @Parameter(defaultValue="false", property="docker.skip")
    private boolean skip;
    @Parameter(defaultValue="", property="docker.exclude")
    private String exclude = "";
    @Parameter(property="docker.certPath")
    private String certificatePath;
    @Parameter(property="docker.cfgPath")
    private String cfgPath;
    @Parameter(defaultValue="true", property="docker.versionAutoDetect")
    private boolean versionAutoDetect;
    @Component
    private MavenProject project;

    AbstractDockerMojo() {
    }

    public MavenProject getProject() {
        return this.project;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogAppender.setLog(this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"skipped");
            return;
        }
        Properties properties = this.properties();
        this.getLog().debug((CharSequence)("properties filtering supported for " + properties.keySet()));
        try {
            DockerClient docker = this.dockerClient();
            this.getLog().info((CharSequence)("Docker version " + ((Version)docker.versionCmd().exec()).getVersion()));
            this.doExecute(this.dockerOrchestrator(properties, docker));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private DockerOrchestrator dockerOrchestrator(Properties properties, DockerClient docker) {
        return DockerOrchestrator.builder().docker(docker).src(this.src()).workDir(this.workDir()).rootDir(this.projDir()).user(this.username).project(this.prefix).properties(properties).buildFlags(this.buildFlags()).definitionFilter((DefinitionFilter)new ExcludeFilter(this.exclude.split(","))).permissionErrorTolerant(this.permissionErrorTolerant).build();
    }

    private Set<BuildFlag> buildFlags() {
        HashSet<BuildFlag> buildFlags = new HashSet<BuildFlag>();
        if (this.removeIntermediateImages) {
            buildFlags.add(BuildFlag.REMOVE_INTERMEDIATE_IMAGES);
        }
        if (!this.cache) {
            buildFlags.add(BuildFlag.NO_CACHE);
        }
        if (this.quiet) {
            buildFlags.add(BuildFlag.QUIET);
        }
        if (this.pull) {
            buildFlags.add(BuildFlag.PULL);
        }
        return buildFlags;
    }

    private DockerClient dockerClient() throws DockerException {
        DockerClientConfig.DockerClientConfigBuilder builder = DockerClientConfig.createDefaultConfigBuilder();
        if (this.host != null) {
            builder = builder.withUri(this.host);
        }
        if (this.version != null) {
            builder = builder.withVersion(this.version);
        }
        if (this.username != null) {
            builder = builder.withUsername(this.username);
        }
        if (this.password != null) {
            builder = builder.withPassword(this.password);
        }
        if (this.email != null) {
            builder = builder.withEmail(this.email);
        }
        if (this.serverAddress != null) {
            builder = builder.withServerAddress(this.serverAddress);
        }
        if (this.certificatePath != null) {
            builder = builder.withDockerCertPath(this.certificatePath);
        }
        if (this.cfgPath != null) {
            builder = builder.withDockerCfgPath(this.cfgPath);
        }
        if (this.versionAutoDetect) {
            DockerClient initialClient = DockerClientBuilder.getInstance((DockerClientConfig)builder.build()).build();
            VersionCmd versionCmd = initialClient.versionCmd();
            Version version = (Version)versionCmd.exec();
            builder = builder.withVersion(version.getApiVersion());
            return DockerClientBuilder.getInstance((DockerClientConfig)builder.build()).build();
        }
        return DockerClientBuilder.getInstance((DockerClientConfig)builder.build()).build();
    }

    private Properties properties() {
        Properties p = new Properties();
        p.putAll(System.getenv());
        String[] x = new String[]{"project.groupId", this.project.getGroupId(), "project.artifactId", this.project.getArtifactId(), "project.version", this.project.getVersion(), "project.name", this.project.getName(), "project.description", this.project.getDescription(), "project.build.finalName", this.project.getBuild().getFinalName()};
        for (int i = 0; i < x.length; i += 2) {
            if (x[i + 1] == null) continue;
            p.setProperty(x[i], x[i + 1]);
        }
        p.putAll((Map<?, ?>)this.project.getProperties());
        p.putAll((Map<?, ?>)System.getProperties());
        return p;
    }

    private File workDir() {
        return new File(this.project.getBuild().getDirectory(), "docker");
    }

    private File projDir() {
        return this.project.getBasedir();
    }

    private File src() {
        return new File(this.projDir(), this.src);
    }

    protected abstract void doExecute(DockerOrchestrator var1) throws Exception;
}

