/*
 * Decompiled with CFR 0.152.
 */
package com.alexecollins.docker.mojo;

import com.alexecollins.docker.mojo.AbstractDockerMojo;
import com.alexecollins.docker.orchestration.DockerOrchestrator;
import com.alexecollins.docker.orchestration.model.Id;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="save", defaultPhase=LifecyclePhase.PACKAGE)
public class SaveMojo
extends AbstractDockerMojo {
    @Parameter(defaultValue="${project.build.directory}/docker", property="docker.saveDir")
    private File saveDir;
    @Parameter(defaultValue="false", property="docker.gzipSave")
    private boolean gzipSave;
    @Parameter(defaultValue="false", property="docker.attach")
    private boolean attach;
    @Component
    private MavenProjectHelper mavenProjectHelper;

    @Override
    protected void doExecute(DockerOrchestrator orchestrator) {
        Map saved = orchestrator.save(this.saveDir, this.gzipSave);
        if (this.attach) {
            this.attachSavedFiles(saved);
        }
    }

    private void attachSavedFiles(Map<Id, File> saved) {
        for (Map.Entry<Id, File> save : saved.entrySet()) {
            File file = save.getValue();
            String extension = FilenameUtils.getExtension((String)file.getName());
            this.mavenProjectHelper.attachArtifact(this.getProject(), extension, save.getKey().toString(), file);
        }
    }
}

