/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.feign.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import io.seata.core.context.RootContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class SeataHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private final Logger logger = LoggerFactory.getLogger(SeataHystrixConcurrencyStrategy.class);
    private HystrixConcurrencyStrategy delegate;

    public SeataHystrixConcurrencyStrategy() {
        try {
            this.delegate = HystrixPlugins.getInstance().getConcurrencyStrategy();
            if (this.delegate instanceof SeataHystrixConcurrencyStrategy) {
                return;
            }
            HystrixCommandExecutionHook commandExecutionHook = HystrixPlugins.getInstance().getCommandExecutionHook();
            HystrixEventNotifier eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
            HystrixMetricsPublisher metricsPublisher = HystrixPlugins.getInstance().getMetricsPublisher();
            HystrixPropertiesStrategy propertiesStrategy = HystrixPlugins.getInstance().getPropertiesStrategy();
            this.logCurrentStateOfHystrixPlugins(eventNotifier, metricsPublisher, propertiesStrategy);
            HystrixPlugins.reset();
            HystrixPlugins.getInstance().registerConcurrencyStrategy((HystrixConcurrencyStrategy)this);
            HystrixPlugins.getInstance().registerCommandExecutionHook(commandExecutionHook);
            HystrixPlugins.getInstance().registerEventNotifier(eventNotifier);
            HystrixPlugins.getInstance().registerMetricsPublisher(metricsPublisher);
            HystrixPlugins.getInstance().registerPropertiesStrategy(propertiesStrategy);
        }
        catch (Exception ex) {
            this.logger.error("Failed to register Seata Hystrix Concurrency Strategy", (Throwable)ex);
        }
    }

    private void logCurrentStateOfHystrixPlugins(HystrixEventNotifier eventNotifier, HystrixMetricsPublisher metricsPublisher, HystrixPropertiesStrategy propertiesStrategy) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Current Hystrix plugins configuration is [concurrencyStrategy [" + this.delegate + "],eventNotifier [" + eventNotifier + "],metricPublisher [" + metricsPublisher + "],propertiesStrategy [" + propertiesStrategy + "],]");
            this.logger.debug("Registering Seata Hystrix Concurrency Strategy.");
        }
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixProperty<Integer> corePoolSize, HystrixProperty<Integer> maximumPoolSize, HystrixProperty<Integer> keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return this.delegate.getThreadPool(threadPoolKey, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        return this.delegate.getThreadPool(threadPoolKey, threadPoolProperties);
    }

    public BlockingQueue<Runnable> getBlockingQueue(int maxQueueSize) {
        return this.delegate.getBlockingQueue(maxQueueSize);
    }

    public <T> HystrixRequestVariable<T> getRequestVariable(HystrixRequestVariableLifecycle<T> rv) {
        return this.delegate.getRequestVariable(rv);
    }

    public <K> Callable<K> wrapCallable(Callable<K> c) {
        if (c instanceof SeataContextCallable) {
            return c;
        }
        Callable wrappedCallable = this.delegate != null ? this.delegate.wrapCallable(c) : c;
        if (wrappedCallable instanceof SeataContextCallable) {
            return wrappedCallable;
        }
        return new SeataContextCallable(wrappedCallable, RequestContextHolder.getRequestAttributes());
    }

    private static class SeataContextCallable<K>
    implements Callable<K> {
        private final Callable<K> actual;
        private final String xid;
        private final RequestAttributes requestAttributes;

        SeataContextCallable(Callable<K> actual, RequestAttributes requestAttribute) {
            this.actual = actual;
            this.requestAttributes = requestAttribute;
            this.xid = RootContext.getXID();
        }

        @Override
        public K call() throws Exception {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)this.requestAttributes);
                if (!StringUtils.isEmpty((Object)this.xid)) {
                    RootContext.bind((String)this.xid);
                }
                K k = this.actual.call();
                return k;
            }
            finally {
                if (!StringUtils.isEmpty((Object)this.xid)) {
                    RootContext.unbind();
                }
                RequestContextHolder.resetRequestAttributes();
            }
        }
    }
}

