/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.env;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="dubbo.cloud")
public class DubboCloudProperties {
    public static final String ALL_DUBBO_SERVICES = "*";
    private String subscribedServices = "*";
    private String registryType = "dubbo-cloud";

    public String getSubscribedServices() {
        return this.subscribedServices;
    }

    public void setSubscribedServices(String subscribedServices) {
        this.subscribedServices = subscribedServices;
    }

    public Set<String> subscribedServices() {
        String[] services = StringUtils.commaDelimitedListToStringArray((String)this.getSubscribedServices());
        if (services.length < 1) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> subscribedServices = new LinkedHashSet<String>();
        for (String service : services) {
            if (!StringUtils.hasText((String)service)) continue;
            subscribedServices.add(StringUtils.trimAllWhitespace((String)service));
        }
        return Collections.unmodifiableSet(subscribedServices);
    }

    public String getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(String registryType) {
        this.registryType = registryType;
    }
}

