/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.service;

import com.alibaba.cloud.dubbo.metadata.repository.ServiceInstanceSelector;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceInvocationHandler;
import com.alibaba.cloud.dubbo.util.DubboMetadataUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DubboMetadataServiceProxy
implements BeanClassLoaderAware,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DubboGenericServiceFactory dubboGenericServiceFactory;
    private final DubboMetadataUtils dubboMetadataUtils;
    private final ServiceInstanceSelector serviceInstanceSelector;
    private final DiscoveryClient discoveryClient;
    private final Map<String, DubboMetadataService> dubboMetadataServiceCache = new ConcurrentHashMap<String, DubboMetadataService>();
    private ClassLoader classLoader;

    public DubboMetadataServiceProxy(DubboGenericServiceFactory dubboGenericServiceFactory, DubboMetadataUtils dubboMetadataUtils, ServiceInstanceSelector serviceInstanceSelector, DiscoveryClient discoveryClient) {
        this.dubboGenericServiceFactory = dubboGenericServiceFactory;
        this.dubboMetadataUtils = dubboMetadataUtils;
        this.serviceInstanceSelector = serviceInstanceSelector;
        this.discoveryClient = discoveryClient;
    }

    public void removeProxy(String serviceName) {
        this.dubboMetadataServiceCache.remove(serviceName);
        this.dubboGenericServiceFactory.destroy(serviceName);
    }

    public DubboMetadataService getProxy(List<ServiceInstance> serviceInstances) {
        int attempts = serviceInstances.size();
        for (int i = 0; i < attempts; ++i) {
            Optional<ServiceInstance> serviceInstance = this.select(serviceInstances);
            if (!serviceInstance.isPresent()) continue;
            List<URL> dubboMetadataServiceURLs = this.getDubboMetadataServiceURLs(serviceInstance.get());
            for (URL dubboMetadataServiceURL : dubboMetadataServiceURLs) {
                DubboMetadataService dubboMetadataService = this.createProxyIfAbsent(dubboMetadataServiceURL);
                if (dubboMetadataService == null) continue;
                return dubboMetadataService;
            }
        }
        return null;
    }

    public boolean isInitialized(String serviceName) {
        return this.dubboMetadataServiceCache.containsKey(serviceName);
    }

    private DubboMetadataService createProxyIfAbsent(URL dubboMetadataServiceURL) {
        String serviceName = dubboMetadataServiceURL.getParameter("application");
        String version = dubboMetadataServiceURL.getParameter("version");
        return this.createProxyIfAbsent(serviceName, version);
    }

    private DubboMetadataService createProxyIfAbsent(String serviceName, String version) {
        return this.dubboMetadataServiceCache.computeIfAbsent(serviceName, name -> this.createProxy((String)name, version));
    }

    private Optional<ServiceInstance> select(List<ServiceInstance> serviceInstances) {
        return this.serviceInstanceSelector.select(serviceInstances);
    }

    private List<URL> getDubboMetadataServiceURLs(ServiceInstance serviceInstance) {
        return this.dubboMetadataUtils.getDubboMetadataServiceURLs(serviceInstance);
    }

    public DubboMetadataService getProxy(String serviceName) {
        return this.dubboMetadataServiceCache.getOrDefault(serviceName, this.getProxy0(serviceName));
    }

    private DubboMetadataService getProxy0(String serviceName) {
        return this.getProxy(this.discoveryClient.getInstances(serviceName));
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void destroy() throws Exception {
        this.dubboMetadataServiceCache.clear();
    }

    protected DubboMetadataService createProxy(String serviceName, String version) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The metadata of Dubbo service[name : {}] is about to be initialized", (Object)serviceName);
        }
        return (DubboMetadataService)Proxy.newProxyInstance(this.classLoader, new Class[]{DubboMetadataService.class}, (InvocationHandler)new DubboMetadataServiceInvocationHandler(serviceName, version, this.dubboGenericServiceFactory));
    }
}

