/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.JodaSupport;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplCalendar;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplInstant;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptional;
import com.alibaba.fastjson2.writer.ObjectWriterImplZonedDateTime;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;

public interface FieldWriter<T>
extends Comparable {
    public String getFieldName();

    public Class getFieldClass();

    default public ObjectWriter getInitWriter() {
        return null;
    }

    default public boolean isFieldClassSerializable() {
        return false;
    }

    default public boolean unwrapped() {
        return false;
    }

    public Type getFieldType();

    default public Type getItemType() {
        return null;
    }

    default public Class getItemClass() {
        return null;
    }

    default public int ordinal() {
        return -1;
    }

    default public Field getField() {
        return null;
    }

    default public String getLabel() {
        return null;
    }

    default public Method getMethod() {
        return null;
    }

    default public Member getFieldOrMethod() {
        Field field = this.getField();
        if (field != null) {
            return field;
        }
        return this.getMethod();
    }

    default public long getFeatures() {
        return 0L;
    }

    default public Object getFieldValue(T object) {
        throw new UnsupportedOperationException();
    }

    default public int compareTo(Object o) {
        String otherName;
        FieldWriter otherFieldWriter = (FieldWriter)o;
        String thisName = this.getFieldName();
        int nameCompare = thisName.compareTo(otherName = otherFieldWriter.getFieldName());
        if (nameCompare != 0) {
            int otherOrdinal;
            int thisOrdinal = this.ordinal();
            if (thisOrdinal < (otherOrdinal = otherFieldWriter.ordinal())) {
                return -1;
            }
            if (thisOrdinal > otherOrdinal) {
                return 1;
            }
        } else {
            Member thisMember = this.getFieldOrMethod();
            Member otherMember = otherFieldWriter.getFieldOrMethod();
            if (thisMember instanceof Field && otherMember instanceof Method) {
                return -1;
            }
            if (thisMember instanceof Method && otherMember instanceof Field) {
                return 1;
            }
        }
        if (nameCompare != 0) {
            return nameCompare;
        }
        Class otherFieldClass = otherFieldWriter.getFieldClass();
        Class thisFieldClass = this.getFieldClass();
        if (thisFieldClass != otherFieldClass && thisFieldClass != null && otherFieldClass != null) {
            if (thisFieldClass.isAssignableFrom(otherFieldClass)) {
                return 1;
            }
            if (otherFieldClass.isAssignableFrom(thisFieldClass)) {
                return -1;
            }
        }
        if (thisFieldClass == Boolean.TYPE) {
            return 1;
        }
        if (otherFieldClass == Boolean.TYPE) {
            return -1;
        }
        return nameCompare;
    }

    public void writeFieldName(JSONWriter var1);

    public void writeEnumJSONB(JSONWriter var1, Enum var2);

    default public void writeEnum(JSONWriter jsonWriter, Enum e) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeEnum(e);
    }

    default public void writeBinary(JSONWriter jsonWriter, byte[] value) {
        block6: {
            block7: {
                block5: {
                    if (value == null && !jsonWriter.isWriteNulls()) {
                        return;
                    }
                    this.writeFieldName(jsonWriter);
                    if (!"base64".equals(this.getFormat())) break block5;
                    jsonWriter.writeBase64(value);
                    break block6;
                }
                if (!"gzip,base64".equals(this.getFormat())) break block7;
                GZIPOutputStream gzipOut = null;
                try {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    gzipOut = value.length < 512 ? new GZIPOutputStream((OutputStream)byteOut, value.length) : new GZIPOutputStream(byteOut);
                    gzipOut.write(value);
                    gzipOut.finish();
                    value = byteOut.toByteArray();
                }
                catch (IOException ex) {
                    try {
                        throw new JSONException("write gzipBytes error", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(gzipOut);
                        throw throwable;
                    }
                }
                IOUtils.close(gzipOut);
                jsonWriter.writeBase64(value);
                break block6;
            }
            jsonWriter.writeBinary(value);
        }
    }

    default public void writeInt16(JSONWriter jsonWriter, short[] value) {
        if (value == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt16(value);
    }

    default public void writeInt32(JSONWriter jsonWriter, int value) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt32(value);
    }

    default public void writeInt64(JSONWriter jsonWriter, long value) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt64(value);
    }

    default public void writeString(JSONWriter jsonWriter, String value) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(value);
    }

    default public void writeString(JSONWriter jsonWriter, char[] value) {
        if (value == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(value);
    }

    default public void writeFloat(JSONWriter jsonWriter, float value) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeFloat(value);
    }

    default public void writeDouble(JSONWriter jsonWriter, double value) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDouble(value);
    }

    default public void writeDate(JSONWriter jsonWriter, Date value) {
        if (value == null) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeNull();
            return;
        }
        this.writeDate(jsonWriter, value.getTime());
    }

    default public void writeBool(JSONWriter jsonWriter, boolean value) {
        throw new UnsupportedOperationException();
    }

    default public void writeBool(JSONWriter jsonWriter, boolean[] value) {
        if (value == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeBool(value);
    }

    default public void writeFloat(JSONWriter jsonWriter, float[] value) {
        if (value == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeFloat(value);
    }

    default public void writeDouble(JSONWriter jsonWriter, double[] value) {
        if (value == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDouble(value);
    }

    default public void writeDate(JSONWriter jsonWriter, boolean writeFieldName, Date value) {
        if (value == null) {
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeNull();
            return;
        }
        this.writeDate(jsonWriter, writeFieldName, value.getTime());
    }

    default public void writeDate(JSONWriter jsonWriter, long millis) {
        this.writeDate(jsonWriter, true, millis);
    }

    default public boolean isDateFormatMillis() {
        return false;
    }

    default public boolean isDateFormatISO8601() {
        return false;
    }

    default public String getFormat() {
        return null;
    }

    default public void writeDate(JSONWriter jsonWriter, boolean writeFieldName, long millis) {
        if (jsonWriter.isJSONB()) {
            jsonWriter.writeMillis(millis);
            return;
        }
        int SECONDS_PER_DAY = 86400;
        JSONWriter.Context ctx = jsonWriter.getContext();
        if (this.isDateFormatMillis() || ctx.isDateFormatMillis()) {
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeInt64(millis);
            return;
        }
        ZoneId zoneId = ctx.getZoneId();
        String dateFormat = ctx.getDateFormat();
        if (dateFormat == null) {
            long yearEst;
            long doyEst;
            Instant instant = Instant.ofEpochMilli(millis);
            long epochSecond = instant.getEpochSecond();
            ZoneOffset offset = zoneId.getRules().getOffset(instant);
            long localSecond = epochSecond + (long)offset.getTotalSeconds();
            long localEpochDay = Math.floorDiv(localSecond, 86400L);
            int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
            int DAYS_PER_CYCLE = 146097;
            long DAYS_0000_TO_1970 = 719528L;
            long zeroDay = localEpochDay + 719528L;
            long adjust = 0L;
            if ((zeroDay -= 60L) < 0L) {
                long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
                adjust = adjustCycles * 400L;
                zeroDay += -adjustCycles * 146097L;
            }
            if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
                doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
            }
            yearEst += adjust;
            int marchDoy0 = (int)doyEst;
            int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
            int month = (marchMonth0 + 2) % 12 + 1;
            int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
            int year = ChronoField.YEAR.checkValidIntValue(yearEst += (long)(marchMonth0 / 10));
            int MINUTES_PER_HOUR = 60;
            int SECONDS_PER_MINUTE = 60;
            int SECONDS_PER_HOUR = 3600;
            long secondOfDay = secsOfDay;
            ChronoField.SECOND_OF_DAY.checkValidValue(secondOfDay);
            int hours = (int)(secondOfDay / 3600L);
            int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
            int hour = hours;
            int minute = minutes;
            int second = (int)(secondOfDay -= (long)(minutes * 60));
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
        } else {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
            if (this.isDateFormatISO8601() || ctx.isDateFormatISO8601()) {
                int year = zdt.getYear();
                int month = zdt.getMonthValue();
                int dayOfMonth = zdt.getDayOfMonth();
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                int milliSeconds = zdt.getNano() / 1000000;
                int offsetSeconds = zdt.getOffset().getTotalSeconds();
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, milliSeconds, offsetSeconds);
                return;
            }
            String str = ctx.getDateFormatter().format(zdt);
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeString(str);
        }
    }

    default public ObjectWriter getItemWriter(JSONWriter writer, Type itemType) {
        return writer.getObjectWriter(itemType, null);
    }

    public void writeValue(JSONWriter var1, T var2);

    public boolean write(JSONWriter var1, T var2);

    default public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        return jsonWriter.getObjectWriter(valueClass);
    }

    default public void writeList(JSONWriter jsonWriter, boolean writeFieldName, List list) {
        throw new UnsupportedOperationException();
    }

    default public void writeListStr(JSONWriter jsonWriter, boolean writeFieldName, List<String> list) {
        throw new UnsupportedOperationException();
    }

    public static ObjectWriter getObjectWriter(Type fieldType, Class fieldClass, String format, Locale locale, Class valueClass) {
        String className;
        if (Map.class.isAssignableFrom(valueClass)) {
            if (fieldClass.isAssignableFrom(valueClass)) {
                return ObjectWriterImplMap.of(fieldType, valueClass);
            }
            return ObjectWriterImplMap.of(valueClass);
        }
        if (Calendar.class.isAssignableFrom(valueClass)) {
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplCalendar.INSTANCE;
            }
            return new ObjectWriterImplCalendar(format, locale);
        }
        if (ZonedDateTime.class.isAssignableFrom(valueClass)) {
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplZonedDateTime.INSTANCE;
            }
            return new ObjectWriterImplZonedDateTime(format, locale);
        }
        if (LocalDateTime.class.isAssignableFrom(valueClass)) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(LocalDateTime.class);
            if (objectWriter != null && objectWriter != ObjectWriterImplLocalDateTime.INSTANCE) {
                return objectWriter;
            }
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplLocalDateTime.INSTANCE;
            }
            return new ObjectWriterImplLocalDateTime(format, locale);
        }
        if (LocalDate.class.isAssignableFrom(valueClass)) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(LocalDate.class);
            if (objectWriter != null && objectWriter != ObjectWriterImplLocalDate.INSTANCE) {
                return objectWriter;
            }
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplLocalDate.INSTANCE;
            }
            return new ObjectWriterImplLocalDate(format, locale);
        }
        if (LocalTime.class.isAssignableFrom(valueClass)) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(LocalTime.class);
            if (objectWriter != null && objectWriter != ObjectWriterImplLocalTime.INSTANCE) {
                return objectWriter;
            }
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplLocalTime.INSTANCE;
            }
            return new ObjectWriterImplLocalTime(format, locale);
        }
        if (Instant.class == valueClass) {
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplInstant.INSTANCE;
            }
            return new ObjectWriterImplInstant(format, locale);
        }
        if (Optional.class == valueClass) {
            return ObjectWriterImplOptional.of(format, locale);
        }
        switch (className = valueClass.getName()) {
            case "java.sql.Time": {
                return JdbcSupport.createTimeWriter(format);
            }
            case "java.sql.Date": {
                return new ObjectWriterImplDate(format, locale);
            }
            case "java.sql.Timestamp": {
                return JdbcSupport.createTimestampWriter(valueClass, format);
            }
            case "org.joda.time.LocalDate": {
                return JodaSupport.createLocalDateWriter(valueClass, format);
            }
            case "org.joda.time.LocalDateTime": {
                return JodaSupport.createLocalDateTimeWriter(valueClass, format);
            }
        }
        return null;
    }
}

