/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.util.Objects;

final class NullSchema
extends JSONSchema {
    NullSchema(JSONObject input) {
        super(input);
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Null;
    }

    @Override
    public ValidateResult validate(Object value) {
        if (value == null) {
            return SUCCESS;
        }
        return new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.Null, value.getClass()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullSchema that = (NullSchema)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description);
    }
}

