/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.util.JDKUtils;
import java.util.Arrays;

final class JSONWriterUTF16JDK8
extends JSONWriterUTF16 {
    JSONWriterUTF16JDK8(JSONWriter.Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        char c3;
        char c2;
        char c1;
        char c0;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        char[] value = JDKUtils.getCharArray(str);
        int strlen = value.length;
        boolean escape = false;
        int i = 0;
        while (i + 8 <= strlen) {
            c0 = value[i];
            c1 = value[i + 1];
            c2 = value[i + 2];
            c3 = value[i + 3];
            char c4 = value[i + 4];
            char c5 = value[i + 5];
            char c6 = value[i + 6];
            char c7 = value[i + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote) {
                escape = true;
                break;
            }
            if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\') {
                escape = true;
                break;
            }
            if (c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ') {
                escape = true;
                break;
            }
            i += 8;
        }
        if (!escape) {
            while (i + 4 <= strlen) {
                c0 = value[i];
                c1 = value[i + 1];
                c2 = value[i + 2];
                c3 = value[i + 3];
                if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote) {
                    escape = true;
                    break;
                }
                if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\') {
                    escape = true;
                    break;
                }
                if (c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ') {
                    escape = true;
                    break;
                }
                i += 4;
            }
        }
        if (!escape && i + 2 <= strlen) {
            c0 = value[i];
            c1 = value[i + 1];
            if (c0 == this.quote || c1 == this.quote || c0 == '\\' || c1 == '\\' || c0 < ' ' || c1 < ' ') {
                escape = true;
            } else {
                i += 2;
            }
        }
        if (!escape && i + 1 == strlen) {
            c0 = value[i];
            boolean bl = escape = c0 == this.quote || c0 == '\\' || c0 < ' ';
        }
        if (!escape) {
            int minCapacity = this.off + strlen + 2;
            if (minCapacity - this.chars.length > 0) {
                int oldCapacity = this.chars.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                if (newCapacity - MAX_ARRAY_SIZE > 0) {
                    throw new OutOfMemoryError();
                }
                this.chars = Arrays.copyOf(this.chars, newCapacity);
            }
            this.chars[this.off++] = this.quote;
            System.arraycopy(value, 0, this.chars, this.off, value.length);
            this.off += strlen;
            this.chars[this.off++] = this.quote;
            return;
        }
        this.ensureCapacity(this.off + strlen * 2 + 2);
        this.chars[this.off++] = this.quote;
        block15: for (i = 0; i < strlen; ++i) {
            char ch = value[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == this.quote) {
                        this.chars[this.off++] = 92;
                    }
                    this.chars[this.off++] = ch;
                    continue block15;
                }
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block15;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block15;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block15;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block15;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block15;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block15;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(48 + ch);
                    continue block15;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(97 + (ch - 10));
                    continue block15;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(48 + (ch - 16));
                    continue block15;
                }
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(97 + (ch - 26));
                    continue block15;
                }
                default: {
                    this.chars[this.off++] = ch;
                }
            }
        }
        this.chars[this.off++] = this.quote;
    }
}

