/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;

final class ObjectReaderImplEnum2X4
implements ObjectReader {
    final Class enumClass;
    final long typeNameHash;
    protected final Enum enum0;
    protected final Enum enum1;
    protected long enumNameHashCode00;
    protected long enumNameHashCode01;
    protected long enumNameHashCode10;
    protected long enumNameHashCode11;

    public ObjectReaderImplEnum2X4(Class enumClass, Enum[] enums, Enum[] ordinalEnums, long[] enumNameHashCodes) {
        this.enumClass = enumClass;
        this.typeNameHash = Fnv.hashCode64(TypeUtils.getTypeName(enumClass));
        this.enum0 = ordinalEnums[0];
        this.enum1 = ordinalEnums[1];
        int enum0Index = 0;
        int enum1Index = 0;
        for (int i = 0; i < enumNameHashCodes.length; ++i) {
            long hash = enumNameHashCodes[i];
            Enum e = enums[i];
            if (e == this.enum0) {
                if (enum0Index++ == 0) {
                    this.enumNameHashCode00 = hash;
                    continue;
                }
                this.enumNameHashCode01 = hash;
                continue;
            }
            if (e != this.enum1) continue;
            if (enum1Index++ == 0) {
                this.enumNameHashCode10 = hash;
                continue;
            }
            this.enumNameHashCode11 = hash;
        }
    }

    public Class getObjectClass() {
        return this.enumClass;
    }

    public Enum getEnumByHashCode(long hashCode) {
        if (hashCode == this.enumNameHashCode00) {
            return this.enum0;
        }
        if (hashCode == this.enumNameHashCode01) {
            return this.enum1;
        }
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        long hashCodeLCase;
        long hashCode;
        int ordinal;
        boolean isInt;
        long typeNameHash;
        byte type = jsonReader.getType();
        if (jsonReader.nextIfMatch((byte)-110) && (typeNameHash = jsonReader.readTypeHashCode()) != this.typeNameHash) {
            throw new JSONException(jsonReader.info("not support enumType : " + jsonReader.getString()));
        }
        boolean bl = isInt = type >= -16 && type <= 72;
        Enum fieldValue = isInt ? ((ordinal = jsonReader.readInt32Value()) == 0 ? this.enum0 : (ordinal == 1 ? this.enum1 : null)) : (this.enumNameHashCode00 == (hashCode = jsonReader.readValueHashCode()) || this.enumNameHashCode01 == hashCode ? this.enum0 : (this.enumNameHashCode10 == hashCode || this.enumNameHashCode11 == hashCode ? this.enum1 : (this.enumNameHashCode00 == (hashCodeLCase = jsonReader.getNameHashCodeLCase()) || this.enumNameHashCode01 == hashCodeLCase ? this.enum0 : (this.enumNameHashCode10 == hashCodeLCase || this.enumNameHashCode11 == hashCodeLCase ? this.enum1 : null))));
        return fieldValue;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        long hashCodeLCase;
        long hashCode;
        int ordinal;
        Enum fieldValue = jsonReader.isInt() ? ((ordinal = jsonReader.readInt32Value()) == 0 ? this.enum0 : (ordinal == 1 ? this.enum1 : null)) : (this.enumNameHashCode00 == (hashCode = jsonReader.readValueHashCode()) || this.enumNameHashCode01 == hashCode ? this.enum0 : (this.enumNameHashCode10 == hashCode || this.enumNameHashCode11 == hashCode ? this.enum1 : (this.enumNameHashCode00 == (hashCodeLCase = jsonReader.getNameHashCodeLCase()) || this.enumNameHashCode01 == hashCodeLCase ? this.enum0 : (this.enumNameHashCode10 == hashCodeLCase || this.enumNameHashCode11 == hashCodeLCase ? this.enum1 : null))));
        return fieldValue;
    }
}

