/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

final class FieldWriterStringField<T>
extends FieldWriterImpl<T> {
    final Field field;
    final boolean symbol;
    final boolean trim;
    final boolean raw;

    protected FieldWriterStringField(String fieldName, int ordinal, long features, String format, String label, Field field) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)String.class), String.class);
        this.field = field;
        this.symbol = "symbol".equals(format);
        this.trim = "trim".equals(format);
        this.raw = (features & 0x4000000000000L) != 0L;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        String value = (String)this.getFieldValue((Object)object);
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) == 0L || (features & JSONWriter.Feature.NotWriteDefaultValue.mask) != 0L) {
                return false;
            }
            if (value == null && (features & (JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeString("");
                return true;
            }
        }
        if (this.trim && value != null) {
            value = value.trim();
        }
        this.writeString(jsonWriter, value);
        return true;
    }

    @Override
    public void writeString(JSONWriter jsonWriter, String value) {
        this.writeFieldName(jsonWriter);
        if (this.trim) {
            value = value.trim();
        }
        if (this.symbol && jsonWriter.isJSONB()) {
            jsonWriter.writeSymbol(value);
        } else if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, Object object) {
        String value = (String)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        if (this.trim) {
            value = value.trim();
        }
        if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
    }
}

