/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.FloatingDecimal;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReaderASCII;
import com.alibaba.fastjson2.JSONReaderJSONB;
import com.alibaba.fastjson2.JSONReaderUTF16;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.ReferenceKey;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class JSONReader
implements Closeable {
    static final int MAX_EXP = 1023;
    static final long SHANGHAI_ZONE_ID_HASH = Fnv.hashCode64("Asia/Shanghai");
    static final long LONG_MASK = 0xFFFFFFFFL;
    static final byte JSON_TYPE_INT = 1;
    static final byte JSON_TYPE_DEC = 2;
    static final byte JSON_TYPE_STRING = 3;
    static final byte JSON_TYPE_BOOL = 4;
    static final byte JSON_TYPE_NULL = 5;
    static final byte JSON_TYPE_OBJECT = 6;
    static final byte JSON_TYPE_ARRAY = 7;
    static final byte JSON_TYPE_BIG_DEC = 8;
    static final byte JSON_TYPE_INT8 = 9;
    static final byte JSON_TYPE_INT16 = 10;
    static final byte JSON_TYPE_INT64 = 11;
    static final byte JSON_TYPE_FLOAT = 12;
    static final byte JSON_TYPE_DOUBLE = 13;
    static final char EOI = '\u001a';
    static final long SPACE = 4294981376L;
    final Context context;
    List<ResolveTask> resolveTasks;
    protected int offset;
    protected char ch;
    protected boolean comma;
    protected boolean nameEscape;
    protected boolean valueEscape;
    protected boolean wasNull;
    protected boolean boolValue;
    protected boolean negative;
    protected byte valueType;
    protected short exponent;
    protected byte scale;
    protected int mag0;
    protected int mag1;
    protected int mag2;
    protected int mag3;
    protected String stringValue;
    protected Object complex;
    protected boolean typeRedirect;

    public final char current() {
        return this.ch;
    }

    public final boolean isEnd() {
        return this.ch == '\u001a';
    }

    public byte getType() {
        return -128;
    }

    public boolean isInt() {
        return this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9';
    }

    public abstract boolean isNull();

    public boolean hasComma() {
        return this.comma;
    }

    public abstract Date readNullOrNewDate();

    public abstract boolean nextIfNull();

    public JSONReader(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isEnabled(Feature feature) {
        return (this.context.features & feature.mask) != 0L;
    }

    public Locale getLocale() {
        return this.context.getLocale();
    }

    public ZoneId getZoneId() {
        return this.context.getZoneId();
    }

    public long features(long features) {
        return this.context.features | features;
    }

    public void handleResolveTasks(Object root) {
        if (this.resolveTasks == null) {
            return;
        }
        Object previous = null;
        for (ResolveTask resolveTask : this.resolveTasks) {
            Object fieldValue;
            JSONPath path = resolveTask.reference;
            FieldReader fieldReader = resolveTask.fieldReader;
            if (path.isPrevious()) {
                fieldValue = previous;
            } else {
                if (!path.isRef()) {
                    throw new JSONException("reference path invalid : " + path);
                }
                path.setReaderContext(this.context);
                if ((this.context.features & Feature.FieldBased.mask) != 0L) {
                    JSONWriter.Context writeContext = JSONFactory.createWriteContext();
                    writeContext.features |= JSONWriter.Feature.FieldBased.mask;
                    path.setWriterContext(writeContext);
                }
                previous = fieldValue = path.eval(root);
            }
            Object resolvedName = resolveTask.name;
            Object resolvedObject = resolveTask.object;
            if (resolvedName != null) {
                if (resolvedObject instanceof Map) {
                    Map map = (Map)resolvedObject;
                    if (resolvedName instanceof ReferenceKey) {
                        if (map instanceof LinkedHashMap) {
                            int size = map.size();
                            if (size == 0) continue;
                            Object[] keys = new Object[size];
                            Object[] values = new Object[size];
                            int index = 0;
                            for (Map.Entry o : map.entrySet()) {
                                Map.Entry entry = o;
                                Object entryKey = entry.getKey();
                                keys[index] = resolvedName == entryKey ? fieldValue : entryKey;
                                values[index++] = entry.getValue();
                            }
                            map.clear();
                            for (int j = 0; j < keys.length; ++j) {
                                map.put(keys[j], values[j]);
                            }
                            continue;
                        }
                        map.put(fieldValue, map.remove(resolvedName));
                        continue;
                    }
                    map.put(resolvedName, fieldValue);
                    continue;
                }
                if (resolvedName instanceof Integer) {
                    if (resolvedObject instanceof List) {
                        int index = (Integer)resolvedName;
                        List list = (List)resolvedObject;
                        list.set(index, fieldValue);
                        continue;
                    }
                    if (resolvedObject instanceof Object[]) {
                        int index = (Integer)resolvedName;
                        Object[] array = (Object[])resolvedObject;
                        array[index] = fieldValue;
                        continue;
                    }
                    if (resolvedObject instanceof Collection) {
                        Collection collection = (Collection)resolvedObject;
                        collection.add(fieldValue);
                        continue;
                    }
                }
            }
            fieldReader.accept(resolvedObject, fieldValue);
        }
    }

    public ObjectReader getObjectReader(Type type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectReader(type, fieldBased);
    }

    public boolean isSupportSmartMatch() {
        return (this.context.features & Feature.SupportSmartMatch.mask) != 0L;
    }

    public boolean isSupportSmartMatch(long features) {
        return ((this.context.features | features) & Feature.SupportSmartMatch.mask) != 0L;
    }

    public boolean isSupportBeanArray() {
        return (this.context.features & Feature.SupportArrayToBean.mask) != 0L;
    }

    public boolean isSupportBeanArray(long features) {
        return ((this.context.features | features) & Feature.SupportArrayToBean.mask) != 0L;
    }

    public boolean isSupportAutoType(long features) {
        return ((this.context.features | features) & Feature.SupportAutoType.mask) != 0L;
    }

    public boolean isJSONB() {
        return false;
    }

    public boolean isIgnoreNoneSerializable() {
        return (this.context.features & Feature.IgnoreNoneSerializable.mask) != 0L;
    }

    public ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        return null;
    }

    static char char1(int c) {
        switch (c) {
            case 48: {
                return '\u0000';
            }
            case 49: {
                return '\u0001';
            }
            case 50: {
                return '\u0002';
            }
            case 51: {
                return '\u0003';
            }
            case 52: {
                return '\u0004';
            }
            case 53: {
                return '\u0005';
            }
            case 54: {
                return '\u0006';
            }
            case 55: {
                return '\u0007';
            }
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 118: {
                return '\u000b';
            }
            case 70: 
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 64: 
            case 91: 
            case 92: 
            case 93: {
                return (char)c;
            }
        }
        throw new JSONException("unclosed.str.lit " + (char)c);
    }

    static char char2(int c1, int c2) {
        return (char)(JSONFactory.DIGITS2[c1] * 16 + JSONFactory.DIGITS2[c2]);
    }

    static char char4(int c1, int c2, int c3, int c4) {
        return (char)(JSONFactory.DIGITS2[c1] * 4096 + JSONFactory.DIGITS2[c2] * 256 + JSONFactory.DIGITS2[c3] * 16 + JSONFactory.DIGITS2[c4]);
    }

    public boolean nextIfObjectStart() {
        if (this.ch != '{') {
            return false;
        }
        this.next();
        return true;
    }

    public abstract boolean nextIfEmptyString();

    public boolean nextIfObjectEnd() {
        if (this.ch != '}') {
            return false;
        }
        this.next();
        return true;
    }

    public int startArray() {
        this.next();
        return 0;
    }

    public abstract boolean isReference();

    public abstract String readReference();

    public void addResolveTask(FieldReader fieldReader, Object object, JSONPath path) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(fieldReader, object, fieldReader.getFieldName(), path));
    }

    public void addResolveTask(Map object, Object key, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        if (object instanceof LinkedHashMap) {
            object.put(key, null);
        }
        this.resolveTasks.add(new ResolveTask(null, object, key, reference));
    }

    public void addResolveTask(Collection object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public void addResolveTask(Object[] object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public boolean isArray() {
        return this.ch == '[';
    }

    public boolean isObject() {
        return this.ch == '{';
    }

    public boolean isNumber() {
        switch (this.ch) {
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return this.ch == '\"' || this.ch == '\'';
    }

    public void endArray() {
        this.next();
    }

    public abstract boolean nextIfMatch(char var1);

    public abstract boolean nextIfSet();

    public abstract String readPattern();

    public final int getOffset() {
        return this.offset;
    }

    public abstract void next();

    public abstract long readValueHashCode();

    public long readTypeHashCode() {
        return this.readValueHashCode();
    }

    public abstract long readFieldNameHashCode();

    public abstract long getNameHashCodeLCase();

    public abstract String readFieldName();

    public abstract String getFieldName();

    public void setTypeRedirect(boolean typeRedirect) {
        this.typeRedirect = typeRedirect;
    }

    public boolean isTypeRedirect() {
        return this.typeRedirect;
    }

    public abstract long readFieldNameHashCodeUnquote();

    public String readFieldNameUnquote() {
        this.readFieldNameHashCodeUnquote();
        return this.getFieldName();
    }

    public abstract boolean skipName();

    public abstract void skipValue();

    public boolean isBinary() {
        return false;
    }

    public byte[] readBinary() {
        if (this.isString()) {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            if ((this.context.features & Feature.Base64StringAsByteArray.mask) != 0L) {
                return Base64.getDecoder().decode(str);
            }
            throw new JSONException(this.info("not support input " + str));
        }
        if (this.nextIfMatch('[')) {
            int index = 0;
            byte[] bytes = new byte[64];
            while (true) {
                if (this.ch == ']') break;
                if (index == bytes.length) {
                    int oldCapacity = bytes.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    bytes = Arrays.copyOf(bytes, newCapacity);
                }
                bytes[index++] = (byte)this.readInt32Value();
            }
            this.next();
            this.nextIfMatch(',');
            return Arrays.copyOf(bytes, index);
        }
        throw new JSONException(this.info("not support read binary"));
    }

    public abstract int readInt32Value();

    public boolean nextIfMatch(byte type) {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4, char var5, char var6);

    public abstract Integer readInt32();

    public int getInt32Value() {
        switch (this.valueType) {
            case 1: {
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? -this.mag3 : this.mag3;
                }
                return this.getNumber().intValue();
            }
            case 2: {
                return this.getNumber().intValue();
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                return 0;
            }
            case 3: {
                return this.toInt32(this.stringValue);
            }
            case 6: {
                Number num = this.toNumber((Map)this.complex);
                if (num != null) {
                    return num.intValue();
                }
                return 0;
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    protected long getInt64Value() {
        switch (this.valueType) {
            case 2: {
                return this.getNumber().longValue();
            }
            case 4: {
                return this.boolValue ? 1L : 0L;
            }
            case 5: {
                return 0L;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toLong((Map)this.complex);
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
        }
        throw new JSONException("TODO");
    }

    protected Long getInt64() {
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? (long)(-this.mag3) : (long)this.mag3;
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == Integer.MIN_VALUE && this.mag3 == 0 && !this.negative) {
                            return Long.MIN_VALUE;
                        }
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return this.negative ? -v23 : v23;
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                return JSONReader.getBigInt(this.negative, mag).longValue();
            }
            case 2: {
                return this.getNumber().longValue();
            }
            case 4: {
                return this.boolValue ? 1L : 0L;
            }
            case 5: {
                return null;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                Number num = this.toNumber((Map)this.complex);
                if (num != null) {
                    return num.longValue();
                }
                return null;
            }
        }
        throw new JSONException("TODO");
    }

    public abstract long readInt64Value();

    public abstract Long readInt64();

    public abstract float readFloatValue();

    public Float readFloat() {
        this.wasNull = false;
        float value = this.readFloatValue();
        if (this.wasNull) {
            return null;
        }
        return Float.valueOf(value);
    }

    public abstract double readDoubleValue();

    public Double readDouble() {
        this.wasNull = false;
        double value = this.readDoubleValue();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    public Number readNumber() {
        this.readNumber0();
        return this.getNumber();
    }

    public BigInteger readBigInteger() {
        this.readNumber0();
        return this.getBigInteger();
    }

    public BigDecimal readBigDecimal() {
        this.readNumber0();
        return this.getBigDecimal();
    }

    public abstract UUID readUUID();

    public boolean isLocalDate() {
        LocalDate localDate;
        if (!this.isString()) {
            return false;
        }
        int len = this.getStringLength();
        switch (len) {
            case 8: {
                localDate = this.readLocalDate8();
                break;
            }
            case 9: {
                localDate = this.readLocalDate9();
                break;
            }
            case 10: {
                localDate = this.readLocalDate10();
                break;
            }
            case 11: {
                localDate = this.readLocalDate11();
                break;
            }
            default: {
                return false;
            }
        }
        return localDate != null;
    }

    public LocalDate readLocalDate() {
        String str;
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDate();
        }
        if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            LocalDateTime ldt = null;
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 19: {
                    ldt = this.readLocalDateTime19();
                    break;
                }
                default: {
                    if (len <= 20) break;
                    ldt = this.readLocalDateTimeX(len);
                }
            }
            if (ldt != null) {
                return ldt.toLocalDate();
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            return null;
        }
        DateTimeFormatter formatter = this.context.getDateFormatter();
        if (formatter != null) {
            if (this.context.formatHasHour) {
                return LocalDateTime.parse(str, formatter).toLocalDate();
            }
            return LocalDate.parse(str, formatter);
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDate();
        }
        throw new JSONException("not support input : " + str);
    }

    public boolean isLocalDateTime() {
        if (!this.isString()) {
            return false;
        }
        int len = this.getStringLength();
        switch (len) {
            case 16: {
                return this.readLocalDateTime16() != null;
            }
            case 17: {
                return this.readLocalDateTime17() != null;
            }
            case 18: {
                return this.readLocalDateTime18() != null;
            }
            case 19: {
                return this.readLocalDateTime19() != null;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return this.readLocalDateTimeX(len) != null;
            }
        }
        return false;
    }

    public LocalDateTime readLocalDateTime() {
        String str;
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDateTime();
        }
        if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 16: {
                    return this.readLocalDateTime16();
                }
                case 17: {
                    return this.readLocalDateTime17();
                }
                case 18: {
                    return this.readLocalDateTime18();
                }
                case 19: {
                    return this.readLocalDateTime19();
                }
                case 20: {
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.toLocalDateTime();
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    LocalDateTime ldt = this.readLocalDateTimeX(len);
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.toLocalDateTime();
                }
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            this.wasNull = true;
            return null;
        }
        DateTimeFormatter formatter = this.context.getDateFormatter();
        if (formatter != null) {
            if (!this.context.formatHasHour) {
                return LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN);
            }
            return LocalDateTime.parse(str, formatter);
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, this.context.getZoneId());
        }
        throw new JSONException(this.info("read LocalDateTime error " + str));
    }

    public ZonedDateTime readZonedDateTime() {
        if (this.isInt()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return instant.atZone(this.context.getZoneId());
        }
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            LocalDate localDate;
            if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
                int len = this.getStringLength();
                LocalDateTime ldt = null;
                switch (len) {
                    case 8: {
                        localDate = this.readLocalDate8();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 9: {
                        localDate = this.readLocalDate9();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 10: {
                        localDate = this.readLocalDate10();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 11: {
                        localDate = this.readLocalDate11();
                        ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 16: {
                        ldt = this.readLocalDateTime16();
                        break;
                    }
                    case 17: {
                        ldt = this.readLocalDateTime17();
                        break;
                    }
                    case 18: {
                        ldt = this.readLocalDateTime18();
                        break;
                    }
                    case 19: {
                        ldt = this.readLocalDateTime19();
                        break;
                    }
                    default: {
                        ZonedDateTime zdt = this.readZonedDateTimeX(len);
                        if (zdt == null) break;
                        return zdt;
                    }
                }
                if (ldt != null) {
                    return ZonedDateTime.ofLocal(ldt, this.context.getZoneId(), null);
                }
            }
            if ((str = this.readString()).isEmpty() || "null".equals(str)) {
                return null;
            }
            DateTimeFormatter formatter = this.context.getDateFormatter();
            if (formatter != null) {
                if (!this.context.formatHasHour) {
                    localDate = LocalDate.parse(str, formatter);
                    return ZonedDateTime.of(localDate, LocalTime.MIN, this.context.getZoneId());
                }
                LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
                return ZonedDateTime.of(localDateTime, this.context.getZoneId());
            }
            if (IOUtils.isNumber(str)) {
                long millis = Long.parseLong(str);
                if (this.context.formatUnixTime) {
                    millis *= 1000L;
                }
                Instant instant = Instant.ofEpochMilli(millis);
                return instant.atZone(this.context.getZoneId());
            }
            return ZonedDateTime.parse(str);
        }
        throw new JSONException("TODO : " + this.ch);
    }

    public LocalTime readLocalTime() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalTime();
        }
        int len = this.getStringLength();
        switch (len) {
            case 5: {
                return this.readLocalTime5();
            }
            case 8: {
                return this.readLocalTime8();
            }
            case 10: {
                return this.readLocalTime10();
            }
            case 11: {
                return this.readLocalTime11();
            }
            case 12: {
                return this.readLocalTime12();
            }
            case 18: {
                return this.readLocalTime18();
            }
            case 19: {
                return this.readLocalDateTime19().toLocalTime();
            }
        }
        String str = this.readString();
        if (str.isEmpty() || "null".equals(str)) {
            return null;
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalTime();
        }
        throw new JSONException("not support len : " + len);
    }

    protected abstract int getStringLength();

    public Instant readInstant() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isNumber()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            return Instant.ofEpochMilli(millis);
        }
        if (this.isObject()) {
            return (Instant)this.getObjectReader((Type)((Object)Instant.class)).createInstance(this.readObject(), 0L);
        }
        ZonedDateTime zdt = this.readZonedDateTime();
        if (zdt == null) {
            return null;
        }
        return Instant.ofEpochSecond(zdt.toEpochSecond(), zdt.toLocalTime().getNano());
    }

    public long readMillisFromString() {
        String str;
        String format = this.context.dateFormat;
        if (format == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            LocalDateTime ldt = null;
            LocalDate localDate = null;
            switch (len) {
                case 8: {
                    localDate = this.readLocalDate8();
                    if (localDate == null) {
                        throw new JSONException("TODO : " + this.readString());
                    }
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 9: {
                    localDate = this.readLocalDate9();
                    if (localDate == null) break;
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 10: {
                    localDate = this.readLocalDate10();
                    if (localDate == null) {
                        String str2 = this.readString();
                        if ("0000-00-00".equals(str2)) {
                            return 0L;
                        }
                        if (IOUtils.isNumber(str2)) {
                            return Long.parseLong(str2);
                        }
                        throw new JSONException("TODO : " + str2);
                    }
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 11: {
                    localDate = this.readLocalDate11();
                    if (localDate == null) break;
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 16: {
                    ldt = this.readLocalDateTime16();
                    break;
                }
                case 17: {
                    ldt = this.readLocalDateTime17();
                    break;
                }
                case 18: {
                    ldt = this.readLocalDateTime18();
                    break;
                }
                case 19: {
                    long millis = this.readMillis19();
                    if (millis != 0L || !this.wasNull) {
                        return millis;
                    }
                    ldt = this.readLocalDateTime19();
                }
            }
            ZonedDateTime zdt = null;
            if (ldt != null) {
                zdt = ZonedDateTime.ofLocal(ldt, this.context.getZoneId(), null);
            } else if (len >= 20) {
                zdt = this.readZonedDateTimeX(len);
            }
            if (zdt != null) {
                long seconds = zdt.toEpochSecond();
                int nanos = zdt.toLocalTime().getNano();
                if (seconds < 0L && nanos > 0) {
                    long millis = (seconds + 1L) * 1000L;
                    long adjustment = nanos / 1000000 - 1000;
                    return millis + adjustment;
                }
                long millis = seconds * 1000L;
                return millis + (long)(nanos / 1000000);
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            this.wasNull = true;
            return 0L;
        }
        if (this.context.formatMillis || this.context.formatUnixTime) {
            long millis = Long.parseLong(str);
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            return millis;
        }
        if (format != null && !format.isEmpty()) {
            SimpleDateFormat utilFormat = new SimpleDateFormat(format);
            try {
                return utilFormat.parse(str).getTime();
            }
            catch (ParseException e) {
                throw new JSONException("parse date error, " + str + ", expect format " + utilFormat);
            }
        }
        if ("0000-00-00T00:00:00".equals(str) || "0001-01-01T00:00:00+08:00".equals(str)) {
            return 0L;
        }
        if (str.startsWith("/Date(") && str.endsWith(")/")) {
            String dotnetDateStr = str.substring(6, str.length() - 2);
            int i = dotnetDateStr.indexOf(43);
            if (i == -1) {
                i = dotnetDateStr.indexOf(45);
            }
            if (i != -1) {
                dotnetDateStr = dotnetDateStr.substring(0, i);
            }
            return Long.parseLong(dotnetDateStr);
        }
        if (IOUtils.isNumber(str)) {
            return Long.parseLong(str);
        }
        throw new JSONException(this.info("format " + format + " not support, input " + str));
    }

    protected abstract LocalDateTime readLocalDateTime16();

    protected abstract LocalDateTime readLocalDateTime17();

    protected abstract LocalDateTime readLocalDateTime18();

    protected abstract LocalDateTime readLocalDateTime19();

    public abstract long readMillis19();

    protected abstract LocalDateTime readLocalDateTimeX(int var1);

    protected abstract LocalTime readLocalTime5();

    protected abstract LocalTime readLocalTime8();

    protected abstract LocalTime readLocalTime10();

    protected abstract LocalTime readLocalTime11();

    protected abstract LocalTime readLocalTime12();

    protected abstract LocalTime readLocalTime18();

    protected abstract LocalDate readLocalDate8();

    protected abstract LocalDate readLocalDate9();

    protected abstract LocalDate readLocalDate10();

    protected abstract LocalDate readLocalDate11();

    protected abstract ZonedDateTime readZonedDateTimeX(int var1);

    protected long millis(int year, int month, int dom, int hour, int minute, int second, int nanoOfSecond) {
        ZoneId zoneId = this.context.getZoneId();
        if (zoneId == IOUtils.SHANGHAI_ZONE_ID || zoneId.getRules() == IOUtils.SHANGHAI_ZONE_RULES) {
            long SECONDS_1991_09_15_02 = 684900000L;
            long SECONDS_1991_04_14_03 = 671598000L;
            long SECONDS_1990_09_16_02 = 653450400L;
            long SECONDS_1990_04_15_03 = 640148400L;
            long SECONDS_1989_09_17_02 = 622000800L;
            long SECONDS_1989_04_16_03 = 608698800L;
            long SECONDS_1988_09_11_02 = 589946400L;
            long SECONDS_1988_04_17_03 = 577249200L;
            long SECONDS_1987_09_13_02 = 558496800L;
            long SECONDS_1987_04_12_03 = 545194800L;
            long SECONDS_1986_09_14_02 = 527047200L;
            long SECONDS_1986_05_04_03 = 515559600L;
            long SECONDS_1949_05_28_00 = -649987200L;
            long SECONDS_1949_05_01_01 = -652316400L;
            long SECONDS_1948_10_01_00 = -670636800L;
            long SECONDS_1948_05_01_01 = -683852400L;
            long SECONDS_1947_11_01_00 = -699580800L;
            long SECONDS_1947_04_15_01 = -716857200L;
            long SECONDS_1946_10_01_00 = -733795200L;
            long SECONDS_1946_05_15_01 = -745801200L;
            long SECONDS_1945_09_02_00 = -767836800L;
            long SECONDS_1942_01_31_01 = -881017200L;
            long SECONDS_1941_11_02_00 = -888796800L;
            long SECONDS_1941_03_15_01 = -908838000L;
            long SECONDS_1940_10_13_00 = -922060800L;
            long SECONDS_1940_06_01_01 = -933634800L;
            long SECONDS_1919_10_01_00 = -1585872000L;
            long SECONDS_1919_04_13_01 = -1600642800L;
            long SECONDS_1901_01_01_00 = -2177452800L;
            int OFFSET_0900_TOTAL_SECONDS = 32400;
            int OFFSET_0543_TOTAL_SECONDS = 29143;
            long seconds = IOUtils.utcSeconds(year, month, dom, hour, minute, second);
            int zoneOffsetTotalSeconds = seconds >= SECONDS_1991_09_15_02 ? 28800 : (seconds >= SECONDS_1991_04_14_03 ? 32400 : (seconds >= SECONDS_1990_09_16_02 ? 28800 : (seconds >= SECONDS_1990_04_15_03 ? 32400 : (seconds >= SECONDS_1989_09_17_02 ? 28800 : (seconds >= SECONDS_1989_04_16_03 ? 32400 : (seconds >= SECONDS_1988_09_11_02 ? 28800 : (seconds >= SECONDS_1988_04_17_03 ? 32400 : (seconds >= SECONDS_1987_09_13_02 ? 28800 : (seconds >= SECONDS_1987_04_12_03 ? 32400 : (seconds >= SECONDS_1986_09_14_02 ? 28800 : (seconds >= SECONDS_1986_05_04_03 ? 32400 : (seconds >= SECONDS_1949_05_28_00 ? 28800 : (seconds >= SECONDS_1949_05_01_01 ? 32400 : (seconds >= SECONDS_1948_10_01_00 ? 28800 : (seconds >= SECONDS_1948_05_01_01 ? 32400 : (seconds >= SECONDS_1947_11_01_00 ? 28800 : (seconds >= SECONDS_1947_04_15_01 ? 32400 : (seconds >= SECONDS_1946_10_01_00 ? 28800 : (seconds >= SECONDS_1946_05_15_01 ? 32400 : (seconds >= SECONDS_1945_09_02_00 ? 28800 : (seconds >= SECONDS_1942_01_31_01 ? 32400 : (seconds >= SECONDS_1941_11_02_00 ? 28800 : (seconds >= SECONDS_1941_03_15_01 ? 32400 : (seconds >= SECONDS_1940_10_13_00 ? 28800 : (seconds >= SECONDS_1940_06_01_01 ? 32400 : (seconds >= SECONDS_1919_10_01_00 ? 28800 : (seconds >= SECONDS_1919_04_13_01 ? 32400 : (seconds >= SECONDS_1901_01_01_00 ? 28800 : 29143))))))))))))))))))))))))))));
            return (seconds -= (long)zoneOffsetTotalSeconds) * 1000L + (long)(nanoOfSecond / 1000000);
        }
        if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            long seconds = IOUtils.utcSeconds(year, month, dom, hour, minute, second);
            return seconds * 1000L + (long)(nanoOfSecond / 1000000);
        }
        LocalDate localDate = LocalDate.of(year, month, dom);
        LocalTime localTime = LocalTime.of(hour, minute, second, nanoOfSecond);
        LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
        ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
        long seconds = zdt.toEpochSecond();
        int nanos = nanoOfSecond;
        if (seconds < 0L && nanos > 0) {
            return (seconds + 1L) * 1000L + (long)(nanos / 1000000) - 1000L;
        }
        return seconds * 1000L + (long)(nanos / 1000000);
    }

    public void readNumber(ValueConsumer consumer, boolean quoted) {
        this.readNumber0();
        Number number = this.getNumber();
        consumer.accept(number);
    }

    public void readString(ValueConsumer consumer, boolean quoted) {
        String str = this.readString();
        if (quoted) {
            consumer.accept(JSON.toJSONString(str));
        } else {
            consumer.accept(str);
        }
    }

    protected abstract void readNumber0();

    public abstract String readString();

    public char readCharValue() {
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            this.wasNull = true;
            return '\u0000';
        }
        return str.charAt(0);
    }

    public abstract void readNull();

    public abstract boolean readIfNull();

    public abstract String getString();

    public boolean wasNull() {
        return this.wasNull;
    }

    public <T> T read(Type type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, null, null, 0L);
    }

    public void read(List list) {
        if (!this.nextIfMatch('[')) {
            throw new JSONException("illegal input, offset " + this.offset + ", char " + this.ch);
        }
        while (!this.nextIfMatch(']')) {
            Object item = this.readAny();
            list.add(item);
            if (!this.nextIfMatch(',')) continue;
        }
        this.nextIfMatch(',');
    }

    public void read(Collection list) {
        if (!this.nextIfMatch('[')) {
            throw new JSONException("illegal input, offset " + this.offset + ", char " + this.ch);
        }
        while (!this.nextIfMatch(']')) {
            Object item = this.readAny();
            list.add(item);
            if (!this.nextIfMatch(',')) continue;
        }
        this.nextIfMatch(',');
    }

    public void readObject(Object object, Feature ... features) {
        long featuresLong = 0L;
        for (Feature feature : features) {
            featuresLong |= feature.mask;
        }
        this.readObject(object, featuresLong);
    }

    public void readObject(Object object, long features) {
        boolean fieldBased;
        if (object == null) {
            throw new JSONException("object is null");
        }
        Class<?> objectClass = object.getClass();
        ObjectReader objectReader = this.context.provider.getObjectReader(objectClass, fieldBased = ((this.context.features | features) & Feature.FieldBased.mask) != 0L);
        if (objectReader instanceof ObjectReaderBean) {
            ObjectReaderBean objectReaderBean = (ObjectReaderBean)objectReader;
            objectReaderBean.readObject(this, object, features);
        } else if (object instanceof Map) {
            this.read((Map)object, features);
        } else {
            throw new JSONException("read object not support");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(Map object, long features) {
        boolean match = this.nextIfMatch('{');
        boolean typeRedirect = false;
        if (!match) {
            typeRedirect = this.isTypeRedirect();
            if (typeRedirect) {
                this.setTypeRedirect(false);
            } else {
                String str;
                if (!this.isString() || !(str = this.readString()).isEmpty()) throw new JSONException("illegal input\uff0c offset " + this.offset + ", char " + this.ch);
                return;
            }
        }
        int i = 0;
        while (true) {
            block26: {
                long contextFeatures;
                Object value;
                Object name;
                if (this.ch == '/') {
                    this.skipLineComment();
                }
                if (this.nextIfMatch('}')) return;
                if (i != 0 && !this.comma) {
                    throw new JSONException(this.info());
                }
                if (match || typeRedirect) {
                    name = this.readFieldName();
                } else {
                    name = this.getFieldName();
                    match = true;
                }
                if (name == null) {
                    if (this.isNumber()) {
                        name = this.readNumber();
                        if ((this.context.features & Feature.NonStringKeyAsString.mask) != 0L) {
                            name = name.toString();
                        }
                    } else {
                        if ((this.context.features & Feature.AllowUnQuotedFieldNames.mask) == 0L) throw new JSONException(this.info("not allow unquoted fieldName"));
                        name = this.readFieldNameUnquote();
                    }
                    if (this.ch == ':') {
                        this.next();
                    }
                }
                this.comma = false;
                switch (this.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = this.readNumber();
                        break;
                    }
                    case '[': {
                        value = this.readArray();
                        break;
                    }
                    case '{': {
                        value = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        value = this.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        value = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        value = this.readNullOrNewDate();
                        break;
                    }
                    case '/': {
                        this.next();
                        if (this.ch != '/') throw new JSONException("FASTJSON2.0.13input not support " + this.ch + ", offset " + this.offset);
                        this.skipLineComment();
                        break block26;
                    }
                    case 'S': {
                        if (!this.nextIfSet()) throw new JSONException("FASTJSON2.0.13error, offset " + this.offset + ", char " + this.ch);
                        value = this.read(HashSet.class);
                        break;
                    }
                    default: {
                        throw new JSONException("FASTJSON2.0.13error, offset " + this.offset + ", char " + this.ch);
                    }
                }
                Object origin = object.put(name, value);
                if (origin != null && ((contextFeatures = features | this.context.getFeatures()) & Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value);
                        object.put(name, value);
                    } else {
                        JSONArray array = JSONArray.of(origin, value);
                        object.put(name, array);
                    }
                }
            }
            ++i;
        }
    }

    public <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, null, null, 0L);
    }

    public Map<String, Object> readObject() {
        this.nextIfObjectStart();
        JSONObject object = this.context.objectSupplier == null ? ((this.context.features & Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject()) : this.context.objectSupplier.get();
        int i = 0;
        while (true) {
            block15: {
                Object val;
                if (this.ch == '}') break;
                String name = this.readFieldName();
                if (name == null) {
                    if (this.ch == '\u001a') {
                        throw new JSONException("input end");
                    }
                    name = this.readFieldNameUnquote();
                    this.nextIfMatch(':');
                }
                if (i == 0 && (this.context.features & Feature.ErrorOnNotSupportAutoType.mask) != 0L && "@type".equals(name)) {
                    String typeName = this.readString();
                    throw new JSONException("autoType not support : " + typeName);
                }
                switch (this.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.readNumber0();
                        val = this.getNumber();
                        break;
                    }
                    case '[': {
                        val = this.readArray();
                        break;
                    }
                    case '{': {
                        val = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = this.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        this.readNull();
                        val = null;
                        break;
                    }
                    case '/': {
                        this.next();
                        if (this.ch == '/') {
                            this.skipLineComment();
                        }
                        break block15;
                    }
                    default: {
                        throw new JSONException(this.info("illegal input " + this.ch));
                    }
                }
                object.put(name, val);
            }
            ++i;
        }
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return object;
    }

    public abstract void skipLineComment();

    public Boolean readBool() {
        if (this.isNull()) {
            this.readNull();
            return null;
        }
        boolean boolValue = this.readBoolValue();
        if (!boolValue && this.wasNull) {
            return null;
        }
        return boolValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readBoolValue() {
        boolean val;
        this.wasNull = false;
        if (this.ch == 't') {
            this.next();
            char c1 = this.ch;
            this.next();
            char c2 = this.ch;
            this.next();
            char c3 = this.ch;
            if (c1 != 'r' || c2 != 'u') {
                if (c3 != 'e') throw new JSONException("syntax error : " + this.ch);
            }
            val = true;
        } else if (this.ch == 'f') {
            this.next();
            char c1 = this.ch;
            this.next();
            char c2 = this.ch;
            this.next();
            char c3 = this.ch;
            this.next();
            char c4 = this.ch;
            if ((c1 != 'a' || c2 != 'l') && c3 != 's') {
                if (c4 != 'e') throw new JSONException("syntax error : " + this.ch);
            }
            val = false;
        } else {
            if (this.ch == '-' || this.ch >= '0' && this.ch <= '9') {
                this.readNumber();
                if (this.valueType != 1) return false;
                if (this.mag1 != 0) return false;
                if (this.mag2 != 0) return false;
                if (this.mag3 != 1) return false;
                return true;
            }
            if (this.ch == 'n') {
                this.wasNull = true;
                this.readNull();
                return false;
            }
            if (this.ch != '\"') throw new JSONException("syntax error : " + this.ch);
            int len = this.getStringLength();
            if (len == 1) {
                this.next();
                if (this.ch == '0' || this.ch == 'N') {
                    this.next();
                    this.next();
                    this.nextIfMatch(',');
                    return false;
                }
                if (this.ch != '1') {
                    if (this.ch != 'Y') throw new JSONException("can not convert to boolean : " + this.ch);
                }
                this.next();
                this.next();
                this.nextIfMatch(',');
                return true;
            }
            String str = this.readString();
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if ("false".equalsIgnoreCase(str)) {
                return false;
            }
            if (!str.isEmpty()) {
                if (!"null".equalsIgnoreCase(str)) throw new JSONException("can not convert to boolean : " + str);
            }
            this.wasNull = true;
            return false;
        }
        this.next();
        this.nextIfMatch(',');
        return val;
    }

    public Object readAny() {
        return this.read(Object.class);
    }

    public List readArray(Type itemType) {
        if (this.nextIfNull()) {
            return null;
        }
        ArrayList list = new ArrayList();
        if (!this.nextIfMatch('[')) {
            throw new JSONException("syntax error : " + this.ch);
        }
        while (!this.nextIfMatch(']')) {
            Object item = this.read(itemType);
            list.add(item);
            if (this.ch != '}' && this.ch != '\u001a') continue;
            throw new JSONException("illegal input : " + this.ch + ", offset " + this.getOffset());
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return list;
    }

    public void readArray(List list, Type itemType) {
        if (this.nextIfMatch('[')) {
            while (!this.nextIfMatch(']')) {
                Object item = this.read(itemType);
                list.add(item);
                if (this.ch != '}' && this.ch != '\u001a') continue;
                throw new JSONException(this.info());
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                this.next();
            }
            return;
        }
        if (this.isString()) {
            String str = this.readString();
            if (itemType == String.class) {
                list.add(str);
            } else {
                Function typeConvert = this.context.getProvider().getTypeConvert((Type)((Object)String.class), itemType);
                if (typeConvert == null) {
                    throw new JSONException(this.info("not support input " + str));
                }
                if (str.indexOf(44) != -1) {
                    String[] items;
                    for (String strItem : items = str.split(",")) {
                        Object item = typeConvert.apply(strItem);
                        list.add(item);
                    }
                } else {
                    Object item = typeConvert.apply(str);
                    list.add(item);
                }
            }
        } else {
            Object item = this.read(itemType);
            list.add(item);
        }
        if (this.comma = this.ch == ',') {
            this.next();
        }
    }

    public List readArray() {
        this.next();
        int i = 0;
        List<Object> list = null;
        Map<String, Object> first = null;
        Map<String, Object> second = null;
        block9: while (true) {
            Map<String, Object> val;
            switch (this.ch) {
                case ']': {
                    this.next();
                    break block9;
                }
                case '[': {
                    val = this.readArray();
                    break;
                }
                case '{': {
                    if (this.context.autoTypeBeforeHandler != null || (this.context.features & Feature.SupportAutoType.mask) != 0L) {
                        val = ObjectReaderImplObject.INSTANCE.readObject(this, null, null, 0L);
                        break;
                    }
                    val = this.readObject();
                    break;
                }
                case '\"': 
                case '\'': {
                    val = this.readString();
                    break;
                }
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.readNumber0();
                    val = this.getNumber();
                    break;
                }
                case 'f': 
                case 't': {
                    val = this.readBoolValue();
                    break;
                }
                case 'n': {
                    this.readNull();
                    val = null;
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + this.ch);
                }
            }
            if (i == 0) {
                first = val;
            } else if (i == 1) {
                second = val;
            } else if (i == 2) {
                list = this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray();
                list.add(first);
                list.add(second);
                list.add(val);
            } else {
                list.add(val);
            }
            ++i;
        }
        if (list == null) {
            if (this.context.arraySupplier != null) {
                list = this.context.arraySupplier.get();
            } else if (this.context.isEnabled(Feature.UseNativeObject)) {
                list = i == 2 ? new ArrayList(2) : new ArrayList(1);
            } else {
                JSONArray jSONArray = list = i == 2 ? new JSONArray(2) : new JSONArray(1);
            }
            if (i == 1) {
                list.add(first);
            } else if (i == 2) {
                list.add(first);
                list.add(second);
            }
        }
        if (this.comma = this.ch == ',') {
            this.next();
        }
        return list;
    }

    public BigInteger getBigInteger() {
        Number number = this.getNumber();
        if (number == null) {
            return null;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public BigDecimal getBigDecimal() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    return BigDecimal.valueOf(this.negative ? (long)(-this.mag3) : (long)this.mag3);
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return BigDecimal.valueOf(this.negative ? -v23 : v23);
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                return new BigDecimal(JSONReader.getBigInt(this.negative, mag));
            }
            case 2: {
                BigDecimal decimal = null;
                if (this.exponent == 0 && this.mag0 == 0 && this.mag1 == 0) {
                    if (this.mag2 == 0 && this.mag3 >= 0) {
                        int unscaledVal = this.negative ? -this.mag3 : this.mag3;
                        decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                    } else {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            long unscaledVal = this.negative ? -v23 : v23;
                            decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                        }
                    }
                }
                if (decimal == null) {
                    int[] nArray;
                    if (this.mag0 == 0) {
                        if (this.mag1 == 0) {
                            if (this.mag2 == 0) {
                                int[] nArray2 = new int[1];
                                nArray = nArray2;
                                nArray2[0] = this.mag3;
                            } else {
                                int[] nArray3 = new int[2];
                                nArray3[0] = this.mag2;
                                nArray = nArray3;
                                nArray3[1] = this.mag3;
                            }
                        } else {
                            int[] nArray4 = new int[3];
                            nArray4[0] = this.mag1;
                            nArray4[1] = this.mag2;
                            nArray = nArray4;
                            nArray4[2] = this.mag3;
                        }
                    } else {
                        int[] nArray5 = new int[4];
                        nArray5[0] = this.mag0;
                        nArray5[1] = this.mag1;
                        nArray5[2] = this.mag2;
                        nArray = nArray5;
                        nArray5[3] = this.mag3;
                    }
                    int[] mag = nArray;
                    BigInteger bigInt = JSONReader.getBigInt(this.negative, mag);
                    decimal = new BigDecimal(bigInt, this.scale);
                }
                if (this.exponent != 0) {
                    double doubleValue = Double.parseDouble(decimal + "E" + this.exponent);
                    return BigDecimal.valueOf(doubleValue);
                }
                return decimal;
            }
            case 8: {
                return new BigDecimal(this.stringValue);
            }
            case 4: {
                return this.boolValue ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case 3: {
                try {
                    return new BigDecimal(this.stringValue);
                }
                catch (NumberFormatException ex) {
                    throw new JSONException(this.info("read decimal error, value " + this.stringValue), ex);
                }
            }
            case 6: {
                JSONObject object = (JSONObject)this.complex;
                BigDecimal decimal = object.getBigDecimal("value");
                if (decimal == null) {
                    decimal = object.getBigDecimal("$numberDecimal");
                }
                if (decimal != null) {
                    return decimal;
                }
                throw new JSONException("TODO : " + this.valueType);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public Number getNumber() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: 
            case 11: {
                int[] mag;
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    int intVlaue;
                    if (this.negative) {
                        if (this.mag3 < 0) {
                            return -((long)this.mag3 & 0xFFFFFFFFL);
                        }
                        intVlaue = -this.mag3;
                    } else {
                        if (this.mag3 < 0) {
                            return (long)this.mag3 & 0xFFFFFFFFL;
                        }
                        intVlaue = this.mag3;
                    }
                    if (this.valueType == 11) {
                        return (long)intVlaue;
                    }
                    return intVlaue;
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return this.negative ? -v23 : v23;
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                return JSONReader.getBigInt(this.negative, mag);
            }
            case 10: {
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    int intValue = this.negative ? -this.mag3 : this.mag3;
                    return (short)intValue;
                }
                throw new JSONException(this.info("shortValue overflow"));
            }
            case 9: {
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    int intValue = this.negative ? -this.mag3 : this.mag3;
                    return (byte)intValue;
                }
                throw new JSONException(this.info("shortValue overflow"));
            }
            case 2: {
                BigDecimal decimal = null;
                if (this.mag0 == 0 && this.mag1 == 0) {
                    if (this.mag2 == 0 && this.mag3 >= 0) {
                        int unscaledVal;
                        int n = unscaledVal = this.negative ? -this.mag3 : this.mag3;
                        if (this.exponent == 0) {
                            if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                                switch (this.scale) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: {
                                        return Float.valueOf((float)((double)unscaledVal / JSONFactory.SMALL_10_POW[this.scale]));
                                    }
                                }
                            } else if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                                switch (this.scale) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 11: 
                                    case 12: 
                                    case 13: 
                                    case 14: 
                                    case 15: {
                                        return (double)unscaledVal / JSONFactory.SMALL_10_POW[this.scale];
                                    }
                                }
                            }
                        }
                        decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                    } else {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long unscaledVal;
                            long v23 = (v2 << 32) + v3;
                            long l = unscaledVal = this.negative ? -v23 : v23;
                            if (this.exponent == 0) {
                                if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                                    switch (this.scale) {
                                        case 1: 
                                        case 2: 
                                        case 3: 
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 7: 
                                        case 8: 
                                        case 9: 
                                        case 10: {
                                            return Float.valueOf((float)((double)unscaledVal / JSONFactory.SMALL_10_POW[this.scale]));
                                        }
                                    }
                                    boolean isNegative = unscaledVal < 0L;
                                    int len = isNegative ? IOUtils.stringSize(-unscaledVal) + 1 : IOUtils.stringSize(unscaledVal);
                                    char[] chars = new char[len];
                                    IOUtils.getChars(unscaledVal, len, chars);
                                    return Float.valueOf(FloatingDecimal.floatValue(isNegative, this.scale, chars, len));
                                }
                                if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                                    switch (this.scale) {
                                        case 1: 
                                        case 2: 
                                        case 3: 
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 7: 
                                        case 8: 
                                        case 9: 
                                        case 10: {
                                            return (double)unscaledVal / JSONFactory.SMALL_10_POW[this.scale];
                                        }
                                    }
                                    boolean isNegative = unscaledVal < 0L;
                                    int len = isNegative ? IOUtils.stringSize(-unscaledVal) + 1 : IOUtils.stringSize(unscaledVal);
                                    char[] chars = new char[len];
                                    IOUtils.getChars(unscaledVal, len, chars);
                                    return FloatingDecimal.doubleValue(isNegative, this.scale, chars, len);
                                }
                            }
                            decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                        }
                    }
                }
                if (decimal == null) {
                    int[] nArray;
                    if (this.mag0 == 0) {
                        if (this.mag1 == 0) {
                            if (this.mag2 == 0) {
                                int[] nArray2 = new int[1];
                                nArray = nArray2;
                                nArray2[0] = this.mag3;
                            } else {
                                int[] nArray3 = new int[2];
                                nArray3[0] = this.mag2;
                                nArray = nArray3;
                                nArray3[1] = this.mag3;
                            }
                        } else {
                            int[] nArray4 = new int[3];
                            nArray4[0] = this.mag1;
                            nArray4[1] = this.mag2;
                            nArray = nArray4;
                            nArray4[2] = this.mag3;
                        }
                    } else {
                        int[] nArray5 = new int[4];
                        nArray5[0] = this.mag0;
                        nArray5[1] = this.mag1;
                        nArray5[2] = this.mag2;
                        nArray = nArray5;
                        nArray5[3] = this.mag3;
                    }
                    int[] mag = nArray;
                    BigInteger bigInt = JSONReader.getBigInt(this.negative, mag);
                    int adjustedScale = this.scale - this.exponent;
                    decimal = new BigDecimal(bigInt, adjustedScale);
                }
                if (this.exponent != 0) {
                    double doubleValue = Double.parseDouble(decimal + "E" + this.exponent);
                    return doubleValue;
                }
                if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                    return Float.valueOf(decimal.floatValue());
                }
                if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                    return decimal.doubleValue();
                }
                return decimal;
            }
            case 8: {
                if (this.scale > 0) {
                    return new BigDecimal(this.stringValue);
                }
                return new BigInteger(this.stringValue);
            }
            case 12: 
            case 13: {
                int[] nArray;
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == 0) {
                            int[] nArray6 = new int[1];
                            nArray = nArray6;
                            nArray6[0] = this.mag3;
                        } else {
                            int[] nArray7 = new int[2];
                            nArray7[0] = this.mag2;
                            nArray = nArray7;
                            nArray7[1] = this.mag3;
                        }
                    } else {
                        int[] nArray8 = new int[3];
                        nArray8[0] = this.mag1;
                        nArray8[1] = this.mag2;
                        nArray = nArray8;
                        nArray8[2] = this.mag3;
                    }
                } else {
                    int[] nArray9 = new int[4];
                    nArray9[0] = this.mag0;
                    nArray9[1] = this.mag1;
                    nArray9[2] = this.mag2;
                    nArray = nArray9;
                    nArray9[3] = this.mag3;
                }
                int[] mag = nArray;
                BigInteger bigInt = JSONReader.getBigInt(this.negative, mag);
                BigDecimal decimal = new BigDecimal(bigInt, this.scale);
                if (this.valueType == 12) {
                    if (this.exponent != 0) {
                        float floatValueValue = Float.parseFloat(decimal + "E" + this.exponent);
                        return Float.valueOf(floatValueValue);
                    }
                    return Float.valueOf(decimal.floatValue());
                }
                if (this.exponent != 0) {
                    double doubleValue = Double.parseDouble(decimal + "E" + this.exponent);
                    return doubleValue;
                }
                return decimal.doubleValue();
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                return null;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toNumber((Map)this.complex);
            }
            case 7: {
                return this.toNumber((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    @Override
    public abstract void close();

    static BigInteger getBigInt(boolean negative, int[] mag) {
        int bitLength;
        int signum;
        int n = mag.length == 0 ? 0 : (signum = negative ? -1 : 1);
        if (mag.length == 0) {
            bitLength = 0;
        } else {
            int bitLengthForInt = 32 - Integer.numberOfLeadingZeros(mag[0]);
            int magBitLength = (mag.length - 1 << 5) + bitLengthForInt;
            if (signum < 0) {
                boolean pow2 = Integer.bitCount(mag[0]) == 1;
                for (int i = 1; i < mag.length && pow2; ++i) {
                    pow2 = mag[i] == 0;
                }
                bitLength = pow2 ? magBitLength - 1 : magBitLength;
            } else {
                bitLength = magBitLength;
            }
        }
        int byteLen = bitLength / 8 + 1;
        byte[] bytes = new byte[byteLen];
        int bytesCopied = 4;
        int nextInt = 0;
        int intIndex = 0;
        for (int i = byteLen - 1; i >= 0; --i) {
            if (bytesCopied == 4) {
                int n2;
                if ((n2 = intIndex++) < 0) {
                    nextInt = 0;
                } else if (n2 >= mag.length) {
                    nextInt = signum < 0 ? -1 : 0;
                } else {
                    int magInt = mag[mag.length - n2 - 1];
                    if (signum >= 0) {
                        nextInt = magInt;
                    } else {
                        int j;
                        int mlen = mag.length;
                        for (j = mlen - 1; j >= 0 && mag[j] == 0; --j) {
                        }
                        int firstNonzeroIntNum = mlen - j - 1;
                        nextInt = n2 <= firstNonzeroIntNum ? -magInt : ~magInt;
                    }
                }
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                ++bytesCopied;
            }
            bytes[i] = (byte)nextInt;
        }
        return new BigInteger(bytes);
    }

    protected final int toInt32(String val) {
        if (IOUtils.isNumber(val)) {
            return Integer.parseInt(val);
        }
        throw new JSONException("parseInt error, value : " + val);
    }

    protected final long toInt64(String val) {
        if (IOUtils.isNumber(val)) {
            return Long.parseLong(val);
        }
        throw new JSONException("parseLong error, value : " + val);
    }

    protected final long toLong(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw new JSONException("parseLong error, value : " + map);
    }

    protected final int toInt(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
        }
        throw new JSONException("parseLong error, field : value " + list);
    }

    protected final Number toNumber(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return (Number)val;
        }
        return null;
    }

    protected final Number toNumber(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return (Number)val;
            }
            if (val instanceof String) {
                return new BigDecimal((String)val);
            }
        }
        return null;
    }

    protected final String toString(List array) {
        JSONWriter writer = JSONWriter.of();
        writer.write(array);
        return writer.toString();
    }

    protected final String toString(Map object) {
        JSONWriter writer = JSONWriter.of();
        writer.write(object);
        return writer.toString();
    }

    public static JSONReader of(byte[] utf8Bytes) {
        Context context = JSONFactory.createReadContext();
        return new JSONReaderUTF8(context, utf8Bytes, 0, utf8Bytes.length);
    }

    public static JSONReader of(Context context, byte[] utf8Bytes) {
        return new JSONReaderUTF8(context, utf8Bytes, 0, utf8Bytes.length);
    }

    public static JSONReader of(char[] chars) {
        return new JSONReaderUTF16(JSONFactory.createReadContext(), null, chars, 0, chars.length);
    }

    public static JSONReader of(Context context, char[] chars) {
        return new JSONReaderUTF16(context, null, chars, 0, chars.length);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(Context context, byte[] jsonbBytes) {
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes, Feature ... features) {
        Context context = JSONFactory.createReadContext();
        context.config(features);
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), bytes, offset, length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length, SymbolTable symbolTable) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(symbolTable), bytes, offset, length);
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Charset charset) {
        Context ctx = JSONFactory.createReadContext();
        if (charset == StandardCharsets.UTF_8) {
            return new JSONReaderUTF8(ctx, bytes, offset, length);
        }
        if (charset == StandardCharsets.UTF_16) {
            return new JSONReaderUTF16(ctx, bytes, offset, length);
        }
        if (charset == StandardCharsets.US_ASCII || charset == StandardCharsets.ISO_8859_1) {
            return new JSONReaderASCII(ctx, null, bytes, offset, length);
        }
        throw new JSONException("not support charset " + charset);
    }

    public static JSONReader of(byte[] bytes, int offset, int length) {
        return new JSONReaderUTF8(JSONFactory.createReadContext(), bytes, offset, length);
    }

    public static JSONReader of(char[] chars, int offset, int length) {
        return new JSONReaderUTF16(JSONFactory.createReadContext(), null, chars, offset, length);
    }

    public static JSONReader of(InputStream is, Charset charset) {
        Context context = JSONFactory.createReadContext();
        if (charset == StandardCharsets.UTF_8 || charset == null) {
            return new JSONReaderUTF8(context, is);
        }
        if (charset == StandardCharsets.UTF_16) {
            return new JSONReaderUTF16(context, is);
        }
        throw new JSONException("not support charset " + charset);
    }

    public static JSONReader of(Reader is) {
        return new JSONReaderUTF16(JSONFactory.createReadContext(), is);
    }

    public static JSONReader of(Context context, String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        int length = str.length();
        char[] chars = str.toCharArray();
        return new JSONReaderUTF16(context, str, chars, 0, length);
    }

    public static JSONReader of(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        Context context = JSONFactory.createReadContext();
        int length = str.length();
        char[] chars = str.toCharArray();
        return new JSONReaderUTF16(context, str, chars, 0, length);
    }

    public static JSONReader of(String str, int offset, int length) {
        if (str == null) {
            throw new NullPointerException();
        }
        Context context = JSONFactory.createReadContext();
        char[] chars = str.toCharArray();
        return new JSONReaderUTF16(context, str, chars, offset, length);
    }

    public static JSONReader of(String str, int offset, int length, Context context) {
        if (str == null) {
            throw new NullPointerException();
        }
        char[] chars = str.toCharArray();
        return new JSONReaderUTF16(context, str, chars, offset, length);
    }

    void bigInt(char[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = chars[start++]) == '.') {
            c = chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = chars[index];
            if (c == '.') {
                c = chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = chars[start2++]) == '.') {
                c2 = chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = chars[index];
                if (c2 == '.') {
                    c2 = chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long product = 0L;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    void bigInt(byte[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = (char)chars[start++]) == '.') {
            c = (char)chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = (char)chars[index];
            if (c == '.') {
                c = (char)chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = (char)chars[start2++]) == '.') {
                c2 = (char)chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = (char)chars[index];
                if (c2 == '.') {
                    c2 = (char)chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long product = 0L;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    public static AutoTypeBeforeHandler autoTypeFilter(String ... names) {
        return new ContextAutoTypeBeforeHandler(names);
    }

    static LocalDateTime getLocalDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1, char S0, char S1, char S2, char S3, char S4, char S5, char S6, char S7, char S8) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < '0' || S0 > '9' || S1 < '0' || S1 > '9' || S2 < '0' || S2 > '9' || S3 < '0' || S3 > '9' || S4 < '0' || S4 > '9' || S5 < '0' || S5 > '9' || S6 < '0' || S6 > '9' || S7 < '0' || S7 > '9' || S8 < '0' || S8 > '9') {
            return null;
        }
        int nanos = (S0 - 48) * 100000000 + (S1 - 48) * 10000000 + (S2 - 48) * 1000000 + (S3 - 48) * 100000 + (S4 - 48) * 10000 + (S5 - 48) * 1000 + (S6 - 48) * 100 + (S7 - 48) * 10 + (S8 - 48);
        LocalDate date = LocalDate.of(year, month, dom);
        LocalTime time = LocalTime.of(hour, minute, second, nanos);
        return LocalDateTime.of(date, time);
    }

    protected ZoneId getZoneId(LocalDateTime ldt, String zoneIdStr) {
        ZoneId zoneId;
        if (zoneIdStr != null) {
            if ("000".equals(zoneIdStr)) {
                zoneId = ZoneOffset.UTC;
            } else {
                int p1;
                int p0 = zoneIdStr.indexOf(91);
                if (p0 > 0 && (p1 = zoneIdStr.indexOf(93, p0)) > 0) {
                    String str = zoneIdStr.substring(p0 + 1, p1);
                    zoneId = ZoneId.of(str);
                } else {
                    zoneId = ZoneId.of(zoneIdStr);
                }
            }
        } else {
            zoneId = this.context.getZoneId();
        }
        return zoneId;
    }

    public String info() {
        return this.info(null);
    }

    public String info(String message) {
        if (message == null || message.isEmpty()) {
            return "offset " + this.offset;
        }
        return message + ", offset " + this.offset;
    }

    static boolean isFirstIdentifier(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == '$' || ch >= '0' && ch <= '9' || ch > '\u007f';
    }

    public static class Context {
        String dateFormat;
        boolean formatyyyyMMddhhmmss19;
        boolean formatyyyyMMddhhmmssT19;
        boolean formatyyyyMMdd8;
        boolean formatMillis;
        boolean formatUnixTime;
        boolean formatISO8601;
        boolean formatHasDay;
        boolean formatHasHour;
        boolean useSimpleFormatter;
        DateTimeFormatter dateFormatter;
        ZoneId zoneId;
        long features = JSONFactory.defaultReaderFeatures;
        Locale locale;
        TimeZone timeZone;
        Supplier<Map> objectSupplier;
        Supplier<List> arraySupplier;
        AutoTypeBeforeHandler autoTypeBeforeHandler;
        protected final ObjectReaderProvider provider;
        protected final SymbolTable symbolTable;

        public Context(ObjectReaderProvider provider) {
            this.provider = provider;
            this.symbolTable = null;
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable) {
            this.provider = provider;
            this.symbolTable = symbolTable;
        }

        public ObjectReader getObjectReader(Type type) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectReader(type, fieldBased);
        }

        public ObjectReaderProvider getProvider() {
            return this.provider;
        }

        public ObjectReader getObjectReaderAutoType(long hashCode) {
            return this.provider.getObjectReader(hashCode);
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass) {
            Class<?> autoTypeClass;
            if (this.autoTypeBeforeHandler != null && !ObjectReaderProvider.SAFE_MODE && (autoTypeClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, this.features)) != null) {
                boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
                return this.provider.getObjectReader(autoTypeClass, fieldBased);
            }
            return this.provider.getObjectReader(typeName, expectClass, this.features);
        }

        public AutoTypeBeforeHandler getContextAutoTypeBeforeHandler() {
            return this.autoTypeBeforeHandler;
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass, long features) {
            Class<?> autoTypeClass;
            if (this.autoTypeBeforeHandler != null && !ObjectReaderProvider.SAFE_MODE && (autoTypeClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
                boolean fieldBased = (features & Feature.FieldBased.mask) != 0L;
                return this.provider.getObjectReader(autoTypeClass, fieldBased);
            }
            return this.provider.getObjectReader(typeName, expectClass, this.features | features);
        }

        public Supplier<Map> getObjectSupplier() {
            return this.objectSupplier;
        }

        public void setObjectSupplier(Supplier<Map> objectSupplier) {
            this.objectSupplier = objectSupplier;
        }

        public Supplier<List> getArraySupplier() {
            return this.arraySupplier;
        }

        public void setArraySupplier(Supplier<List> arraySupplier) {
            this.arraySupplier = arraySupplier;
        }

        public DateTimeFormatter getDateFormatter() {
            if (!(this.dateFormatter != null || this.dateFormat == null || this.formatMillis || this.formatISO8601 || this.formatUnixTime)) {
                this.dateFormatter = this.locale == null ? DateTimeFormatter.ofPattern(this.dateFormat) : DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
            }
            return this.dateFormatter;
        }

        public void setDateFormatter(DateTimeFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String format) {
            if (format != null && format.isEmpty()) {
                format = null;
            }
            boolean formatUnixTime = false;
            boolean formatISO8601 = false;
            boolean formatMillis = false;
            boolean hasDay = false;
            boolean hasHour = false;
            boolean useSimpleFormatter = false;
            if (format != null) {
                switch (format) {
                    case "unixtime": {
                        formatUnixTime = true;
                        break;
                    }
                    case "iso8601": {
                        formatISO8601 = true;
                        break;
                    }
                    case "millis": {
                        formatMillis = true;
                        break;
                    }
                    case "yyyyMMddHHmmssSSSZ": {
                        useSimpleFormatter = true;
                    }
                    case "yyyy-MM-dd HH:mm:ss": 
                    case "yyyy-MM-ddTHH:mm:ss": {
                        this.formatyyyyMMddhhmmss19 = true;
                        hasDay = true;
                        hasHour = true;
                        break;
                    }
                    case "yyyy-MM-dd'T'HH:mm:ss": {
                        this.formatyyyyMMddhhmmssT19 = true;
                        hasDay = true;
                        hasHour = true;
                        break;
                    }
                    case "yyyy-MM-dd": {
                        this.formatyyyyMMdd8 = true;
                        hasDay = true;
                        hasHour = false;
                        break;
                    }
                    default: {
                        hasDay = format.indexOf(100) != -1;
                        boolean bl = hasHour = format.indexOf(72) != -1 || format.indexOf(104) != -1 || format.indexOf(75) != -1 || format.indexOf(107) != -1;
                    }
                }
            }
            if (!Objects.equals(this.dateFormat, format)) {
                this.dateFormatter = null;
            }
            this.dateFormat = format;
            this.formatUnixTime = formatUnixTime;
            this.formatMillis = formatMillis;
            this.formatISO8601 = formatISO8601;
            this.formatHasDay = hasDay;
            this.formatHasHour = hasHour;
            this.useSimpleFormatter = useSimpleFormatter;
        }

        public ZoneId getZoneId() {
            if (this.zoneId == null) {
                this.zoneId = IOUtils.DEFAULT_ZONE_ID;
            }
            return this.zoneId;
        }

        public long getFeatures() {
            return this.features;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public void config(Feature ... features) {
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public void config(Filter filter, Feature ... features) {
            if (filter instanceof AutoTypeBeforeHandler) {
                this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public void config(Filter[] filters, Feature ... features) {
            for (Filter filter : filters) {
                if (!(filter instanceof AutoTypeBeforeHandler)) continue;
                this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public boolean isEnabled(Feature feature) {
            return (this.features & feature.mask) != 0L;
        }

        public void config(Feature feature, boolean state) {
            this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static enum Feature {
        FieldBased(1L),
        IgnoreNoneSerializable(2L),
        SupportArrayToBean(4L),
        InitStringFieldAsEmpty(8L),
        SupportAutoType(16L),
        SupportSmartMatch(32L),
        UseNativeObject(64L),
        SupportClassForName(128L),
        IgnoreSetNullValue(256L),
        UseDefaultConstructorAsPossible(512L),
        UseBigDecimalForFloats(1024L),
        UseBigDecimalForDoubles(2048L),
        ErrorOnEnumNotMatch(4096L),
        TrimString(8192L),
        ErrorOnNotSupportAutoType(16384L),
        DuplicateKeyValueAsArray(32768L),
        AllowUnQuotedFieldNames(65536L),
        NonStringKeyAsString(131072L),
        Base64StringAsByteArray(262144L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }

    static class ResolveTask {
        final FieldReader fieldReader;
        final Object object;
        final Object name;
        final JSONPath reference;

        ResolveTask(FieldReader fieldReader, Object object, Object name, JSONPath reference) {
            this.fieldReader = fieldReader;
            this.object = object;
            this.name = name;
            this.reference = reference;
        }

        public String toString() {
            return this.reference.toString();
        }
    }

    public static interface AutoTypeBeforeHandler
    extends Filter {
        public Class<?> apply(String var1, Class<?> var2, long var3);
    }
}

