/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONSchemaValidException;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;

class FieldReaderObjectField<T>
extends FieldReaderImpl<T> {
    protected final Field field;
    protected ObjectReader fieldObjectReader;

    FieldReaderObjectField(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Object defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType == null ? field.getType() : fieldType, fieldClass, ordinal, features, format, null, defaultValue, schema);
        this.field = field;
    }

    @Override
    public ObjectReader getInitReader() {
        return this.fieldObjectReader;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.reader != null) {
            return this.reader;
        }
        ObjectReader formattedObjectReader = FieldReaderObject.createFormattedObjectReader(this.fieldType, this.fieldClass, this.format, null);
        if (formattedObjectReader != null) {
            this.reader = formattedObjectReader;
            return this.reader;
        }
        if (Map.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplMap.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        if (Collection.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplList.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        this.reader = jsonReader.getObjectReader(this.fieldType);
        return this.reader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (!this.fieldClassSerializable && (jsonReader.getContext().getFeatures() & JSONReader.Feature.IgnoreNoneSerializable.mask) != 0L) {
            jsonReader.skipValue();
            return;
        }
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = this.getObjectReader(jsonReader);
        }
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if ("..".equals(reference)) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        try {
            ObjectReader autoTypeObjectReader;
            Object value = jsonReader.nextIfNull() ? (this.fieldClass == OptionalInt.class ? OptionalInt.empty() : (this.fieldClass == OptionalLong.class ? OptionalLong.empty() : (this.fieldClass == OptionalDouble.class ? OptionalDouble.empty() : (this.fieldClass == Optional.class ? Optional.empty() : null)))) : (jsonReader.isJSONB() ? (this.fieldClass == Object.class ? ((autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, this.features)) != null ? autoTypeObjectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features) : jsonReader.readAny()) : this.fieldObjectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features)) : this.fieldObjectReader.readObject(jsonReader, this.fieldType, this.fieldName, this.features));
            this.accept(object, value);
        }
        catch (JSONSchemaValidException ex) {
            throw ex;
        }
        catch (Exception | IllegalAccessError ex) {
            throw new JSONException(jsonReader.info("read field '" + this.field.getDeclaringClass().getName() + "." + this.field.getName()), ex);
        }
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if ("..".equals(reference)) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        Object value = this.fieldObjectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features);
        this.accept(object, value);
    }

    @Override
    public void accept(T object, boolean value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.setBoolean(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, byte value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.setByte(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, short value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.setShort(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, int value) {
        if (this.schema != null) {
            this.schema.assertValidate((long)value);
        }
        try {
            this.field.setInt(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, long value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.setLong(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, float value) {
        if (this.schema != null) {
            this.schema.assertValidate((double)value);
        }
        try {
            this.field.setFloat(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, double value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.setDouble(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, char value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.setChar(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        if (value == null && (this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
            return;
        }
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        Object object = jsonReader.isJSONB() ? this.fieldObjectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features) : this.fieldObjectReader.readObject(jsonReader, this.fieldType, this.fieldName, this.features);
        Function builder = this.fieldObjectReader.getBuildFunction();
        if (builder != null) {
            object = builder.apply(object);
        }
        return object;
    }
}

