/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;

final class FieldWriterBigDecimalField<T>
extends FieldWriterImpl<T> {
    final Field field;

    protected FieldWriterBigDecimalField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, (Type)((Object)BigDecimal.class), BigDecimal.class);
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getFieldValue(T object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        BigDecimal value = (BigDecimal)this.getFieldValue(object);
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        if (this.features != 0L) {
            jsonWriter.writeDecimal(value, this.features);
        } else {
            jsonWriter.writeDecimal(value);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        BigDecimal value = (BigDecimal)this.getFieldValue(object);
        jsonWriter.writeDecimal(value);
    }
}

