/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.ObjCharConsumer;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Method;

final class FieldReaderCharValueFunc<T>
extends FieldReaderImpl<T> {
    final Method method;
    final ObjCharConsumer<T> function;

    FieldReaderCharValueFunc(String fieldName, int ordinal, String format, Character defaultValue, JSONSchema schema, Method method, ObjCharConsumer<T> function) {
        super(fieldName, Character.TYPE, Character.TYPE, ordinal, 0L, format, null, defaultValue, schema);
        this.method = method;
        this.function = function;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void accept(T object, char value) {
        this.function.accept(object, value);
    }

    @Override
    public void accept(T object, Object value) {
        char charValue;
        if (value instanceof String) {
            charValue = ((String)value).charAt(0);
        } else if (value instanceof Character) {
            charValue = ((Character)value).charValue();
        } else {
            throw new JSONException("cast to char error");
        }
        this.accept(object, charValue);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        char ch = jsonReader.readCharValue();
        if (ch == '\u0000' && jsonReader.wasNull()) {
            return;
        }
        this.function.accept(object, ch);
    }

    @Override
    public String readFieldValue(JSONReader jsonReader) {
        return jsonReader.readString();
    }
}

