/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

final class FieldWriterStringMethod<T>
extends FieldWriterImpl<T> {
    final boolean symbol;
    final boolean trim;
    final boolean raw;

    FieldWriterStringMethod(String fieldName, int ordinal, String format, String label, long features, Method method) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)String.class), String.class, null, method);
        this.symbol = "symbol".equals(format);
        this.trim = "trim".equals(format);
        this.raw = (features & 0x4000000000000L) != 0L;
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.name, e);
        }
    }

    @Override
    public void writeString(JSONWriter jsonWriter, String value) {
        this.writeFieldName(jsonWriter);
        if (value == null && (this.features & (JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) != 0L) {
            jsonWriter.writeString("");
            return;
        }
        if (this.trim && value != null) {
            value = value.trim();
        }
        if (this.symbol && jsonWriter.isJSONB()) {
            jsonWriter.writeSymbol(value);
        } else if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String value = (String)this.getFieldValue((Object)object);
        if (this.trim && value != null) {
            value = value.trim();
        }
        if (this.symbol && jsonWriter.isJSONB()) {
            jsonWriter.writeSymbol(value);
        } else if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        String value;
        try {
            value = (String)this.getFieldValue((Object)object);
        }
        catch (JSONException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) == 0L) {
            return false;
        }
        if (this.trim && value != null) {
            value = value.trim();
        }
        this.writeString(jsonWriter, value);
        return true;
    }
}

