/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.asm;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.function.ObjBoolConsumer;
import com.alibaba.fastjson2.function.ObjByteConsumer;
import com.alibaba.fastjson2.function.ObjCharConsumer;
import com.alibaba.fastjson2.function.ObjFloatConsumer;
import com.alibaba.fastjson2.function.ObjShortConsumer;
import com.alibaba.fastjson2.internal.asm.ClassReader;
import com.alibaba.fastjson2.internal.asm.TypeCollector;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;

public class ASMUtils {
    static Map<Class, String> descMapping;
    static Map<Class, String> typeMapping;
    static final AtomicReference<char[]> descCacheRef;

    public static String type(Class<?> clazz) {
        String type = typeMapping.get(clazz);
        if (type != null) {
            return type;
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            return typeMapping.get(clazz);
        }
        return clazz.getName().replace('.', '/');
    }

    public static String desc(Class<?> clazz) {
        String desc = descMapping.get(clazz);
        if (desc != null) {
            return desc;
        }
        if (clazz.isPrimitive()) {
            return typeMapping.get(clazz);
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        String className = clazz.getName();
        char[] chars = descCacheRef.getAndSet(null);
        if (chars == null) {
            chars = new char[512];
        }
        chars[0] = 76;
        className.getChars(0, className.length(), chars, 1);
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            chars[i] = 47;
        }
        chars[className.length() + 1] = 59;
        String str = new String(chars, 0, className.length() + 2);
        descCacheRef.compareAndSet(null, chars);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] lookupParameterNames(AccessibleObject methodOrCtor) {
        String className;
        String resourceName;
        InputStream is;
        int paramCount;
        Class<Object> declaringClass;
        String name;
        Class<?>[] types;
        if (methodOrCtor instanceof Method) {
            Method method = (Method)methodOrCtor;
            types = method.getParameterTypes();
            name = method.getName();
            declaringClass = method.getDeclaringClass();
            paramCount = method.getParameterCount();
        } else {
            Constructor constructor = (Constructor)methodOrCtor;
            types = constructor.getParameterTypes();
            declaringClass = constructor.getDeclaringClass();
            name = "<init>";
            paramCount = constructor.getParameterCount();
        }
        if (types.length == 0) {
            return new String[paramCount];
        }
        ClassLoader classLoader = declaringClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((is = classLoader.getResourceAsStream(resourceName = (className = declaringClass.getName()).replace('.', '/') + ".class")) == null) {
            return new String[paramCount];
        }
        try {
            ClassReader reader = new ClassReader(is, false);
            TypeCollector visitor = new TypeCollector(name, types);
            reader.accept(visitor);
            String[] stringArray = visitor.getParameterNamesForMethod();
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = new String[paramCount];
            return stringArray;
        }
        finally {
            IOUtils.close(is);
        }
    }

    static {
        Class[] classes;
        descMapping = new HashMap<Class, String>();
        typeMapping = new HashMap<Class, String>();
        descMapping.put(Integer.TYPE, "I");
        descMapping.put(Void.TYPE, "V");
        descMapping.put(Boolean.TYPE, "Z");
        descMapping.put(Character.TYPE, "C");
        descMapping.put(Byte.TYPE, "B");
        descMapping.put(Short.TYPE, "S");
        descMapping.put(Float.TYPE, "F");
        descMapping.put(Long.TYPE, "J");
        descMapping.put(Double.TYPE, "D");
        descMapping.put(List.class, "Ljava/util/List;");
        typeMapping.put(Collection.class, "Ljava/util/Collection;");
        typeMapping.put(Integer.TYPE, "I");
        typeMapping.put(Void.TYPE, "V");
        typeMapping.put(Boolean.TYPE, "Z");
        typeMapping.put(Character.TYPE, "C");
        typeMapping.put(Byte.TYPE, "B");
        typeMapping.put(Short.TYPE, "S");
        typeMapping.put(Float.TYPE, "F");
        typeMapping.put(Long.TYPE, "J");
        typeMapping.put(Double.TYPE, "D");
        for (Class objectType : classes = new Class[]{List.class, Collection.class, ObjectReader.class, ObjectReaderAdapter.class, FieldReader.class, JSONReader.class, ObjBoolConsumer.class, ObjCharConsumer.class, ObjByteConsumer.class, ObjShortConsumer.class, ObjIntConsumer.class, ObjLongConsumer.class, ObjFloatConsumer.class, ObjDoubleConsumer.class, BiConsumer.class, UnsafeUtils.class, ObjectWriter.class, ObjectWriterAdapter.class, FieldWriter.class, JSONWriter.class, JSONWriter.Context.class, JSONB.class}) {
            typeMapping.put(objectType, objectType.getName().replace('.', '/'));
        }
        descCacheRef = new AtomicReference();
    }
}

