/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterInt32;
import java.lang.reflect.Field;

class FieldWriterInt32Val<T>
extends FieldWriterInt32<T> {
    FieldWriterInt32Val(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, Integer.TYPE, Integer.TYPE, field, null);
    }

    @Override
    public Object getFieldValue(T object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        int value;
        try {
            value = this.field.getInt(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
        if (value == 0 && jsonWriter.isEnabled(JSONWriter.Feature.NotWriteDefaultValue)) {
            return false;
        }
        this.writeInt32(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, Object object) {
        try {
            int value = this.field.getInt(object);
            jsonWriter.writeInt32(value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }
}

