/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterDate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class FieldWriterMillisMethod<T>
extends FieldWriterDate<T> {
    FieldWriterMillisMethod(String fieldName, int ordinal, long features, String dateTimeFormat, String label, Class fieldClass, Method method) {
        super(fieldName, ordinal, features, dateTimeFormat, label, fieldClass, fieldClass, null, method);
    }

    @Override
    public Object getFieldValue(T object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long millis = (Long)this.getFieldValue(object);
        this.writeDate(jsonWriter, millis);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        long millis = (Long)this.getFieldValue(object);
        this.writeDate(jsonWriter, false, millis);
    }
}

