/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;
import java.util.function.Predicate;

public class JDKUtils {
    public static final int JVM_VERSION;
    static final Field FIELD_STRING_VALUE;
    static final long FIELD_STRING_VALUE_OFFSET;
    static volatile boolean FIELD_STRING_ERROR;
    static final Class<?> CLASS_SQL_DATASOURCE;
    static final Class<?> CLASS_SQL_ROW_SET;
    public static final boolean HAS_SQL;
    public static final boolean UNSAFE_SUPPORT;

    public static boolean isSQLDataSourceOrRowSet(Class<?> type) {
        return CLASS_SQL_DATASOURCE != null && CLASS_SQL_DATASOURCE.isAssignableFrom(type) || CLASS_SQL_ROW_SET != null && CLASS_SQL_ROW_SET.isAssignableFrom(type);
    }

    static {
        boolean unsafeSupport;
        int jvmVersion = -1;
        try {
            String property = System.getProperty("java.specification.version");
            if (property.startsWith("1.")) {
                property = property.substring(2);
            }
            jvmVersion = Integer.parseInt(property);
        }
        catch (Throwable property) {
            // empty catch block
        }
        boolean hasJavaSql = true;
        Class<?> dataSourceClass = null;
        Class<?> rowSetClass = null;
        try {
            dataSourceClass = Class.forName("javax.sql.DataSource");
            rowSetClass = Class.forName("javax.sql.RowSet");
        }
        catch (Throwable e) {
            hasJavaSql = false;
        }
        CLASS_SQL_DATASOURCE = dataSourceClass;
        CLASS_SQL_ROW_SET = rowSetClass;
        HAS_SQL = hasJavaSql;
        JVM_VERSION = jvmVersion;
        if (JVM_VERSION == 8) {
            Field field = null;
            long fieldOffset = -1L;
            try {
                field = String.class.getDeclaredField("value");
                field.setAccessible(true);
                fieldOffset = UnsafeUtils.objectFieldOffset(field);
            }
            catch (Exception ignored) {
                FIELD_STRING_ERROR = true;
            }
            FIELD_STRING_VALUE = field;
            FIELD_STRING_VALUE_OFFSET = fieldOffset;
        } else {
            FIELD_STRING_ERROR = true;
            FIELD_STRING_VALUE = null;
            FIELD_STRING_VALUE_OFFSET = -1L;
        }
        UNSAFE_SUPPORT = unsafeSupport = ((Predicate<Object>)o -> {
            try {
                return UnsafeUtils.UNSAFE != null;
            }
            catch (Throwable ignored) {
                return false;
            }
        }).test(null);
    }
}

