/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriterJSONB;
import com.alibaba.fastjson2.JSONWriterPretty;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.JSONWriterUTF16JDK8;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.BeforeFilter;
import com.alibaba.fastjson2.filter.ContextNameFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public abstract class JSONWriter
implements Closeable {
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected final Context context;
    protected final Charset charset;
    protected final boolean utf8;
    protected final boolean utf16;
    protected boolean startObject;
    protected int level;
    protected int off;
    protected Object rootObject;
    protected IdentityHashMap<Object, Path> refs;
    protected Path path;
    protected String lastReference;
    protected final char quote;
    static int MAX_ARRAY_SIZE = 0x4000000;

    protected JSONWriter(Context context, Charset charset) {
        this.context = context;
        this.charset = charset;
        this.utf8 = charset == StandardCharsets.UTF_8;
        this.utf16 = charset == StandardCharsets.UTF_16;
        this.quote = (char)((context.features & Feature.UseSingleQuotes.mask) == 0L ? 34 : 39);
    }

    public boolean isUTF8() {
        return this.utf8;
    }

    public boolean isUTF16() {
        return this.utf16;
    }

    public boolean isJSONB() {
        return false;
    }

    public boolean isIgnoreNoneSerializable() {
        return (this.context.features & Feature.IgnoreNoneSerializable.mask) != 0L;
    }

    public boolean isIgnoreNoneSerializable(Object object) {
        return (this.context.features & Feature.IgnoreNoneSerializable.mask) != 0L && object != null && !Serializable.class.isAssignableFrom(object.getClass());
    }

    public SymbolTable getSymbolTable() {
        return null;
    }

    public void config(Feature ... features) {
        this.context.config(features);
    }

    public void config(Feature feature, boolean state) {
        this.context.config(feature, state);
    }

    public Context getContext() {
        return this.context;
    }

    public int level() {
        return this.level;
    }

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
        if ((this.context.features & Feature.ReferenceDetection.mask) != 0L) {
            if (this.refs == null) {
                this.refs = new IdentityHashMap(8);
            }
            this.path = Path.ROOT;
            this.refs.putIfAbsent(rootObject, this.path);
        }
    }

    public String setPath(String name, Object object) {
        Path previous;
        if ((this.context.features & Feature.ReferenceDetection.mask) == 0L) {
            return null;
        }
        this.path = new Path(this.path, name);
        if (this.refs == null) {
            this.refs = new IdentityHashMap(8);
        }
        if ((previous = this.refs.get(object)) == null) {
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public String setPath(FieldWriter fieldWriter, Object object) {
        Path previous;
        if ((this.context.features & Feature.ReferenceDetection.mask) == 0L) {
            return null;
        }
        if (object == Collections.EMPTY_LIST || object == Collections.EMPTY_SET) {
            return null;
        }
        this.path = this.path == Path.ROOT ? fieldWriter.getRootParentPath() : fieldWriter.getPath(this.path);
        if (this.refs == null) {
            this.refs = new IdentityHashMap(8);
        }
        if ((previous = this.refs.get(object)) == null) {
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public String setPath(int index, Object object) {
        Path previous;
        if ((this.context.features & Feature.ReferenceDetection.mask) == 0L) {
            return null;
        }
        this.path = index == 0 ? (this.path.child0 != null ? this.path.child0 : (this.path.child0 = new Path(this.path, index))) : (index == 1 ? (this.path.child1 != null ? this.path.child1 : (this.path.child1 = new Path(this.path, index))) : new Path(this.path, index));
        if (this.refs == null) {
            this.refs = new IdentityHashMap(8);
        }
        if ((previous = this.refs.get(object)) == null) {
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public void popPath(Object object) {
        if (this.path == null) {
            return;
        }
        if ((this.context.features & Feature.ReferenceDetection.mask) == 0L) {
            return;
        }
        this.path = this.path.parent;
    }

    public final boolean hasFilter() {
        return this.context.propertyPreFilter != null || this.context.propertyFilter != null || this.context.nameFilter != null || this.context.valueFilter != null || this.context.beforeFilter != null || this.context.afterFilter != null || this.context.labelFilter != null || this.context.contextValueFilter != null || this.context.contextNameFilter != null;
    }

    public final boolean hasFilter(long feature) {
        return this.context.propertyPreFilter != null || this.context.propertyFilter != null || this.context.nameFilter != null || this.context.valueFilter != null || this.context.beforeFilter != null || this.context.afterFilter != null || this.context.labelFilter != null || this.context.contextValueFilter != null || this.context.contextNameFilter != null || (this.context.features & feature) != 0L;
    }

    public boolean isWriteNulls() {
        return (this.context.features & Feature.WriteNulls.mask) != 0L;
    }

    public boolean isRefDetect() {
        return (this.context.features & Feature.ReferenceDetection.mask) != 0L;
    }

    public boolean isUseSingleQuotes() {
        return (this.context.features & Feature.UseSingleQuotes.mask) != 0L;
    }

    public boolean isRefDetect(Object object) {
        return (this.context.features & Feature.ReferenceDetection.mask) != 0L && object != null && !ObjectWriterProvider.isNotReferenceDetect(object.getClass());
    }

    public boolean containsReference(Object value) {
        return this.refs != null && this.refs.containsKey(value);
    }

    public boolean removeReference(Object value) {
        return this.refs != null && this.refs.remove(value) != null;
    }

    public boolean isBeanToArray() {
        return (this.context.features & Feature.BeanToArray.mask) != 0L;
    }

    public boolean isEnabled(Feature feature) {
        return (this.context.features & feature.mask) != 0L;
    }

    public boolean isEnabled(long feature) {
        return (this.context.features & feature) != 0L;
    }

    public long getFeatures() {
        return this.context.features;
    }

    public long getFeatures(long features) {
        return this.context.features | features;
    }

    public boolean isIgnoreErrorGetter() {
        return (this.context.features & Feature.IgnoreErrorGetter.mask) != 0L;
    }

    public boolean isWriteTypeInfo(Object object, Type fieldType) {
        Type rawType;
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)fieldType;
            Type componentType = genericArrayType.getGenericComponentType();
            if (componentType instanceof ParameterizedType) {
                componentType = ((ParameterizedType)componentType).getRawType();
            }
            if (objectClass.isArray() && objectClass.getComponentType().equals(componentType)) {
                return false;
            }
        } else if (fieldType instanceof ParameterizedType && (rawType = ((ParameterizedType)fieldType).getRawType()) instanceof Class) {
            fieldClass = (Class)rawType;
        }
        if (objectClass == fieldClass) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object) {
        Class<?> objectClass;
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && object != null && ((objectClass = object.getClass()) == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object, Type fieldType, long features) {
        Type rawType;
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType instanceof ParameterizedType && (rawType = ((ParameterizedType)fieldType).getRawType()) instanceof Class) {
            fieldClass = (Class)rawType;
        }
        if (objectClass == fieldClass) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class ? fieldClass == null || fieldClass == Object.class || fieldClass == Map.class || fieldClass == AbstractMap.class : objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object, Class fieldClass, long features) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return false;
        }
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class ? fieldClass == null || fieldClass == Object.class || fieldClass == Map.class || fieldClass == AbstractMap.class : objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteMapTypeInfo(Object object, Class fieldClass, long features) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return false;
        }
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && objectClass == HashMap.class) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object, long features) {
        Class<?> objectClass;
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && object != null && ((objectClass = object.getClass()) == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public ObjectWriter getObjectWriter(Class objectClass) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectWriter(objectClass, objectClass, fieldBased);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectWriter(objectType, objectClass, fieldBased);
    }

    public static JSONWriter of() {
        Context writeContext = JSONFactory.createWriteContext();
        if (JDKUtils.JVM_VERSION == 8) {
            return new JSONWriterUTF16JDK8(writeContext);
        }
        if ((JSONFactory.defaultWriterFeatures & Feature.OptimizedForAscii.mask) != 0L) {
            return new JSONWriterUTF8(writeContext);
        }
        return new JSONWriterUTF16(writeContext);
    }

    public static JSONWriter of(ObjectWriterProvider provider, Feature ... features) {
        Context context = new Context(provider);
        context.config(features);
        return JSONWriter.of(context);
    }

    public static JSONWriter of(Context writeContext) {
        if (writeContext == null) {
            writeContext = JSONFactory.createWriteContext();
        }
        JSONWriter jsonWriter = JDKUtils.JVM_VERSION == 8 ? new JSONWriterUTF16JDK8(writeContext) : ((writeContext.features & Feature.OptimizedForAscii.mask) != 0L ? new JSONWriterUTF8(writeContext) : new JSONWriterUTF16(writeContext));
        if (writeContext.isEnabled(Feature.PrettyFormat)) {
            jsonWriter = new JSONWriterPretty(jsonWriter);
        }
        return jsonWriter;
    }

    public static JSONWriter of(Feature ... features) {
        Context writeContext = JSONFactory.createWriteContext(features);
        JSONWriter jsonWriter = JDKUtils.JVM_VERSION == 8 ? new JSONWriterUTF16JDK8(writeContext) : ((writeContext.features & Feature.OptimizedForAscii.mask) != 0L ? new JSONWriterUTF8(writeContext) : new JSONWriterUTF16(writeContext));
        for (int i = 0; i < features.length; ++i) {
            if (features[i] != Feature.PrettyFormat) continue;
            return new JSONWriterPretty(jsonWriter);
        }
        return jsonWriter;
    }

    public static JSONWriter ofUTF16(Feature ... features) {
        Context writeContext = JSONFactory.createWriteContext(features);
        JSONWriterUTF16 jsonWriter = JDKUtils.JVM_VERSION == 8 ? new JSONWriterUTF16JDK8(writeContext) : new JSONWriterUTF16(writeContext);
        for (int i = 0; i < features.length; ++i) {
            if (features[i] != Feature.PrettyFormat) continue;
            return new JSONWriterPretty(jsonWriter);
        }
        return jsonWriter;
    }

    public static JSONWriter ofJSONB() {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider), null);
    }

    public static JSONWriter ofJSONB(Feature ... features) {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider, features), null);
    }

    public static JSONWriter ofJSONB(SymbolTable symbolTable) {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider), symbolTable);
    }

    public static JSONWriter ofPretty() {
        return JSONWriter.ofPretty(JSONWriter.of());
    }

    public static JSONWriter ofPretty(JSONWriter writer) {
        return new JSONWriterPretty(writer);
    }

    public static JSONWriter ofUTF8() {
        return new JSONWriterUTF8(JSONFactory.createWriteContext());
    }

    public static JSONWriter ofUTF8(Context context) {
        return new JSONWriterUTF8(context);
    }

    public static JSONWriter ofUTF8(Feature ... features) {
        boolean pretty;
        Context writeContext = JSONFactory.createWriteContext(features);
        JSONWriter jsonWriter = new JSONWriterUTF8(writeContext);
        boolean bl = pretty = (writeContext.features & Feature.PrettyFormat.mask) != 0L;
        if (pretty) {
            jsonWriter = new JSONWriterPretty(jsonWriter);
        }
        return jsonWriter;
    }

    public void writeBinary(byte[] bytes) {
        if (bytes == null) {
            this.writeArrayNull();
            return;
        }
        if ((this.context.features & Feature.WriteByteArrayAsBase64.mask) != 0L) {
            this.writeBase64(bytes);
            return;
        }
        this.startArray();
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt32(bytes[i]);
        }
        this.endArray();
    }

    public abstract void writeBase64(byte[] var1);

    protected abstract void write0(char var1);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(byte[] var1);

    public void writeRaw(byte b) {
        throw new JSONException("UnsupportedOperation");
    }

    public void writeNameRaw(byte[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    public void writeRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract void writeChar(char var1);

    public abstract void writeRaw(char var1);

    public abstract void writeNameRaw(byte[] var1);

    public void writeNameRaw(byte[] name, long nameHash) {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract void writeNameRaw(char[] var1);

    public abstract void writeNameRaw(char[] var1, int var2, int var3);

    public void writeName(String name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeString(name);
    }

    public void writeName(long name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeInt64(name);
        if (name >= Integer.MIN_VALUE && name <= Integer.MAX_VALUE && (this.context.features & Feature.WriteClassName.mask) != 0L) {
            this.writeRaw('L');
        }
    }

    public void writeName(int name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeInt32(name);
    }

    public void writeNameAny(Object name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeAny(name);
    }

    public abstract void startObject();

    public abstract void endObject();

    public abstract void startArray();

    public void startArray(int size) {
        throw new JSONException("UnsupportedOperation");
    }

    public void startArray(Object array, int size) {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract void endArray();

    public abstract void writeComma();

    public abstract void writeColon();

    public void writeInt16(short[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt16(value[i]);
        }
        this.endArray();
    }

    public void writeInt8(byte value) {
        this.writeInt32(value);
    }

    public void writeInt16(short value) {
        this.writeInt32(value);
    }

    public void writeInt32(int[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt32(value[i]);
        }
        this.endArray();
    }

    public abstract void writeInt32(int var1);

    public abstract void writeInt64(long var1);

    public void writeMillis(long i) {
        this.writeInt64(i);
    }

    public void writeInt64(long[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt64(value[i]);
        }
        this.endArray();
    }

    public abstract void writeFloat(float var1);

    public void writeFloat(float[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeFloat(value[i]);
        }
        this.endArray();
    }

    public abstract void writeDouble(double var1);

    public void writeDoubleArray(double value0, double value1) {
        this.startArray();
        this.writeDouble(value0);
        this.writeComma();
        this.writeDouble(value1);
        this.endArray();
    }

    public void writeDouble(double[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeDouble(value[i]);
        }
        this.endArray();
    }

    public void writeBool(boolean value) {
        if ((this.context.features & Feature.WriteBooleanAsNumber.mask) != 0L) {
            this.write0(value ? (char)'1' : '0');
        } else {
            this.writeRaw(value ? "true" : "false");
        }
    }

    public void writeBool(boolean[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeBool(value[i]);
        }
        this.endArray();
    }

    public void writeNull() {
        this.writeRaw("null");
    }

    public void writeStringNull() {
        String raw = (this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullStringAsEmpty.mask)) != 0L ? ((this.context.features & Feature.UseSingleQuotes.mask) != 0L ? "''" : "\"\"") : "null";
        this.writeRaw(raw);
    }

    public void writeArrayNull() {
        String raw = (this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullListAsEmpty.mask)) != 0L ? "[]" : "null";
        this.writeRaw(raw);
    }

    public void writeNumberNull() {
        if ((this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullNumberAsZero.mask)) != 0L) {
            this.writeInt32(0);
        } else {
            this.writeNull();
        }
    }

    public void writeBooleanNull() {
        if ((this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullBooleanAsFalse.mask)) != 0L) {
            this.writeBool(false);
        } else {
            this.writeNull();
        }
    }

    public abstract void writeDecimal(BigDecimal var1);

    public void writeDecimal(BigDecimal value, long features) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (((features |= this.context.features) & Feature.WriteBigDecimalAsPlain.mask) != 0L) {
            String str = value.toPlainString();
            this.writeRaw(str);
            return;
        }
        String str = value.toString();
        if ((features & Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW) < 0 || value.compareTo(JSONFactory.HIGH) > 0)) {
            this.write0('\"');
            this.writeRaw(str);
            this.write0('\"');
        } else {
            this.writeRaw(str);
        }
    }

    public void writeEnum(Enum e) {
        if (e == null) {
            this.writeNull();
            return;
        }
        if ((this.context.features & Feature.WriteEnumUsingToString.mask) != 0L) {
            this.writeString(e.toString());
        } else if ((this.context.features & Feature.WriteEnumsUsingName.mask) != 0L) {
            this.writeString(e.name());
        } else {
            this.writeInt32(e.ordinal());
        }
    }

    public void writeBigInt(BigInteger value) {
        this.writeBigInt(value, 0L);
    }

    public abstract void writeBigInt(BigInteger var1, long var2);

    public abstract void writeUUID(UUID var1);

    public void writeTypeName(String typeName) {
        throw new JSONException("UnsupportedOperation");
    }

    public boolean writeTypeName(byte[] typeName, long typeNameHash) {
        throw new JSONException("UnsupportedOperation");
    }

    public void writeString(Reader reader) {
        this.writeRaw(this.quote);
        try {
            int len;
            char[] chars = new char[2048];
            while ((len = reader.read(chars, 0, chars.length)) >= 0) {
                if (len <= 0) continue;
                this.writeString(chars, 0, len, false);
            }
        }
        catch (Exception ex) {
            throw new JSONException("read string from reader error", ex);
        }
        this.writeRaw(this.quote);
    }

    public abstract void writeString(String var1);

    public void writeSymbol(String string) {
        this.writeString(string);
    }

    public void writeString(char[] chars) {
        int i;
        if (chars == null) {
            this.writeNull();
            return;
        }
        this.write0('\"');
        boolean special = false;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '\\' && chars[i] != '\"') continue;
            special = true;
            break;
        }
        if (!special) {
            this.writeRaw(chars);
        } else {
            for (i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (ch == '\\' || ch == '\"') {
                    this.write0('\\');
                }
                this.write0(ch);
            }
        }
        this.write0('\"');
    }

    protected abstract void writeString(char[] var1, int var2, int var3, boolean var4);

    public abstract void writeLocalDate(LocalDate var1);

    public abstract void writeLocalDateTime(LocalDateTime var1);

    public abstract void writeLocalTime(LocalTime var1);

    public abstract void writeZonedDateTime(ZonedDateTime var1);

    public void writeInstant(Instant instant) {
        if (instant == null) {
            this.writeNull();
            return;
        }
        String str = DateTimeFormatter.ISO_INSTANT.format(instant);
        this.writeString(str);
    }

    public abstract void writeDateTime14(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void writeDateTime19(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void writeDateTimeISO8601(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    public abstract void writeDateYYYMMDD8(int var1, int var2, int var3);

    public abstract void writeDateYYYMMDD10(int var1, int var2, int var3);

    public abstract void writeTimeHHMMSS8(int var1, int var2, int var3);

    public void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        long NONE_DIRECT_FEATURES = Feature.ReferenceDetection.mask | Feature.PrettyFormat.mask | Feature.NotWriteEmptyArray.mask | Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        this.write0('[');
        for (int i = 0; i < array.size(); ++i) {
            Object item = array.get(i);
            if (i != 0) {
                this.write0(',');
            }
            this.writeAny(item);
        }
        this.write0(']');
    }

    public void write(Map map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        long NONE_DIRECT_FEATURES = Feature.ReferenceDetection.mask | Feature.PrettyFormat.mask | Feature.NotWriteEmptyArray.mask | Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        this.write0('{');
        boolean first = true;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            if (!first) {
                this.write0(',');
            }
            Map.Entry next = it.next();
            this.writeAny(next.getKey());
            this.write0(':');
            this.writeAny(next.getValue());
            first = false;
        }
        this.write0('}');
    }

    public void write(JSONObject map) {
        this.write((Map)map);
    }

    public void writeAny(Object value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        Class<?> valueClass = value.getClass();
        ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
        objectWriter.write(this, value, null, null, 0L);
    }

    public abstract void writeReference(String var1);

    @Override
    public void close() {
    }

    public abstract byte[] getBytes();

    public void flushTo(Writer to) {
        try {
            String json = this.toString();
            to.write(json);
        }
        catch (IOException e) {
            throw new JSONException("flushTo error", e);
        }
    }

    public abstract int flushTo(OutputStream var1) throws IOException;

    public abstract int flushTo(OutputStream var1, Charset var2) throws IOException;

    public static class Context {
        static ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
        final ObjectWriterProvider provider;
        DateTimeFormatter dateFormatter;
        String dateFormat;
        Locale locale;
        boolean dateFormatMillis;
        boolean dateFormatISO8601;
        boolean dateFormatUnixTime;
        boolean formatyyyyMMddhhmmss19;
        boolean formatHasDay;
        boolean formatHasHour;
        long features;
        ZoneId zoneId;
        PropertyPreFilter propertyPreFilter;
        PropertyFilter propertyFilter;
        NameFilter nameFilter;
        ValueFilter valueFilter;
        BeforeFilter beforeFilter;
        AfterFilter afterFilter;
        LabelFilter labelFilter;
        ContextValueFilter contextValueFilter;
        ContextNameFilter contextNameFilter;

        public Context(ObjectWriterProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException("objectWriterProvider must not null");
            }
            this.features = JSONFactory.defaultWriterFeatures;
            this.provider = provider;
        }

        public Context(ObjectWriterProvider provider, Feature ... features) {
            if (provider == null) {
                throw new IllegalArgumentException("objectWriterProvider must not null");
            }
            this.features = JSONFactory.defaultWriterFeatures;
            this.provider = provider;
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public long getFeatures() {
            return this.features;
        }

        public boolean isEnabled(Feature feature) {
            return (this.features & feature.mask) != 0L;
        }

        public boolean isEnabled(long feature) {
            return (this.features & feature) != 0L;
        }

        public void config(Feature ... features) {
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public void config(Feature feature, boolean state) {
            this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        protected void configFilter(Filter ... filters) {
            for (Filter filter : filters) {
                if (filter instanceof NameFilter) {
                    this.nameFilter = (NameFilter)filter;
                }
                if (filter instanceof ValueFilter) {
                    this.valueFilter = (ValueFilter)filter;
                }
                if (filter instanceof PropertyFilter) {
                    this.propertyFilter = (PropertyFilter)filter;
                }
                if (filter instanceof PropertyPreFilter) {
                    this.propertyPreFilter = (PropertyPreFilter)filter;
                }
                if (filter instanceof BeforeFilter) {
                    this.beforeFilter = (BeforeFilter)filter;
                }
                if (filter instanceof AfterFilter) {
                    this.afterFilter = (AfterFilter)filter;
                }
                if (filter instanceof LabelFilter) {
                    this.labelFilter = (LabelFilter)filter;
                }
                if (filter instanceof ContextValueFilter) {
                    this.contextValueFilter = (ContextValueFilter)filter;
                }
                if (!(filter instanceof ContextNameFilter)) continue;
                this.contextNameFilter = (ContextNameFilter)filter;
            }
        }

        public <T> ObjectWriter<T> getObjectWriter(Class<T> objectType) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            ObjectWriter objectWriter = this.provider.getObjectWriter(objectType, objectType, fieldBased);
            return objectWriter;
        }

        public <T> ObjectWriter<T> getObjectWriter(Type objectType, Class<T> objectClass) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectWriter(objectType, objectClass, fieldBased);
        }

        public ObjectWriterProvider getProvider() {
            return this.provider;
        }

        public ZoneId getZoneId() {
            if (this.zoneId == null) {
                this.zoneId = DEFAULT_ZONE_ID;
            }
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public boolean isDateFormatMillis() {
            return this.dateFormatMillis;
        }

        public boolean isDateFormatUnixTime() {
            return this.dateFormatUnixTime;
        }

        public boolean isDateFormatISO8601() {
            return this.dateFormatISO8601;
        }

        public boolean isDateFormatHasDay() {
            return this.formatHasDay;
        }

        public boolean isDateFormatHasHour() {
            return this.formatHasHour;
        }

        public boolean isFormatyyyyMMddhhmmss19() {
            return this.formatyyyyMMddhhmmss19;
        }

        public DateTimeFormatter getDateFormatter() {
            if (!(this.dateFormatter != null || this.dateFormat == null || this.dateFormatMillis || this.dateFormatISO8601 || this.dateFormatUnixTime)) {
                this.dateFormatter = this.locale == null ? DateTimeFormatter.ofPattern(this.dateFormat) : DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
            }
            return this.dateFormatter;
        }

        public void setDateFormat(String dateFormat) {
            if (dateFormat == null || !dateFormat.equals(this.dateFormat)) {
                this.dateFormatter = null;
            }
            if (dateFormat != null && !dateFormat.isEmpty()) {
                boolean dateFormatMillis = false;
                boolean dateFormatISO8601 = false;
                boolean dateFormatUnixTime = false;
                boolean formatHasDay = false;
                boolean formatHasHour = false;
                boolean formatyyyyMMddhhmmss19 = false;
                switch (dateFormat) {
                    case "millis": {
                        dateFormatMillis = true;
                        break;
                    }
                    case "iso8601": {
                        dateFormatMillis = false;
                        dateFormatISO8601 = true;
                        break;
                    }
                    case "unixtime": {
                        dateFormatMillis = false;
                        dateFormatUnixTime = true;
                        break;
                    }
                    case "yyyy-MM-ddTHH:mm:ss": {
                        dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
                        formatHasDay = true;
                        formatHasHour = true;
                        break;
                    }
                    case "yyyy-MM-dd HH:mm:ss": {
                        formatyyyyMMddhhmmss19 = true;
                        formatHasDay = true;
                        formatHasHour = true;
                        break;
                    }
                    default: {
                        dateFormatMillis = false;
                        formatHasDay = dateFormat.indexOf("d") != -1;
                        formatHasHour = dateFormat.indexOf("H") != -1;
                    }
                }
                this.dateFormatMillis = dateFormatMillis;
                this.dateFormatISO8601 = dateFormatISO8601;
                this.dateFormatUnixTime = dateFormatUnixTime;
                this.formatHasDay = formatHasDay;
                this.formatHasHour = formatHasHour;
                this.formatyyyyMMddhhmmss19 = formatyyyyMMddhhmmss19;
            }
            this.dateFormat = dateFormat;
        }

        public PropertyPreFilter getPropertyPreFilter() {
            return this.propertyPreFilter;
        }

        public void setPropertyPreFilter(PropertyPreFilter propertyPreFilter) {
            this.propertyPreFilter = propertyPreFilter;
        }

        public NameFilter getNameFilter() {
            return this.nameFilter;
        }

        public void setNameFilter(NameFilter nameFilter) {
            this.nameFilter = nameFilter;
        }

        public ValueFilter getValueFilter() {
            return this.valueFilter;
        }

        public void setValueFilter(ValueFilter valueFilter) {
            this.valueFilter = valueFilter;
        }

        public ContextValueFilter getContextValueFilter() {
            return this.contextValueFilter;
        }

        public void setContextValueFilter(ContextValueFilter contextValueFilter) {
            this.contextValueFilter = contextValueFilter;
        }

        public ContextNameFilter getContextNameFilter() {
            return this.contextNameFilter;
        }

        public void setContextNameFilter(ContextNameFilter contextNameFilter) {
            this.contextNameFilter = contextNameFilter;
        }

        public PropertyFilter getPropertyFilter() {
            return this.propertyFilter;
        }

        public void setPropertyFilter(PropertyFilter propertyFilter) {
            this.propertyFilter = propertyFilter;
        }

        public AfterFilter getAfterFilter() {
            return this.afterFilter;
        }

        public void setAfterFilter(AfterFilter afterFilter) {
            this.afterFilter = afterFilter;
        }

        public BeforeFilter getBeforeFilter() {
            return this.beforeFilter;
        }

        public void setBeforeFilter(BeforeFilter beforeFilter) {
            this.beforeFilter = beforeFilter;
        }

        public LabelFilter getLabelFilter() {
            return this.labelFilter;
        }

        public void setLabelFilter(LabelFilter labelFilter) {
            this.labelFilter = labelFilter;
        }
    }

    public static enum Feature {
        FieldBased(1L),
        IgnoreNoneSerializable(2L),
        ErrorOnNoneSerializable(4L),
        BeanToArray(8L),
        WriteNulls(16L),
        WriteMapNullValue(16L),
        BrowserCompatible(32L),
        NullAsDefaultValue(64L),
        WriteBooleanAsNumber(128L),
        WriteNonStringValueAsString(256L),
        WriteClassName(512L),
        NotWriteRootClassName(1024L),
        NotWriteHashMapArrayListClassName(2048L),
        NotWriteDefaultValue(4096L),
        WriteEnumsUsingName(8192L),
        WriteEnumUsingToString(16384L),
        IgnoreErrorGetter(32768L),
        PrettyFormat(65536L),
        ReferenceDetection(131072L),
        WriteNameAsSymbol(262144L),
        WriteBigDecimalAsPlain(524288L),
        UseSingleQuotes(0x100000L),
        MapSortField(0x200000L),
        WriteNullListAsEmpty(0x400000L),
        WriteNullStringAsEmpty(0x800000L),
        WriteNullNumberAsZero(0x1000000L),
        WriteNullBooleanAsFalse(0x2000000L),
        NotWriteEmptyArray(0x4000000L),
        WriteNonStringKeyAsString(0x8000000L),
        WritePairAsJavaBean(0x10000000L),
        OptimizedForAscii(0x20000000L),
        EscapeNoneAscii(0x40000000L),
        WriteByteArrayAsBase64(0x80000000L),
        IgnoreNonFieldGetter(0x100000000L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }

    public static final class Path {
        public static final Path ROOT = new Path(null, "$");
        public final Path parent;
        final String name;
        final int index;
        String fullPath;
        Path child0;
        Path child1;

        public Path(Path parent, String name) {
            this.parent = parent;
            this.name = name;
            this.index = -1;
        }

        public Path(Path parent, int index) {
            this.parent = parent;
            this.name = null;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return this.index == path.index && Objects.equals(this.parent, path.parent) && Objects.equals(this.name, path.name);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.name, this.index);
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            if (this.fullPath != null) {
                return this.fullPath;
            }
            buf = new byte[16];
            off = 0;
            level = 0;
            items = new Path[4];
            p = this;
            while (p != null) {
                if (items.length == level) {
                    items = Arrays.copyOf(items, items.length + 4);
                }
                items[level] = p;
                ++level;
                p = p.parent;
            }
            ascii = true;
            for (i = level - 1; i >= 0; --i) {
                block44: {
                    item = items[i];
                    name = item.name;
                    if (name == null) {
                        intValue = item.index;
                        intValueSize = IOUtils.stringSize(intValue);
                        while (off + intValueSize + 2 >= buf.length) {
                            newCapacity = buf.length + (buf.length >> 1);
                            buf = Arrays.copyOf(buf, newCapacity);
                        }
                        buf[off++] = 91;
                        IOUtils.getChars(intValue, off + intValueSize, buf);
                        off += intValueSize;
                        buf[off++] = 93;
                        continue;
                    }
                    if (off + 1 >= buf.length) {
                        newCapacity = buf.length + (buf.length >> 1);
                        buf = Arrays.copyOf(buf, newCapacity);
                    }
                    if (i != level - 1) {
                        buf[off++] = 46;
                    }
                    if (JDKUtils.JVM_VERSION != 8) break block44;
                    chars = name.toCharArray();
                    block9: for (j = 0; j < chars.length; ++j) {
                        ch = chars[j];
                        switch (ch) {
                            case 33: 
                            case 34: 
                            case 35: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 96: 
                            case 126: {
                                if (off + 1 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = 92;
                                buf[off++] = (byte)ch;
                                continue block9;
                            }
                            default: {
                                if (ch >= 1 && ch <= 127) {
                                    if (off == buf.length) {
                                        newCapacity = buf.length + (buf.length >> 1);
                                        buf = Arrays.copyOf(buf, newCapacity);
                                    }
                                    buf[off++] = (byte)ch;
                                    continue block9;
                                }
                                if (ch < 55296 || ch >= 57344) ** GOTO lbl86
                                ascii = false;
                                if (ch < 55296 || ch >= 56320) ** GOTO lbl67
                                if (name.length() - i < 2) {
                                    uc = -1;
                                } else {
                                    d = name.charAt(i + 1);
                                    if (d >= '\udc00' && d < '\ue000') {
                                        uc = (ch << 10) + d + -56613888;
                                    } else {
                                        buf[off++] = 63;
                                        continue block9;
lbl67:
                                        // 1 sources

                                        if (ch >= 56320 && ch < 57344) {
                                            buf[off++] = 63;
                                            continue block9;
                                        }
                                        uc = ch;
                                    }
                                }
                                if (uc < 0) {
                                    if (off == buf.length) {
                                        newCapacity = buf.length + (buf.length >> 1);
                                        buf = Arrays.copyOf(buf, newCapacity);
                                    }
                                    buf[off++] = 63;
                                    continue block9;
                                }
                                if (off + 3 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = (byte)(240 | uc >> 18);
                                buf[off++] = (byte)(128 | uc >> 12 & 63);
                                buf[off++] = (byte)(128 | uc >> 6 & 63);
                                buf[off++] = (byte)(128 | uc & 63);
                                ++j;
                                continue block9;
lbl86:
                                // 1 sources

                                if (ch > 2047) {
                                    if (off + 2 >= buf.length) {
                                        newCapacity = buf.length + (buf.length >> 1);
                                        buf = Arrays.copyOf(buf, newCapacity);
                                    }
                                    ascii = false;
                                    buf[off++] = (byte)(224 | ch >> 12 & 15);
                                    buf[off++] = (byte)(128 | ch >> 6 & 63);
                                    buf[off++] = (byte)(128 | ch >> 0 & 63);
                                    continue block9;
                                }
                                if (off + 1 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                ascii = false;
                                buf[off++] = (byte)(192 | ch >> 6 & 31);
                                buf[off++] = (byte)(128 | ch >> 0 & 63);
                            }
                        }
                    }
                    continue;
                }
                block10: for (j = 0; j < name.length(); ++j) {
                    ch = name.charAt(j);
                    switch (ch) {
                        case 33: 
                        case 34: 
                        case 35: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 96: 
                        case 126: {
                            if (off + 1 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            buf[off++] = 92;
                            buf[off++] = (byte)ch;
                            continue block10;
                        }
                        default: {
                            if (ch >= 1 && ch <= 127) {
                                if (off == buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = (byte)ch;
                                continue block10;
                            }
                            if (ch < 55296 || ch >= 57344) ** GOTO lbl152
                            ascii = false;
                            if (ch < 55296 || ch >= 56320) ** GOTO lbl133
                            if (name.length() - i < 2) {
                                uc = -1;
                            } else {
                                d = name.charAt(i + 1);
                                if (d >= '\udc00' && d < '\ue000') {
                                    uc = (ch << 10) + d + -56613888;
                                } else {
                                    buf[off++] = 63;
                                    continue block10;
lbl133:
                                    // 1 sources

                                    if (ch >= 56320 && ch < 57344) {
                                        buf[off++] = 63;
                                        continue block10;
                                    }
                                    uc = ch;
                                }
                            }
                            if (uc < 0) {
                                if (off == buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = 63;
                                continue block10;
                            }
                            if (off + 3 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            buf[off++] = (byte)(240 | uc >> 18);
                            buf[off++] = (byte)(128 | uc >> 12 & 63);
                            buf[off++] = (byte)(128 | uc >> 6 & 63);
                            buf[off++] = (byte)(128 | uc & 63);
                            ++j;
                            continue block10;
lbl152:
                            // 1 sources

                            if (ch > 2047) {
                                if (off + 2 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                ascii = false;
                                buf[off++] = (byte)(224 | ch >> 12 & 15);
                                buf[off++] = (byte)(128 | ch >> 6 & 63);
                                buf[off++] = (byte)(128 | ch >> 0 & 63);
                                continue block10;
                            }
                            if (off + 1 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            ascii = false;
                            buf[off++] = (byte)(192 | ch >> 6 & 31);
                            buf[off++] = (byte)(128 | ch >> 0 & 63);
                        }
                    }
                }
            }
            this.fullPath = new String(buf, 0, off, ascii != false ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8);
            return this.fullPath;
        }
    }
}

