/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.modules.ObjectCodecProvider;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ObjectWriterProvider
implements ObjectCodecProvider {
    static final long TYPE_BOOLEAN_MASK = 1L;
    static final long TYPE_INT32_MASK = 2L;
    static final long TYPE_INT64_MASK = 4L;
    static final long TYPE_DECIMAL_MASK = 8L;
    static final long TYPE_DATE_MASK = 16L;
    static final long TYPE_ENUM_MASK = 32L;
    final ConcurrentMap<Type, ObjectWriter> cache = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Type, ObjectWriter> cacheFieldBased = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final ObjectWriterCreator creator;
    final List<ObjectWriterModule> modules = new ArrayList<ObjectWriterModule>();
    volatile long userDefineMask;
    static final int ENUM = 16384;
    static final int[] PRIMITIVE_HASH_CODES;
    static final int[] NOT_REFERENCES_TYPE_HASH_CODES;

    public ObjectWriterProvider() {
        this.init();
        this.creator = ObjectWriterCreator.INSTANCE;
    }

    public ObjectWriterProvider(ObjectWriterCreator creator) {
        this.init();
        this.creator = creator;
    }

    public void mixIn(Class target, Class mixinSource) {
        if (mixinSource == null) {
            this.mixInCache.remove(target);
        } else {
            this.mixInCache.put(target, mixinSource);
        }
        this.cache.remove(target);
    }

    public ObjectWriterCreator getCreator() {
        ObjectWriterCreator contextCreator = JSONFactory.getContextWriterCreator();
        if (contextCreator != null) {
            return contextCreator;
        }
        return this.creator;
    }

    public ObjectWriter register(Type type, ObjectWriter objectWriter) {
        if (type == Integer.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplInt32.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFFDL) : (this.userDefineMask |= 2L);
        } else if (type == Long.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplInt64.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFFBL) : (this.userDefineMask |= 4L);
        } else if (type == BigDecimal.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplBigDecimal.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFF7L) : (this.userDefineMask |= 8L);
        } else if (type == Date.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplDate.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFEFL) : (this.userDefineMask |= 0x10L);
        } else if (type == Enum.class) {
            this.userDefineMask = objectWriter == null ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFDFL) : (this.userDefineMask |= 0x20L);
        }
        if (objectWriter == null) {
            return (ObjectWriter)this.cache.remove(type);
        }
        return this.cache.put(type, objectWriter);
    }

    public ObjectWriter registerIfAbsent(Type type, ObjectWriter objectWriter) {
        return this.cache.putIfAbsent(type, objectWriter);
    }

    public ObjectWriter unregister(Type type) {
        return (ObjectWriter)this.cache.remove(type);
    }

    public boolean unregister(Type type, ObjectWriter objectWriter) {
        return this.cache.remove(type, objectWriter);
    }

    public boolean register(ObjectWriterModule module) {
        for (int i = this.modules.size() - 1; i >= 0; --i) {
            if (this.modules.get(i) != module) continue;
            return false;
        }
        module.init(this);
        this.modules.add(0, module);
        return true;
    }

    public boolean unregister(ObjectWriterModule module) {
        return this.modules.remove(module);
    }

    @Override
    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void init() {
        this.modules.add(new ObjectWriterBaseModule(this));
    }

    public List<ObjectWriterModule> getModules() {
        return this.modules;
    }

    public ObjectWriter getObjectWriter(Class objectClass) {
        return this.getObjectWriter(objectClass, objectClass, false);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        return this.getObjectWriter(objectType, objectClass, false);
    }

    public ObjectWriter getObjectWriterFromCache(Type objectType, Class objectClass, boolean fieldBased) {
        return fieldBased ? (ObjectWriter)this.cacheFieldBased.get(objectType) : (ObjectWriter)this.cache.get(objectType);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass, boolean fieldBased) {
        ObjectWriter objectWriter;
        ObjectWriter objectWriter2 = objectWriter = fieldBased ? (ObjectWriter)this.cacheFieldBased.get(objectType) : (ObjectWriter)this.cache.get(objectType);
        if (objectWriter != null) {
            return objectWriter;
        }
        boolean useModules = true;
        if (fieldBased && objectClass != null && Iterable.class.isAssignableFrom(objectClass) && !Collection.class.isAssignableFrom(objectClass)) {
            useModules = false;
        }
        if (useModules) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ObjectWriter previous;
                Object module = this.modules.get(i);
                objectWriter = module.getObjectWriter(objectType, objectClass);
                if (objectWriter == null) continue;
                ObjectWriter objectWriter3 = previous = fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, objectWriter) : this.cache.putIfAbsent(objectType, objectWriter);
                if (previous != null) {
                    objectWriter = previous;
                }
                return objectWriter;
            }
        }
        if (objectWriter == null && objectClass != null && !fieldBased) {
            String className = objectClass.getName();
            switch (className) {
                case "com.google.common.collect.HashMultimap": 
                case "com.google.common.collect.LinkedListMultimap": 
                case "com.google.common.collect.LinkedHashMultimap": 
                case "com.google.common.collect.ArrayListMultimap": 
                case "com.google.common.collect.TreeMultimap": {
                    objectWriter = GuavaSupport.createAsMapWriter(objectClass);
                    break;
                }
                case "com.alibaba.fastjson.JSONObject": {
                    objectWriter = ObjectWriterImplMap.of(objectClass);
                    break;
                }
            }
        }
        if (objectWriter == null) {
            ObjectWriter previous;
            ObjectWriterCreator creator = this.getCreator();
            if (objectClass == null) {
                objectClass = TypeUtils.getMapping(objectType);
            }
            objectWriter = creator.createObjectWriter(objectClass, fieldBased ? JSONWriter.Feature.FieldBased.mask : 0L, this);
            ObjectWriter objectWriter4 = previous = fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, objectWriter) : this.cache.putIfAbsent(objectType, objectWriter);
            if (previous != null) {
                objectWriter = previous;
            }
        }
        return objectWriter;
    }

    public static boolean isPrimitiveOrEnum(Class<?> clazz) {
        return Arrays.binarySearch(PRIMITIVE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    public static boolean isNotReferenceDetect(Class<?> clazz) {
        return Arrays.binarySearch(NOT_REFERENCES_TYPE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    public void cleanup(Class objectClass) {
        this.mixInCache.remove(objectClass);
        this.cache.remove(objectClass);
        this.cacheFieldBased.remove(objectClass);
        BeanUtils.cleanupCache(objectClass);
    }

    public void cleanup(ClassLoader classLoader) {
        Class<?> keyClass;
        Type keyType;
        Map.Entry entry;
        Iterator it = this.mixInCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (((Class)entry.getKey()).getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            keyType = (Type)entry.getKey();
            keyClass = TypeUtils.getClass(keyType);
            if (keyClass == null || keyClass.getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = this.cacheFieldBased.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            keyType = (Type)entry.getKey();
            keyClass = TypeUtils.getClass(keyType);
            if (keyClass == null || keyClass.getClassLoader() != classLoader) continue;
            it.remove();
        }
        BeanUtils.cleanupCache(classLoader);
    }

    static {
        Class[] classes = new Class[]{Boolean.TYPE, Boolean.class, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigInteger.class, BigDecimal.class, String.class, Currency.class, Date.class, UUID.class, Locale.class, LocalTime.class, LocalDate.class, LocalDateTime.class, Instant.class, ZoneId.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class, String.class, Collections.emptyList().getClass(), Collections.emptyMap().getClass(), Collections.emptySet().getClass()};
        int[] codes = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            codes[i] = System.identityHashCode(classes[i]);
        }
        Arrays.sort(codes);
        PRIMITIVE_HASH_CODES = codes;
        int[] codes2 = Arrays.copyOf(codes, codes.length + 3);
        codes2[codes2.length - 1] = System.identityHashCode(Class.class);
        codes2[codes2.length - 2] = System.identityHashCode(int[].class);
        codes2[codes2.length - 3] = System.identityHashCode(long[].class);
        Arrays.sort(codes2);
        NOT_REFERENCES_TYPE_HASH_CODES = codes2;
    }
}

