/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType must not be null");
        }
        boolean inherited = annotationType.isAnnotationPresent(Inherited.class);
        return AnnotationUtils.findAnnotation(element, annotationType, inherited, new HashSet<Annotation>());
    }

    public static <A extends Annotation> A findAnnotation(Annotation annotation, Class<A> annotationType) {
        if (annotation == null) {
            throw new NullPointerException("annotation must not be null");
        }
        if (annotationType == null) {
            throw new NullPointerException("annotationType must not be null");
        }
        Class<? extends Annotation> annotationTypeClass = annotation.annotationType();
        if (annotationTypeClass == annotationType) {
            return (A)annotation;
        }
        boolean inherited = annotationType.isAnnotationPresent(Inherited.class);
        return AnnotationUtils.findAnnotation(annotationTypeClass, annotationType, inherited, new HashSet<Annotation>());
    }

    private static <A extends Annotation> A findAnnotation(AnnotatedElement element, Class<A> annotationType, boolean inherited, Set<Annotation> visited) {
        if (element == null || annotationType == null) {
            return null;
        }
        A annotation = element.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Annotation[] declaredAnnotations = element.getDeclaredAnnotations();
        A directMetaAnnotation = AnnotationUtils.findMetaAnnotation(annotationType, declaredAnnotations, inherited, visited);
        if (directMetaAnnotation != null) {
            return directMetaAnnotation;
        }
        if (element instanceof Class) {
            A annotationOnSuperclass;
            Class superclass;
            Class clazz = (Class)element;
            for (Class<?> ifc : clazz.getInterfaces()) {
                A annotationOnInterface;
                if (ifc == Annotation.class || (annotationOnInterface = AnnotationUtils.findAnnotation(ifc, annotationType, inherited, visited)) == null) continue;
                return annotationOnInterface;
            }
            if (inherited && (superclass = clazz.getSuperclass()) != null && superclass != Object.class && (annotationOnSuperclass = AnnotationUtils.findAnnotation(superclass, annotationType, inherited, visited)) != null) {
                return annotationOnSuperclass;
            }
        }
        return AnnotationUtils.findMetaAnnotation(annotationType, element.getAnnotations(), inherited, visited);
    }

    private static <A extends Annotation> A findMetaAnnotation(Class<A> annotationType, Annotation[] candidates, boolean inherited, Set<Annotation> visited) {
        for (Annotation candidateAnnotation : candidates) {
            A metaAnnotation;
            boolean isInJavaLangAnnotationPackage;
            Class<? extends Annotation> candidateAnnotationType = candidateAnnotation.annotationType();
            String name = candidateAnnotationType.getName();
            boolean bl = isInJavaLangAnnotationPackage = name.startsWith("java.lang.annotation") || name.startsWith("kotlin.");
            if (isInJavaLangAnnotationPackage || !visited.add(candidateAnnotation) || (metaAnnotation = AnnotationUtils.findAnnotation(candidateAnnotationType, annotationType, inherited, visited)) == null) continue;
            return metaAnnotation;
        }
        return null;
    }
}

