/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.schema.FormatValidator;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.time.DateTimeException;

final class DateValidator
implements FormatValidator {
    static final DateValidator INSTANCE = new DateValidator();

    DateValidator() {
    }

    @Override
    public boolean isValid(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.length() == 10 && str.charAt(4) == '-' && str.charAt(7) == '-') {
            char y0 = str.charAt(0);
            char y1 = str.charAt(1);
            char y2 = str.charAt(2);
            char y3 = str.charAt(3);
            char m0 = str.charAt(5);
            char m1 = str.charAt(6);
            char d0 = str.charAt(8);
            char d1 = str.charAt(9);
            int yyyy = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
            int mm = (m0 - 48) * 10 + (m1 - 48);
            int dd = (d0 - 48) * 10 + (d1 - 48);
            if (mm > 12) {
                return false;
            }
            if (dd > 28) {
                int dom = 31;
                switch (mm) {
                    case 2: {
                        boolean isLeapYear = (yyyy & 3) == 0 && (yyyy % 100 != 0 || yyyy % 400 == 0);
                        dom = isLeapYear ? 29 : 28;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        dom = 30;
                    }
                }
                if (dd > dom) {
                    return false;
                }
            } else if (dd > 31) {
                return false;
            }
            return true;
        }
        try {
            char[] chars = new char[str.length() + 2];
            chars[0] = 34;
            str.getChars(0, str.length(), chars, 1);
            chars[chars.length - 1] = 34;
            return JSONReader.of(chars, JSONSchema.CONTEXT).isLocalDate();
        }
        catch (JSONException | DateTimeException ignored) {
            return false;
        }
    }
}

