/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;

final class EnumSchema
extends JSONSchema {
    static final BigInteger BIGINT_INT64_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger BIGINT_INT64_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger BIGINT_INT32_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigInteger BIGINT_INT32_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    Set<Object> items;

    EnumSchema(Object ... items) {
        super(null, null);
        this.items = new LinkedHashSet<Object>(items.length);
        for (Object item : items) {
            if (item instanceof BigDecimal) {
                BigInteger bigInt;
                BigDecimal decimal = ((BigDecimal)item).stripTrailingZeros();
                item = decimal.scale() == 0 ? ((bigInt = decimal.toBigInteger()).compareTo(BIGINT_INT32_MIN) >= 0 && bigInt.compareTo(BIGINT_INT32_MAX) <= 0 ? (Number)bigInt.intValue() : (Number)(bigInt.compareTo(BIGINT_INT64_MIN) >= 0 && bigInt.compareTo(BIGINT_INT64_MAX) <= 0 ? Long.valueOf(bigInt.longValue()) : bigInt)) : decimal;
            }
            this.items.add(item);
        }
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Enum;
    }

    @Override
    public ValidateResult validate(Object value) {
        long longValue;
        BigInteger bigInt;
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            value = decimal.stripTrailingZeros();
            long longValue2 = decimal.longValue();
            if (decimal.compareTo(BigDecimal.valueOf(longValue2)) == 0) {
                value = longValue2;
            } else if (decimal.scale() == 0) {
                value = decimal.unscaledValue();
            }
        } else if (value instanceof BigInteger && (bigInt = (BigInteger)value).compareTo(BIGINT_INT64_MIN) >= 0 && bigInt.compareTo(BIGINT_INT64_MAX) <= 0) {
            value = bigInt.longValue();
        }
        if (value instanceof Long && (longValue = ((Long)value).longValue()) >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
            value = (int)longValue;
        }
        if (!this.items.contains(value)) {
            if (value == null) {
                return FAIL_INPUT_NULL;
            }
            return new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.Enum, value.getClass()});
        }
        return SUCCESS;
    }
}

