/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class JSONArray
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;
    static ObjectWriter<JSONArray> arrayWriter;
    static ObjectReader<JSONArray> arrayReader;
    static ObjectReader<JSONObject> objectReader;

    public JSONArray() {
    }

    public JSONArray(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONArray(Collection<?> collection) {
        super(collection);
    }

    public JSONArray(Object ... items) {
        super(items.length);
        for (Object item : items) {
            this.add(item);
        }
    }

    public JSONArray getJSONArray(int index) {
        Object value = this.get(index);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (arrayReader == null) {
                arrayReader = reader.getObjectReader((Type)((Object)JSONArray.class));
            }
            return arrayReader.readObject(reader, 0L);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection<?>)((Collection)value));
        }
        return null;
    }

    public JSONObject getJSONObject(int index) {
        Object value = this.get(index);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (objectReader == null) {
                objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            }
            return objectReader.readObject(reader, 0L);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value);
        }
        return null;
    }

    public String getString(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return JSON.toJSONString(value);
    }

    public Double getDouble(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Double");
    }

    public double getDoubleValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to double value");
    }

    public Float getFloat(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Float");
    }

    public float getFloatValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to float value");
    }

    public Long getLong(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Long");
    }

    public long getLongValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to long value");
    }

    public Integer getInteger(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Integer");
    }

    public int getIntValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to int value");
    }

    public Short getShort(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Short");
    }

    public short getShortValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to short value");
    }

    public Byte getByte(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Byte");
    }

    public byte getByteValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to byte value");
    }

    public Boolean getBoolean(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return str.equalsIgnoreCase("true") || str.equals("1");
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Boolean");
    }

    public boolean getBooleanValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.equalsIgnoreCase("true") || str.equals("1");
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to boolean value");
    }

    public BigInteger getBigInteger(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            long longValue = ((Number)value).longValue();
            return BigInteger.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigInteger");
    }

    public BigDecimal getBigDecimal(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof Float || value instanceof Double) {
                return new BigDecimal(value.toString());
            }
            long longValue = ((Number)value).longValue();
            return BigDecimal.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigDecimal(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigDecimal");
    }

    public Date getDate(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            if (millis == 0L) {
                return null;
            }
            return new Date(millis);
        }
        return TypeUtils.toDate(value);
    }

    public Instant getInstant(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            if (millis == 0L) {
                return null;
            }
            return Instant.ofEpochMilli(millis);
        }
        return TypeUtils.toInstant(value);
    }

    @Override
    public String toString() {
        try (JSONWriter writer = JSONWriter.of();){
            if (arrayWriter == null) {
                arrayWriter = writer.getObjectWriter((Type)((Object)JSONArray.class), JSONArray.class);
            }
            arrayWriter.write(writer, this, null, null, 0L);
            String string = writer.toString();
            return string;
        }
    }

    public String toJSONString() {
        return this.toString();
    }

    public <T> T toJavaObject(Type type) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(type);
        return objectReader.createInstance(this);
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(clazz);
        ArrayList list = new ArrayList(this.size());
        for (Object item : this) {
            if (!(item instanceof Map)) {
                throw new JSONException((item == null ? "null" : item.getClass()) + " cannot be converted to " + clazz);
            }
            Object classItem = objectReader.createInstance((Map)item);
            list.add(classItem);
        }
        return list;
    }

    public <T> T getObject(int index, Type type) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(valueClass, type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(value);
        }
        if (value instanceof Map) {
            ObjectReader objectReader = provider.getObjectReader(type);
            return objectReader.createInstance((Map)value);
        }
        if (value instanceof Collection) {
            ObjectReader objectReader = provider.getObjectReader(type);
            return objectReader.createInstance((Collection)value);
        }
        Class<?> clazz = TypeUtils.getMapping(type);
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        throw new JSONException("Can not convert from " + valueClass + " to " + type);
    }

    public JSONArray fluentAdd(Object element) {
        this.add(element);
        return this;
    }

    public static JSONArray of(Object ... items) {
        return new JSONArray(items);
    }

    public static JSONArray of(Object item) {
        JSONArray array = new JSONArray(1);
        array.add(item);
        return array;
    }

    public static JSONArray of(Object first, Object second) {
        JSONArray array = new JSONArray(2);
        array.add(first);
        array.add(second);
        return array;
    }

    public static JSONArray of(Object first, Object second, Object third) {
        JSONArray array = new JSONArray(3);
        array.add(first);
        array.add(second);
        array.add(third);
        return array;
    }
}

