/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public class JSONObject
extends LinkedHashMap
implements InvocationHandler {
    private static final long serialVersionUID = 1L;
    static ObjectReader<JSONArray> arrayReader;
    static ObjectWriter<JSONObject> objectWriter;
    static ObjectReader<JSONObject> objectReader;

    public JSONObject() {
    }

    public JSONObject(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONObject(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JSONObject(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
    }

    public JSONObject(Map map) {
        super(map);
    }

    public Object get(String key) {
        return super.get(key);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof Number || key instanceof Character || key instanceof Boolean) {
            return super.get(key.toString());
        }
        return super.get(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Set<String> keySet() {
        return super.keySet();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = super.containsKey(key);
        if (!result && (key instanceof Number || key instanceof Character || key instanceof Boolean || key instanceof UUID)) {
            result = super.containsKey(key.toString());
        }
        return result;
    }

    public Object getOrDefault(String key, Object defaultValue) {
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        if (key instanceof Number || key instanceof Character || key instanceof Boolean) {
            return super.getOrDefault(key.toString(), defaultValue);
        }
        return super.getOrDefault(key, defaultValue);
    }

    public JSONArray getJSONArray(String key) {
        Object value = super.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (arrayReader == null) {
                arrayReader = reader.getObjectReader((Type)((Object)JSONArray.class));
            }
            return arrayReader.readObject(reader, 0L);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection<?>)((Collection)value));
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object value = super.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (objectReader == null) {
                objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            }
            return objectReader.readObject(reader, 0L);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value);
        }
        return null;
    }

    public String getString(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return JSON.toJSONString(value);
    }

    public Double getDouble(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Double");
    }

    public double getDoubleValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to double value");
    }

    public Float getFloat(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Float");
    }

    public float getFloatValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to float value");
    }

    public Long getLong(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Long");
    }

    public long getLongValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to long value");
    }

    public Integer getInteger(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Integer");
    }

    public int getIntValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to int value");
    }

    public Short getShort(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Short");
    }

    public short getShortValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to short value");
    }

    public Byte getByte(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Byte");
    }

    public byte getByteValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to byte value");
    }

    public Boolean getBoolean(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return str.equalsIgnoreCase("true") || str.equals("1");
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Boolean");
    }

    public boolean getBooleanValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.equalsIgnoreCase("true") || str.equals("1");
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to boolean value");
    }

    public BigInteger getBigInteger(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            long longValue = ((Number)value).longValue();
            return BigInteger.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigInteger");
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof Float || value instanceof Double) {
                return new BigDecimal(value.toString());
            }
            long longValue = ((Number)value).longValue();
            return BigDecimal.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigDecimal(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigDecimal");
    }

    public Date getDate(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            if (millis == 0L) {
                return null;
            }
            return new Date(millis);
        }
        return TypeUtils.toDate(value);
    }

    public Instant getInstant(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            if (millis == 0L) {
                return null;
            }
            return Instant.ofEpochMilli(millis);
        }
        return TypeUtils.toInstant(value);
    }

    @Override
    public String toString() {
        try (JSONWriter writer = JSONWriter.of();){
            if (objectWriter == null) {
                objectWriter = writer.getObjectWriter(JSONObject.class);
            }
            objectWriter.write(writer, this, null, null, 0L);
            String string = writer.toString();
            return string;
        }
    }

    public String toJSONString() {
        return this.toString();
    }

    public <T> T toJavaObject(Type type) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(type);
        return objectReader.createInstance(this);
    }

    public <T> T toJavaObject(Class<T> clazz) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(clazz);
        return objectReader.createInstance(this);
    }

    public <T> T getObject(String key, Type type) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(valueClass, type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(value);
        }
        if (value instanceof Map) {
            ObjectReader objectReader = provider.getObjectReader(type);
            return objectReader.createInstance((Map)value);
        }
        if (value instanceof Collection) {
            ObjectReader objectReader = provider.getObjectReader(type);
            return objectReader.createInstance((Collection)value);
        }
        Class<?> clazz = TypeUtils.getMapping(type);
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        String json = JSON.toJSONString(value);
        JSONReader jsonReader = JSONReader.of(json);
        ObjectReader objectReader = provider.getObjectReader(clazz);
        return objectReader.readObject(jsonReader);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Function typeConvert;
        Object value;
        block25: {
            String name;
            block26: {
                String methodName;
                block27: {
                    methodName = method.getName();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length == 1) {
                        if (methodName.equals("equals")) {
                            return this.equals(args[0]);
                        }
                        if (method.getReturnType() != Void.TYPE) {
                            throw new JSONException("This method '" + methodName + "' is not a setter");
                        }
                        String name2 = null;
                        JSONField annotation = method.getAnnotation(JSONField.class);
                        if (annotation != null && (name2 = annotation.name()).isEmpty()) {
                            name2 = null;
                        }
                        if (name2 == null) {
                            name2 = methodName;
                            if (!name2.startsWith("set")) {
                                throw new JSONException("This method '" + methodName + "' is not a setter");
                            }
                            if ((name2 = name2.substring(3)).length() == 0) {
                                throw new JSONException("This method '" + methodName + "' is an illegal setter");
                            }
                            name2 = Character.toLowerCase(name2.charAt(0)) + name2.substring(1);
                        }
                        this.put(name2, args[0]);
                        return null;
                    }
                    if (parameterTypes.length != 0) {
                        throw new UnsupportedOperationException(method.toGenericString());
                    }
                    if (method.getReturnType() == Void.TYPE) {
                        throw new JSONException("This method '" + methodName + "' is not a getter");
                    }
                    name = null;
                    JSONField annotation = method.getAnnotation(JSONField.class);
                    if (annotation != null && (name = annotation.name()).isEmpty()) {
                        name = null;
                    }
                    if (name != null) break block26;
                    name = methodName;
                    if (!name.startsWith("get")) break block27;
                    if ((name = name.substring(3)).isEmpty()) {
                        throw new JSONException("This method '" + methodName + "' is an illegal getter");
                    }
                    value = this.get(name = Character.toLowerCase(name.charAt(0)) + name.substring(1));
                    if (value == null) {
                        return null;
                    }
                    break block25;
                }
                if (name.startsWith("is")) {
                    if (name.equals("isEmpty")) {
                        value = this.get("empty");
                        if (value == null) {
                            return this.isEmpty();
                        }
                        break block25;
                    } else {
                        if ((name = name.substring(2)).isEmpty()) {
                            throw new JSONException("This method '" + methodName + "' is an illegal getter");
                        }
                        value = this.get(name = Character.toLowerCase(name.charAt(0)) + name.substring(1));
                        if (value == null) {
                            return false;
                        }
                    }
                    break block25;
                } else {
                    if (name.equals("hashCode")) {
                        return this.hashCode();
                    }
                    if (name.equals("toString")) {
                        return this.toString();
                    }
                    if (name.startsWith("entrySet")) {
                        return this.entrySet();
                    }
                    if (name.equals("size")) {
                        return this.size();
                    }
                    throw new JSONException("This method '" + methodName + "' is not a getter");
                }
            }
            value = this.get(name);
            if (value == null) {
                return null;
            }
        }
        if ((typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(value.getClass(), method.getGenericReturnType())) != null) {
            return typeConvert.apply(value);
        }
        return value;
    }

    public JSONObject fluentPut(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public static JSONObject of(String key, Object value) {
        JSONObject object = new JSONObject(2);
        object.put(key, value);
        return object;
    }

    public static JSONObject of(String k1, Object v1, String k2, Object v2) {
        JSONObject object = new JSONObject(3);
        object.put(k1, v1);
        object.put(k2, v2);
        return object;
    }

    public static JSONObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        JSONObject object = new JSONObject(5);
        object.put(k1, v1);
        object.put(k2, v2);
        object.put(k3, v3);
        return object;
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        return JSON.parseObject(text, clazz);
    }
}

