/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLongArray;

final class FieldReaderAtomicLongArrayReadOnly<T>
extends FieldReaderImpl<T> {
    final Method method;

    FieldReaderAtomicLongArrayReadOnly(String fieldName, Class fieldType, int ordinal, Method method) {
        super(fieldName, fieldType, fieldType, ordinal, 0L, null);
        this.method = method;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        AtomicLongArray atomic;
        if (jsonReader.readIfNull()) {
            return;
        }
        try {
            atomic = (AtomicLongArray)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
        if (jsonReader.nextIfMatch('[')) {
            int i = 0;
            while (!jsonReader.nextIfMatch(']')) {
                long value = jsonReader.readInt64Value();
                if (atomic != null && i < atomic.length()) {
                    atomic.set(i, value);
                }
                ++i;
            }
        }
    }

    @Override
    public String toString() {
        return this.method.getName();
    }
}

