/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class FieldReaderAtomicReference<T>
extends FieldReaderImpl<T> {
    final Type referenceType;

    public FieldReaderAtomicReference(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format);
        ParameterizedType paramType;
        Type[] arguments;
        Type referenceType = null;
        if (fieldType instanceof ParameterizedType && (arguments = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 1) {
            referenceType = arguments[0];
        }
        this.referenceType = referenceType;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (jsonReader.nextIfNull()) {
            return;
        }
        Object refValue = jsonReader.read(this.referenceType);
        this.accept(object, refValue);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.read(this.referenceType);
    }
}

