/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectMethod;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class FieldReaderDateMethod<T>
extends FieldReaderObjectMethod<T> {
    volatile SimpleDateFormat formatter;
    static final AtomicReferenceFieldUpdater<FieldReaderDateMethod, SimpleDateFormat> FORMATTER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldReaderDateMethod.class, SimpleDateFormat.class, "formatter");
    ObjectReaderBaseModule.UtilDateImpl dateReader;

    FieldReaderDateMethod(String fieldName, Class fieldClass, int ordinal, long features, String format, Method method) {
        super(fieldName, fieldClass, fieldClass, ordinal, features, format, method);
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderBaseModule.UtilDateImpl.INSTANCE : new ObjectReaderBaseModule.UtilDateImpl(this.format);
        }
        return this.dateReader;
    }

    @Override
    public void accept(T object, Object value) {
        try {
            if (value instanceof String) {
                String str = (String)value;
                if (this.format != null) {
                    SimpleDateFormat formatter = FORMATTER_UPDATER.getAndSet(this, null);
                    if (formatter == null) {
                        formatter = new SimpleDateFormat(this.format);
                    }
                    try {
                        value = formatter.parse(str);
                    }
                    catch (ParseException e) {
                        throw new JSONException("parse date error, fieldName : " + this.fieldName, e);
                    }
                    finally {
                        FORMATTER_UPDATER.set(this, formatter);
                    }
                }
            }
            this.method.invoke(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Date fieldValue;
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            fieldValue = new Date(millis);
        } else if (jsonReader.isNull()) {
            jsonReader.readNull();
            fieldValue = null;
        } else if (this.format != null) {
            SimpleDateFormat formatter = FORMATTER_UPDATER.getAndSet(this, null);
            if (formatter == null) {
                formatter = new SimpleDateFormat(this.format);
            }
            try {
                String str = jsonReader.readString();
                fieldValue = formatter.parse(str);
            }
            catch (ParseException e) {
                throw new JSONException("parse date error, fieldName : " + this.fieldName, e);
            }
            finally {
                FORMATTER_UPDATER.set(this, formatter);
            }
        } else {
            long millis = jsonReader.readMillisFromString();
            fieldValue = new Date(millis);
        }
        try {
            this.method.invoke(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

