/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.util.Fnv;
import java.util.Arrays;

public final class ObjectArrayReader
extends ObjectReaderBaseModule.PrimitiveImpl {
    public static final ObjectArrayReader INSTANCE = new ObjectArrayReader();
    public static final long TYPE_HASH_CODE = Fnv.hashCode64("[O");

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfMatch('[')) {
            Object[] values = new Object[16];
            int size = 0;
            while (!jsonReader.nextIfMatch(']')) {
                Object value;
                int minCapacity = size + 1;
                if (minCapacity - values.length > 0) {
                    int oldCapacity = values.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    values = Arrays.copyOf(values, newCapacity);
                }
                char ch = jsonReader.current();
                switch (ch) {
                    case '\"': {
                        value = jsonReader.readString();
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = jsonReader.readNumber();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        value = null;
                        break;
                    }
                    case 'f': 
                    case 't': {
                        value = jsonReader.readBoolValue();
                        break;
                    }
                    case '{': {
                        value = jsonReader.readObject();
                        break;
                    }
                    case '[': {
                        value = jsonReader.readArray();
                        break;
                    }
                    default: {
                        throw new JSONException("not support : " + ch);
                    }
                }
                values[size++] = value;
            }
            jsonReader.nextIfMatch(',');
            return Arrays.copyOf(values, size);
        }
        throw new JSONException("TODO");
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        ObjectReader autoTypeObjectReader;
        if (jsonReader.getType() == -110 && (autoTypeObjectReader = jsonReader.checkAutoType(Object[].class, TYPE_HASH_CODE, features)) != this) {
            return autoTypeObjectReader.readJSONBObject(jsonReader, features);
        }
        int itemCnt = jsonReader.startArray();
        if (itemCnt == -1) {
            return null;
        }
        Object[] array = new Object[itemCnt];
        for (int i = 0; i < itemCnt; ++i) {
            Object value;
            byte type = jsonReader.getType();
            if (type >= 73 && type <= 125) {
                value = jsonReader.readString();
            } else if (type == -110) {
                ObjectReader autoTypeValueReader = jsonReader.checkAutoType(Object.class, 0L, features);
                value = autoTypeValueReader.readJSONBObject(jsonReader, features);
            } else if (type == -81) {
                jsonReader.next();
                value = null;
            } else if (type == -79) {
                jsonReader.next();
                value = Boolean.TRUE;
            } else if (type == -80) {
                jsonReader.next();
                value = Boolean.FALSE;
            } else {
                value = type == -66 ? Long.valueOf(jsonReader.readInt64Value()) : jsonReader.readAny();
            }
            array[i] = value;
        }
        return array;
    }
}

