/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReaderAdapter<T>
extends ObjectReaderBean<T> {
    protected final String typeKey;
    protected final long typeKeyHashCode;
    final long features;
    final Supplier<T> creator;
    final Function buildFunction;
    final FieldReader[] fieldReaders;
    final long[] hashCodes;
    final short[] mapping;
    final long[] hashCodesLCase;
    final short[] mappingLCase;
    final Constructor constructor;
    volatile boolean instantiationError;

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, Supplier<T> creator, Function buildFunction, FieldReader ... fieldReaders) {
        super(objectClass, typeName);
        int index;
        int i;
        Constructor constructor = this.constructor = objectClass == null ? null : BeanUtils.getDefaultConstructor(objectClass);
        if (this.constructor != null) {
            this.constructor.setAccessible(true);
        }
        if (typeKey == null || typeKey.isEmpty()) {
            this.typeKey = "@type";
            this.typeKeyHashCode = HASH_TYPE;
        } else {
            this.typeKey = typeKey;
            this.typeKeyHashCode = Fnv.hashCode64(typeKey);
        }
        this.features = features;
        this.creator = creator;
        this.buildFunction = buildFunction;
        this.fieldReaders = fieldReaders;
        long[] hashCodes = new long[fieldReaders.length];
        long[] hashCodesLCase = new long[fieldReaders.length];
        for (i = 0; i < fieldReaders.length; ++i) {
            FieldReader item = fieldReaders[i];
            String fieldName = item.getFieldName();
            hashCodes[i] = Fnv.hashCode64(fieldName);
            hashCodesLCase[i] = Fnv.hashCode64LCase(fieldName);
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i = 0; i < hashCodes.length; ++i) {
            long hashCode = hashCodes[i];
            index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i;
        }
        this.hashCodesLCase = Arrays.copyOf(hashCodesLCase, hashCodesLCase.length);
        Arrays.sort(this.hashCodesLCase);
        this.mappingLCase = new short[this.hashCodesLCase.length];
        for (i = 0; i < hashCodesLCase.length; ++i) {
            long hashCode = hashCodesLCase[i];
            index = Arrays.binarySearch(this.hashCodesLCase, hashCode);
            this.mappingLCase[index] = (short)i;
        }
    }

    @Override
    public String getTypeKey() {
        return this.typeKey;
    }

    @Override
    public long getTypeKeyHash() {
        return this.typeKeyHashCode;
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public Class getObjectClass() {
        return this.objectClass;
    }

    public Object auoType(JSONReader jsonReader, Class expectClass, long features) {
        String typeName;
        long typeHash = jsonReader.readTypeHashCode();
        JSONReader.Context context = jsonReader.getContext();
        ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
        if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), expectClass, this.features | features | context.getFeatures())) == null) {
            throw new JSONException("auotype not support : " + typeName);
        }
        return autoTypeObjectReader.readObject(jsonReader, features);
    }

    @Override
    public Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T readArrayMappingObject(JSONReader jsonReader) {
        jsonReader.nextIfMatch('[');
        T object = this.creator.get();
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            FieldReader fieldReader = this.fieldReaders[i];
            fieldReader.readFieldValue(jsonReader, object);
        }
        if (!jsonReader.nextIfMatch(']')) {
            throw new JSONException("array to bean end error, " + jsonReader.current());
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readArrayMappingJSONBObject(JSONReader jsonReader) {
        int entryCnt = jsonReader.startArray();
        T object = this.creator.get();
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            FieldReader fieldReader = this.fieldReaders[i];
            fieldReader.readFieldValue(jsonReader, object);
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    protected Object createInstance0(long features) throws InstantiationException {
        if (this.creator == null) {
            throw new JSONException("create instance error, " + this.objectClass);
        }
        return this.creator.get();
    }

    @Override
    public T createInstance(long features) {
        if (this.instantiationError && this.constructor != null) {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new JSONException("create instance error, " + this.objectClass, ex);
            }
        }
        if ((features & JSONReader.Feature.UseDefaultConstructorAsPossible.mask) != 0L && this.constructor.getParameterCount() == 0 && this.constructor != null) {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new JSONException("create instance error, " + this.objectClass, ex);
            }
        }
        try {
            return (T)this.createInstance0(features);
        }
        catch (InstantiationException ex) {
            InstantiationException error = ex;
            this.instantiationError = true;
            if (this.constructor != null) {
                try {
                    return this.constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex2) {
                    throw new JSONException("create instance error, " + this.objectClass, ex2);
                }
            }
            throw new JSONException("create instance error, " + this.objectClass, error);
        }
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        int m = Arrays.binarySearch(this.hashCodes, hashCode);
        if (m < 0) {
            return null;
        }
        short index = this.mapping[m];
        return this.fieldReaders[index];
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        int m = Arrays.binarySearch(this.hashCodesLCase, hashCode);
        if (m < 0) {
            return null;
        }
        short index = this.mappingLCase[m];
        return this.fieldReaders[index];
    }

    protected T autoType(JSONReader jsonReader) {
        String typeName;
        long typeHash = jsonReader.readTypeHashCode();
        JSONReader.Context context = jsonReader.getContext();
        ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
        if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
            throw new JSONException("auotype not support : " + typeName);
        }
        return autoTypeObjectReader.readJSONBObject(jsonReader, this.features);
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, long features) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, features);
        }
        if (jsonReader.isArray()) {
            if (jsonReader.isSupportBeanArray()) {
                return this.readArrayMappingJSONBObject(jsonReader);
            }
            throw new JSONException("expect object, but " + JSONB.typeName(jsonReader.getType()));
        }
        jsonReader.nextIfObjectStart();
        Object object = null;
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.typeKeyHashCode && i == 0) {
                String typeName;
                long typeHash = jsonReader.readValueHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException("auotype not support : " + typeName);
                }
                if (autoTypeObjectReader != this) {
                    jsonReader.setTypeRedirect(true);
                    return autoTypeObjectReader.readJSONBObject(jsonReader, features);
                }
            } else if (hash != 0L) {
                long nameHashCodeLCase;
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.features) && (nameHashCodeLCase = jsonReader.getNameHashCodeLCase()) != hash) {
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    jsonReader.skipValue();
                } else {
                    if (object == null) {
                        object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                    }
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        if (object == null) {
            object = this.createInstance(jsonReader.getContext().getFeatures() | features);
        }
        return object;
    }
}

