/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectWriterAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.support.money.MoneySupport;
import com.alibaba.fastjson2.util.ApacheLang3Support;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.JodaSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterArray;
import com.alibaba.fastjson2.writer.ObjectWriterBigInteger;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicBoolean;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicInteger;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicIntegerArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicLong;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicLongArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicReference;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolean;
import com.alibaba.fastjson2.writer.ObjectWriterImplCalendar;
import com.alibaba.fastjson2.writer.ObjectWriterImplCharValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplCharacter;
import com.alibaba.fastjson2.writer.ObjectWriterImplClass;
import com.alibaba.fastjson2.writer.ObjectWriterImplCollection;
import com.alibaba.fastjson2.writer.ObjectWriterImplCurrency;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplDouble;
import com.alibaba.fastjson2.writer.ObjectWriterImplDoubleValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloat;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloatValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInetAddress;
import com.alibaba.fastjson2.writer.ObjectWriterImplInstant;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt16;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt16ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplIterable;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import com.alibaba.fastjson2.writer.ObjectWriterImplListStr;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocale;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterImplMapEntry;
import com.alibaba.fastjson2.writer.ObjectWriterImplOffsetDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplOffsetTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptional;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalDouble;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalInt;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalLong;
import com.alibaba.fastjson2.writer.ObjectWriterImplStackTraceElement;
import com.alibaba.fastjson2.writer.ObjectWriterImplString;
import com.alibaba.fastjson2.writer.ObjectWriterImplStringArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplTimeZone;
import com.alibaba.fastjson2.writer.ObjectWriterImplToString;
import com.alibaba.fastjson2.writer.ObjectWriterImplUUID;
import com.alibaba.fastjson2.writer.ObjectWriterImplZonedDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import com.alibaba.fastjson2.writer.ObjectWriters;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

class ObjectWriterBaseModule
implements ObjectWriterModule {
    final ObjectWriterProvider provider;
    final WriterAnnotationProcessor annotationProcessor;

    public ObjectWriterBaseModule(ObjectWriterProvider provider) {
        this.provider = provider;
        this.annotationProcessor = new WriterAnnotationProcessor();
    }

    @Override
    public ObjectWriterAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    private void processJSONType1x(BeanInfo beanInfo, Annotation jsonType1x, Method method) {
        try {
            Object result = method.invoke((Object)jsonType1x, new Object[0]);
            switch (method.getName()) {
                case "seeAlso": {
                    Class[] classes = (Class[])result;
                    if (classes.length == 0) break;
                    beanInfo.seeAlso = classes;
                    break;
                }
                case "typeName": {
                    String typeName = (String)result;
                    if (typeName.isEmpty()) break;
                    beanInfo.typeName = typeName;
                    break;
                }
                case "typeKey": {
                    String typeKey = (String)result;
                    if (typeKey.isEmpty()) break;
                    beanInfo.typeKey = typeKey;
                    break;
                }
                case "serializeFeatures": 
                case "serialzeFeatures": {
                    Enum[] serializeFeatures;
                    block46: for (Enum feature : serializeFeatures = (Enum[])result) {
                        switch (feature.name()) {
                            case "WriteMapNullValue": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNulls.mask;
                                continue block46;
                            }
                            case "WriteNullListAsEmpty": 
                            case "WriteNullStringAsEmpty": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
                                continue block46;
                            }
                            case "BrowserCompatible": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.BrowserCompatible.mask;
                                continue block46;
                            }
                            case "WriteClassName": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteClassName.mask;
                                continue block46;
                            }
                            case "WriteNonStringValueAsString": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
                                continue block46;
                            }
                            case "WriteEnumUsingToString": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteEnumUsingToString.mask;
                                continue block46;
                            }
                            case "NotWriteRootClassName": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.NotWriteRootClassName.mask;
                                continue block46;
                            }
                            case "IgnoreErrorGetter": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.IgnoreErrorGetter.mask;
                                continue block46;
                            }
                        }
                    }
                    break;
                }
                case "serializeEnumAsJavaBean": {
                    boolean serializeEnumAsJavaBean = (Boolean)result;
                    if (!serializeEnumAsJavaBean) break;
                    beanInfo.writeEnumAsJavaBean = true;
                    break;
                }
                case "naming": {
                    Enum naming = (Enum)result;
                    beanInfo.namingStrategy = naming.name();
                    break;
                }
                case "ignores": {
                    String[] fields = (String[])result;
                    if (fields.length == 0) break;
                    beanInfo.ignores = fields;
                    break;
                }
                case "includes": {
                    String[] fields = (String[])result;
                    if (fields.length == 0) break;
                    beanInfo.includes = fields;
                    break;
                }
                case "orders": {
                    String[] fields = (String[])result;
                    if (fields.length == 0) break;
                    beanInfo.orders = fields;
                    break;
                }
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    ObjectWriter getExternalObjectWriter(String className, Class objectClass) {
        switch (className) {
            case "java.sql.Time": {
                return JdbcSupport.createTimeWriter(null);
            }
            case "java.sql.Timestamp": {
                return JdbcSupport.createTimestampWriter(null);
            }
            case "org.joda.time.chrono.GregorianChronology": {
                return JodaSupport.createGregorianChronologyWriter(objectClass);
            }
            case "org.joda.time.chrono.ISOChronology": {
                return JodaSupport.createISOChronologyWriter(objectClass);
            }
            case "org.joda.time.LocalDate": {
                return JodaSupport.createLocalDateWriter(objectClass);
            }
            case "org.joda.time.LocalDateTime": {
                return JodaSupport.createLocalDateTimeWriter(objectClass);
            }
        }
        return null;
    }

    @Override
    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        String objectClassName;
        String className;
        ObjectWriter externalObjectWriter;
        if (objectType == String.class) {
            return ObjectWriterImplString.INSTANCE;
        }
        if (objectClass == null) {
            objectClass = objectType instanceof Class ? (Class)objectType : TypeUtils.getMapping(objectType);
        }
        if ((externalObjectWriter = this.getExternalObjectWriter(className = objectClass.getName(), objectClass)) != null) {
            return externalObjectWriter;
        }
        switch (className) {
            case "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList": 
            case "com.google.common.collect.AbstractMapBasedMultimap$WrappedSet": {
                return null;
            }
            case "org.javamoney.moneta.internal.JDKCurrencyAdapter": {
                return ObjectWriterImplToString.INSTANCE;
            }
            case "org.javamoney.moneta.Money": {
                return MoneySupport.createMonetaryAmountWriter();
            }
            case "org.javamoney.moneta.spi.DefaultNumberValue": {
                return MoneySupport.createNumberValueWriter();
            }
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (rawType == List.class || rawType == ArrayList.class) {
                if (actualTypeArguments.length == 1 && actualTypeArguments[0] == String.class) {
                    return ObjectWriterImplListStr.INSTANCE;
                }
                objectType = rawType;
            }
        }
        if (objectType == LinkedList.class) {
            return ObjectWriterImplList.INSTANCE;
        }
        if (objectType == ArrayList.class || objectType == List.class || List.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplList.INSTANCE;
        }
        if (Collection.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplCollection.INSTANCE;
        }
        if (Iterable.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplIterable.INSTANCE;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplMap.of(objectClass);
        }
        if (Map.Entry.class.isAssignableFrom(objectClass) && !(objectClassName = objectClass.getName()).equals("org.apache.commons.lang3.tuple.ImmutablePair") && !objectClassName.equals("org.apache.commons.lang3.tuple.MutablePair")) {
            return ObjectWriterImplMapEntry.INSTANCE;
        }
        if (objectType == Integer.class) {
            return ObjectWriterImplInt32.INSTANCE;
        }
        if (objectType == AtomicInteger.class) {
            return ObjectWriterImplAtomicInteger.INSTANCE;
        }
        if (objectType == Byte.class) {
            return ObjectWriterImplInt8.INSTANCE;
        }
        if (objectType == Short.class) {
            return ObjectWriterImplInt16.INSTANCE;
        }
        if (objectType == Long.class) {
            return ObjectWriterImplInt64.INSTANCE;
        }
        if (objectType == AtomicLong.class) {
            return ObjectWriterImplAtomicLong.INSTANCE;
        }
        if (objectType == AtomicReference.class) {
            return ObjectWriterImplAtomicReference.INSTANCE;
        }
        if (objectType == Float.class) {
            return ObjectWriterImplFloat.INSTANCE;
        }
        if (objectType == Double.class) {
            return ObjectWriterImplDouble.INSTANCE;
        }
        if (objectType == BigInteger.class) {
            return ObjectWriterBigInteger.INSTANCE;
        }
        if (objectType == BigDecimal.class) {
            return ObjectWriterImplBigDecimal.INSTANCE;
        }
        if (objectType == OptionalInt.class) {
            return ObjectWriterImplOptionalInt.INSTANCE;
        }
        if (objectType == OptionalLong.class) {
            return ObjectWriterImplOptionalLong.INSTANCE;
        }
        if (objectType == OptionalLong.class) {
            return ObjectWriterImplOptionalLong.INSTANCE;
        }
        if (objectType == OptionalDouble.class) {
            return ObjectWriterImplOptionalDouble.INSTANCE;
        }
        if (objectType == Optional.class) {
            return ObjectWriterImplOptional.INSTANCE;
        }
        if (objectType == Boolean.class) {
            return ObjectWriterImplBoolean.INSTANCE;
        }
        if (objectType == AtomicBoolean.class) {
            return ObjectWriterImplAtomicBoolean.INSTANCE;
        }
        if (objectType == AtomicIntegerArray.class) {
            return ObjectWriterImplAtomicIntegerArray.INSTANCE;
        }
        if (objectType == AtomicLongArray.class) {
            return ObjectWriterImplAtomicLongArray.INSTANCE;
        }
        if (objectType == Character.class) {
            return ObjectWriterImplCharacter.INSTANCE;
        }
        if (objectType instanceof Class) {
            Class clazz = (Class)objectType;
            if (clazz.isEnum()) {
                Member valueField = BeanUtils.getEnumValueField(clazz);
                if (valueField == null) {
                    Class mixInSource = (Class)this.provider.mixInCache.get(objectClass);
                    Member mixedValueField = BeanUtils.getEnumValueField(mixInSource);
                    if (mixedValueField instanceof Field) {
                        try {
                            valueField = clazz.getField(mixedValueField.getName());
                        }
                        catch (NoSuchFieldException noSuchFieldException) {}
                    } else if (mixedValueField instanceof Method) {
                        try {
                            valueField = clazz.getMethod(mixedValueField.getName(), new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                return new ObjectWriterImplEnum(null, clazz, valueField, 0L);
            }
            if (TimeUnit.class.isAssignableFrom(clazz)) {
                return new ObjectWriterImplEnum(null, TimeUnit.class, null, 0L);
            }
            if (clazz == boolean[].class) {
                return ObjectWriterImplBoolValueArray.INSTANCE;
            }
            if (clazz == char[].class) {
                return ObjectWriterImplCharValueArray.INSTANCE;
            }
            if (clazz == byte[].class) {
                return ObjectWriterImplInt8ValueArray.INSTANCE;
            }
            if (clazz == short[].class) {
                return ObjectWriterImplInt16ValueArray.INSTANCE;
            }
            if (clazz == int[].class) {
                return ObjectWriterImplInt32ValueArray.INSTANCE;
            }
            if (clazz == long[].class) {
                return ObjectWriterImplInt64ValueArray.INSTANCE;
            }
            if (clazz == float[].class) {
                return ObjectWriterImplFloatValueArray.INSTANCE;
            }
            if (clazz == double[].class) {
                return ObjectWriterImplDoubleValueArray.INSTANCE;
            }
            if (clazz == Byte[].class) {
                return ObjectWriterImplInt8Array.INSTANCE;
            }
            if (clazz == Integer[].class) {
                return ObjectWriterImplInt32Array.INSTANCE;
            }
            if (clazz == Long[].class) {
                return ObjectWriterImplInt64Array.INSTANCE;
            }
            if (clazz == AtomicLongArray.class) {
                return ObjectWriterImplAtomicLongArray.INSTANCE;
            }
            if (String[].class == clazz) {
                return ObjectWriterImplStringArray.INSTANCE;
            }
            if (Object[].class.isAssignableFrom(clazz)) {
                if (clazz == Object[].class) {
                    return ObjectWriterArray.INSTANCE;
                }
                return new ObjectWriterArray(clazz.getComponentType());
            }
            if (clazz == UUID.class) {
                return ObjectWriterImplUUID.INSTANCE;
            }
            if (clazz == Locale.class) {
                return ObjectWriterImplLocale.INSTANCE;
            }
            if (clazz == Currency.class) {
                return ObjectWriterImplCurrency.INSTANCE;
            }
            if (TimeZone.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplTimeZone.INSTANCE;
            }
            if (clazz == URI.class || clazz == URL.class || ZoneId.class.isAssignableFrom(clazz) || Charset.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplToString.INSTANCE;
            }
            if (clazz == Inet4Address.class || clazz == Inet4Address.class) {
                return ObjectWriterImplInetAddress.INSTANCE;
            }
            externalObjectWriter = this.getExternalObjectWriter(clazz.getName(), clazz);
            if (externalObjectWriter != null) {
                return externalObjectWriter;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplDate.INSTANCE;
            }
            if (Calendar.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplCalendar.INSTANCE;
            }
            if (ZonedDateTime.class == clazz) {
                return ObjectWriterImplZonedDateTime.INSTANCE;
            }
            if (OffsetDateTime.class == clazz) {
                return ObjectWriterImplOffsetDateTime.INSTANCE;
            }
            if (LocalDateTime.class == clazz) {
                return ObjectWriterImplLocalDateTime.INSTANCE;
            }
            if (LocalDate.class == clazz) {
                return ObjectWriterImplLocalDate.INSTANCE;
            }
            if (LocalTime.class == clazz) {
                return ObjectWriterImplLocalTime.INSTANCE;
            }
            if (OffsetTime.class == clazz) {
                return ObjectWriterImplOffsetTime.INSTANCE;
            }
            if (Instant.class == clazz) {
                return ObjectWriterImplInstant.INSTANCE;
            }
            if (StackTraceElement.class == clazz) {
                return ObjectWriterImplStackTraceElement.INSTANCE;
            }
            if (Class.class == clazz) {
                return ObjectWriterImplClass.INSTANCE;
            }
            if (ParameterizedType.class.isAssignableFrom(clazz)) {
                return ObjectWriters.objectWriter(ParameterizedType.class, ObjectWriters.fieldWriter("actualTypeArguments", Type[].class, ParameterizedType::getActualTypeArguments), ObjectWriters.fieldWriter("ownerType", Type.class, ParameterizedType::getOwnerType), ObjectWriters.fieldWriter("rawType", Type.class, ParameterizedType::getRawType));
            }
        }
        return null;
    }

    static class VoidObjectWriter
    implements ObjectWriter {
        public static final VoidObjectWriter INSTANCE = new VoidObjectWriter();

        VoidObjectWriter() {
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        }
    }

    static abstract class PrimitiveImpl<T>
    implements ObjectWriter<T> {
        PrimitiveImpl() {
        }

        @Override
        public void writeArrayMappingJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            this.writeJSONB(jsonWriter, object, null, null, 0L);
        }

        @Override
        public void writeArrayMapping(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            this.write(jsonWriter, object, null, null, 0L);
        }
    }

    class WriterAnnotationProcessor
    implements ObjectWriterAnnotationProcessor {
        WriterAnnotationProcessor() {
        }

        @Override
        public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
            Class superclass = objectClass.getSuperclass();
            if (superclass != Object.class && superclass != null) {
                this.getBeanInfo(beanInfo, superclass);
            }
            Annotation jsonType1x = null;
            JSONType jsonType = null;
            Annotation[] annotations = objectClass.getAnnotations();
            block20: for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == JSONType.class) {
                    jsonType = (JSONType)annotation;
                    continue;
                }
                switch (annotationType.getName()) {
                    case "com.alibaba.fastjson.annotation.JSONType": {
                        jsonType1x = annotation;
                        continue block20;
                    }
                }
            }
            if (jsonType == null) {
                Class mixInSource = (Class<ApacheLang3Support.PairMixIn>)ObjectWriterBaseModule.this.provider.mixInCache.get(objectClass);
                if (mixInSource == null) {
                    String typeName;
                    switch (typeName = objectClass.getName()) {
                        case "org.apache.commons.lang3.tuple.ImmutablePair": {
                            mixInSource = ApacheLang3Support.PairMixIn.class;
                            ObjectWriterBaseModule.this.provider.mixIn(objectClass, ApacheLang3Support.PairMixIn.class);
                            break;
                        }
                        case "org.apache.commons.lang3.tuple.MutablePair": {
                            mixInSource = ApacheLang3Support.MutablePairMixIn.class;
                            ObjectWriterBaseModule.this.provider.mixIn(objectClass, ApacheLang3Support.MutablePairMixIn.class);
                            break;
                        }
                    }
                }
                if (mixInSource != null) {
                    Annotation[] mixInAnnotations;
                    beanInfo.mixIn = true;
                    block21: for (Annotation annotation : mixInAnnotations = mixInSource.getAnnotations()) {
                        String annotationTypeName;
                        Class<? extends Annotation> annotationType = annotation.annotationType();
                        if (annotationType == JSONType.class) {
                            jsonType = (JSONType)annotation;
                            continue;
                        }
                        switch (annotationTypeName = annotationType.getName()) {
                            case "com.alibaba.fastjson.annotation.JSONType": {
                                jsonType1x = annotation;
                                continue block21;
                            }
                        }
                    }
                }
            }
            if (jsonType != null) {
                String[] includes;
                String typeName;
                String typeKey;
                Class<?>[] classes = jsonType.seeAlso();
                if (classes.length != 0) {
                    beanInfo.seeAlso = classes;
                }
                if (!(typeKey = jsonType.typeKey()).isEmpty()) {
                    beanInfo.typeKey = typeKey;
                }
                if (!(typeName = jsonType.typeName()).isEmpty()) {
                    beanInfo.typeName = typeName;
                }
                for (JSONWriter.Feature feature : jsonType.serializeFeatures1()) {
                    beanInfo.writerFeatures |= feature.mask;
                }
                beanInfo.namingStrategy = jsonType.naming().name();
                String[] ignores = jsonType.ignores();
                if (ignores.length > 0) {
                    beanInfo.ignores = ignores;
                }
                if ((includes = jsonType.includes()).length > 0) {
                    beanInfo.includes = includes;
                }
            } else if (jsonType1x != null) {
                Annotation annotation = jsonType1x;
                BeanUtils.annotationMethods(jsonType1x.annotationType(), method -> ObjectWriterBaseModule.this.processJSONType1x(beanInfo, annotation, method));
            }
            if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0) {
                for (Class seeAlsoClass : beanInfo.seeAlso) {
                    if (seeAlsoClass != objectClass) continue;
                    beanInfo.typeName = objectClass.getSimpleName();
                }
            }
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectType, Field field) {
            Class writeUsing;
            String jsonFieldFormat;
            Annotation[] annotations;
            int modifiers;
            boolean isTransient;
            Class fieldClassMixInSource;
            Class<ApacheLang3Support.PairMixIn> mixInSource = (Class<ApacheLang3Support.PairMixIn>)ObjectWriterBaseModule.this.provider.mixInCache.get(objectType);
            if (objectType == null) {
                String typeName;
                switch (typeName = objectType.getName()) {
                    case "org.apache.commons.lang3.tuple.ImmutablePair": {
                        mixInSource = ApacheLang3Support.PairMixIn.class;
                        ObjectWriterBaseModule.this.provider.mixIn(objectType, ApacheLang3Support.PairMixIn.class);
                        break;
                    }
                }
            }
            if (mixInSource != null && mixInSource != objectType) {
                Field mixInField = null;
                try {
                    mixInField = mixInSource.getDeclaredField(field.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInField != null) {
                    this.getFieldInfo(fieldInfo, (Class)mixInSource, mixInField);
                }
            }
            if ((fieldClassMixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(field.getType())) != null) {
                fieldInfo.fieldClassMixIn = true;
            }
            if (isTransient = Modifier.isTransient(modifiers = field.getModifiers())) {
                fieldInfo.ignore = true;
            }
            JSONField jsonField = null;
            block16: for (Annotation annotation : annotations = field.getAnnotations()) {
                String annotationTypeName;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == JSONField.class) {
                    jsonField = (JSONField)annotation;
                }
                switch (annotationTypeName = annotationType.getName()) {
                    case "com.fasterxml.jackson.annotation.JsonIgnore": {
                        fieldInfo.ignore = true;
                        continue block16;
                    }
                    case "com.alibaba.fastjson.annotation.JSONField": {
                        this.processJSONField1x(fieldInfo, annotation);
                        continue block16;
                    }
                }
            }
            if (jsonField == null) {
                return;
            }
            String jsonFieldName = jsonField.name();
            if (!jsonFieldName.isEmpty()) {
                fieldInfo.fieldName = jsonFieldName;
            }
            if (!(jsonFieldFormat = jsonField.format()).isEmpty()) {
                if ((jsonFieldFormat = jsonFieldFormat.trim()).indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                    jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
                }
                if (!jsonFieldFormat.isEmpty()) {
                    fieldInfo.format = jsonFieldFormat;
                }
            }
            if (!fieldInfo.ignore) {
                boolean bl = fieldInfo.ignore = !jsonField.serialize();
            }
            if (jsonField.unwrapped()) {
                fieldInfo.format = "unwrapped";
            }
            for (JSONWriter.Feature feature : jsonField.serializeFeatures()) {
                fieldInfo.features |= feature.mask;
            }
            int ordinal = jsonField.ordinal();
            if (ordinal != 0) {
                fieldInfo.ordinal = ordinal;
            }
            if ((writeUsing = jsonField.writeUsing()) != Void.TYPE && writeUsing != Void.class && ObjectWriter.class.isAssignableFrom(writeUsing)) {
                fieldInfo.writeUsing = writeUsing;
            }
        }

        private void processJSONField1x(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "name": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            fieldInfo.fieldName = value;
                            break;
                        }
                        case "format": {
                            String format = (String)result;
                            if (format.isEmpty()) break;
                            if ((format = format.trim()).indexOf(84) != -1 && !format.contains("'T'")) {
                                format = format.replaceAll("T", "'T'");
                            }
                            if (format.isEmpty()) break;
                            fieldInfo.format = format;
                            break;
                        }
                        case "ordinal": {
                            Integer ordinal = (Integer)result;
                            if (ordinal == 0) break;
                            fieldInfo.ordinal = ordinal;
                            break;
                        }
                        case "serialize": {
                            Boolean serialize = (Boolean)result;
                            if (serialize.booleanValue()) break;
                            fieldInfo.ignore = true;
                            break;
                        }
                        case "unwrapped": {
                            Boolean unwrapped = (Boolean)result;
                            if (!unwrapped.booleanValue()) break;
                            fieldInfo.format = "unwrapped";
                            break;
                        }
                        case "serialzeFeatures": {
                            Enum[] features = (Enum[])result;
                            this.applyFeatures(fieldInfo, features);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void applyFeatures(FieldInfo fieldInfo, Enum[] features) {
            block25: for (Enum feature : features) {
                switch (feature.name()) {
                    case "UseISO8601DateFormat": {
                        fieldInfo.format = "iso8601";
                        continue block25;
                    }
                    case "WriteMapNullValue": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNulls.mask;
                        continue block25;
                    }
                    case "WriteNullListAsEmpty": 
                    case "WriteNullStringAsEmpty": {
                        fieldInfo.features |= JSONWriter.Feature.NullAsDefaultValue.mask;
                        continue block25;
                    }
                    case "BrowserCompatible": {
                        fieldInfo.features |= JSONWriter.Feature.BrowserCompatible.mask;
                        continue block25;
                    }
                    case "WriteClassName": {
                        fieldInfo.features |= JSONWriter.Feature.WriteClassName.mask;
                        continue block25;
                    }
                    case "WriteNonStringValueAsString": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
                        continue block25;
                    }
                    case "WriteEnumUsingToString": {
                        fieldInfo.features |= JSONWriter.Feature.WriteEnumUsingToString.mask;
                        continue block25;
                    }
                    case "NotWriteRootClassName": {
                        fieldInfo.features |= JSONWriter.Feature.NotWriteRootClassName.mask;
                        continue block25;
                    }
                    case "IgnoreErrorGetter": {
                        fieldInfo.features |= JSONWriter.Feature.IgnoreErrorGetter.mask;
                        continue block25;
                    }
                    case "WriteBigDecimalAsPlain": {
                        fieldInfo.features |= JSONWriter.Feature.WriteBigDecimalAsPlain.mask;
                        continue block25;
                    }
                }
            }
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
            Annotation[] annotations;
            Class fieldClassMixInSource;
            Class mixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(objectClass);
            String methodName = method.getName();
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(methodName, method.getParameterTypes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInMethod);
                }
            }
            if ((fieldClassMixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(method.getReturnType())) != null) {
                fieldInfo.fieldClassMixIn = true;
            }
            if (JDKUtils.CLASS_TRANSIENT != null && method.getAnnotation(JDKUtils.CLASS_TRANSIENT) != null) {
                fieldInfo.ignore = true;
            }
            JSONField jsonField = null;
            block12: for (Annotation annotation : annotations = method.getAnnotations()) {
                String annotationTypeName;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == JSONField.class) {
                    jsonField = (JSONField)annotation;
                }
                switch (annotationTypeName = annotationType.getName()) {
                    case "com.fasterxml.jackson.annotation.JsonIgnore": {
                        fieldInfo.ignore = true;
                        continue block12;
                    }
                    case "com.alibaba.fastjson.annotation.JSONField": {
                        this.processJSONField1x(fieldInfo, annotation);
                        continue block12;
                    }
                    case "java.beans.Transient": {
                        fieldInfo.isTransient = true;
                        continue block12;
                    }
                }
            }
            if (jsonField != null) {
                String jsonFieldFormat;
                String jsonFieldName = jsonField.name();
                if (!jsonFieldName.isEmpty()) {
                    fieldInfo.fieldName = jsonFieldName;
                }
                if (!(jsonFieldFormat = jsonField.format()).isEmpty()) {
                    if ((jsonFieldFormat = jsonFieldFormat.trim()).indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                        jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
                    }
                    if (!jsonFieldFormat.isEmpty()) {
                        fieldInfo.format = jsonFieldFormat;
                    }
                }
                if (!fieldInfo.ignore) {
                    boolean bl = fieldInfo.ignore = !jsonField.serialize();
                }
                if (jsonField.unwrapped()) {
                    fieldInfo.format = "unwrapped";
                }
                for (JSONWriter.Feature feature : jsonField.serializeFeatures()) {
                    fieldInfo.features |= feature.mask;
                }
                int ordinal = jsonField.ordinal();
                if (ordinal != 0) {
                    fieldInfo.ordinal = ordinal;
                }
            }
            if (!objectClass.getName().startsWith("java.lang")) {
                String fieldName = BeanUtils.getterName(methodName, null);
                BeanUtils.declaredFields(objectClass, field -> {
                    int modifiers;
                    if (field.getName().equalsIgnoreCase(fieldName) && !Modifier.isPublic(modifiers = field.getModifiers()) && !Modifier.isStatic(modifiers)) {
                        this.getFieldInfo(fieldInfo, objectClass, (Field)field);
                    }
                });
            }
        }
    }
}

