/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

interface FieldListStrReader<T>
extends FieldReader<T> {
    @Override
    default public Type getFieldType() {
        return List.class;
    }

    @Override
    default public Class getFieldClass() {
        return List.class;
    }

    @Override
    default public Type getItemType() {
        return String.class;
    }

    default public List<String> createList() {
        return new ArrayList<String>();
    }

    default public ObjectReader<T> getItemConsumer(JSONReader.Context ctx) {
        return ctx.getObjectReader(this.getItemType());
    }

    @Override
    default public void readFieldValue(JSONReader jsonReader, T object) {
        if (jsonReader.isJSONB()) {
            int entryCnt = jsonReader.startArray();
            String[] array = new String[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readString();
            }
            List<String> list = Arrays.asList(array);
            this.accept(object, list);
            return;
        }
        if (jsonReader.current() == '[') {
            List<String> list = this.createList();
            jsonReader.startArray();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(jsonReader.readString());
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
        }
    }
}

