/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class ObjectReaderImplObject
extends ObjectReaderBaseModule.PrimitiveImpl {
    static final ObjectReaderImplObject INSTANCE = new ObjectReaderImplObject();

    ObjectReaderImplObject() {
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        Object value;
        if (jsonReader.isJSONB()) {
            return jsonReader.readAny();
        }
        JSONReader.Context context = jsonReader.getContext();
        if (jsonReader.isObject()) {
            Map<String, Object> object;
            Class objectClass;
            jsonReader.next();
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == HASH_TYPE) {
                ObjectReader autoTypeObjectReader;
                boolean supportAutoType = context.isEnable(JSONReader.Feature.SupportAutoType);
                if (supportAutoType) {
                    long typeHash = jsonReader.readTypeHashCode();
                    autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                    if (autoTypeObjectReader == null) {
                        String typeName = jsonReader.getString();
                        autoTypeObjectReader = context.getObjectReaderAutoType(typeName, null);
                    }
                } else {
                    String typeName = jsonReader.readString();
                    autoTypeObjectReader = context.getObjectReaderAutoType(typeName, null);
                }
                if (autoTypeObjectReader != null) {
                    jsonReader.setTypeRedirect(true);
                    return autoTypeObjectReader.readObject(jsonReader, features);
                }
            }
            if ((objectClass = context.getObjectClass()) != null) {
                try {
                    if (objectClass == JSONObject.class) {
                        object = new JSONObject();
                    }
                    if (objectClass == HashMap.class) {
                        object = new HashMap();
                    }
                    if (objectClass == LinkedHashMap.class) {
                        object = new LinkedHashMap();
                    }
                    object = (Map)objectClass.newInstance();
                }
                catch (Throwable e) {
                    throw new JSONException("createObject error", e);
                }
            } else {
                object = (HashMap)ObjectReaderImplMap.INSTANCE_OBJECT.createInstance(jsonReader.features(features));
            }
            int i = 0;
            while (!jsonReader.nextIfMatch('}')) {
                Object value2;
                String name = i == 0 ? jsonReader.getFieldName() : jsonReader.readFieldName();
                if (name == null) {
                    name = jsonReader.readFieldNameUnquote();
                    if (jsonReader.current() == ':') {
                        jsonReader.next();
                    }
                }
                switch (jsonReader.current()) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value2 = jsonReader.readNumber();
                        break;
                    }
                    case '[': {
                        value2 = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        value2 = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        value2 = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        value2 = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        value2 = null;
                        break;
                    }
                    default: {
                        throw new JSONException("error, offset " + jsonReader.getOffset() + ", char " + jsonReader.current());
                    }
                }
                object.put(name, value2);
                ++i;
            }
            jsonReader.nextIfMatch(',');
            return object;
        }
        switch (jsonReader.current()) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                value = jsonReader.readNumber();
                break;
            }
            case '[': {
                value = jsonReader.readArray();
                break;
            }
            case '\"': 
            case '\'': {
                value = jsonReader.readString();
                break;
            }
            case 'f': 
            case 't': {
                value = jsonReader.readBoolValue();
                break;
            }
            case 'n': {
                jsonReader.readNull();
                value = null;
                break;
            }
            default: {
                throw new JSONException("TODO : " + jsonReader.current());
            }
        }
        return value;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        byte type = jsonReader.getType();
        if (type >= 73 && type <= 125) {
            return jsonReader.readString();
        }
        if (type == -110) {
            ObjectReader autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, features);
            return autoTypeObjectReader.readJSONBObject(jsonReader, features);
        }
        if (type == -81) {
            jsonReader.next();
            return null;
        }
        return jsonReader.readAny();
    }
}

