/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class Differ {
    final Object left;
    final Object right;
    boolean skipTransient = true;
    String leftName = "left";
    String rightName = "right";
    boolean referenceDetect = true;
    IdentityHashMap<Object, JSONWriter.Path> leftReferences = new IdentityHashMap();
    IdentityHashMap<Object, JSONWriter.Path> rightReferences = new IdentityHashMap();
    private Comparator comparator;
    PrintStream out = System.out;

    public Differ(Object left, Object right) {
        this.left = left;
        this.right = right;
    }

    public boolean isSkipTransient() {
        return this.skipTransient;
    }

    public void setSkipTransient(boolean skipTransient) {
        this.skipTransient = skipTransient;
    }

    public boolean isReferenceDetect() {
        return this.referenceDetect;
    }

    public void setReferenceDetect(boolean referenceDetect) {
        this.referenceDetect = referenceDetect;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public static void diff(Object a, Object b) {
        new Differ(a, b).diff();
    }

    public String getLeftName() {
        return this.leftName;
    }

    public void setLeftName(String leftName) {
        this.leftName = leftName;
    }

    public String getRightName() {
        return this.rightName;
    }

    public void setRightName(String rightName) {
        this.rightName = rightName;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public boolean diff() {
        return this.diff(this.left, this.right, new JSONWriter.Path(null, "$"), null);
    }

    boolean diff(Object left, Object right, JSONWriter.Path path, Type type) {
        int cmp;
        int i;
        boolean match = true;
        if (left == right) {
            return true;
        }
        if (left == null) {
            if (this.out != null) {
                this.out.println("diff type " + path + ", " + this.leftName + " is null, " + this.rightName + " class " + right.getClass());
            }
            return false;
        }
        if (right == null) {
            if (this.out != null) {
                this.out.println("diff type " + path + ", " + this.rightName + " is null, " + this.leftName + " class " + left.getClass());
            }
            return false;
        }
        Class<?> leftClass = left.getClass();
        if (leftClass != right.getClass()) {
            if (this.out != null) {
                this.out.println("diff type " + path + ", " + this.leftName + " " + leftClass + ", " + this.rightName + " " + right.getClass());
            }
            return false;
        }
        if (ObjectWriterProvider.isPrimitiveOrEnum(leftClass)) {
            int cmp2;
            if (!left.equals(right)) {
                if (this.out != null) {
                    this.out.println("diff value " + path + ", " + this.leftName + " " + left + ", " + this.rightName + " " + right);
                }
                return false;
            }
            if (this.comparator != null && (cmp2 = this.comparator.compare(left, right)) != 0) {
                if (this.out != null) {
                    this.out.println("diff compare " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
                }
                return false;
            }
            return true;
        }
        if (this.referenceDetect) {
            boolean isRightKeyRef;
            boolean isLeftKeyRef;
            boolean keyPathRef;
            JSONWriter.Path leftRefPath = this.leftReferences.put(left, path);
            JSONWriter.Path rightRefPath = this.rightReferences.put(right, path);
            boolean bl = keyPathRef = path != null && path.toString().contains("\\#");
            if (keyPathRef) {
                return true;
            }
            boolean bl2 = isLeftKeyRef = leftRefPath != null && leftRefPath.toString().contains("\\#");
            if (isLeftKeyRef) {
                return true;
            }
            boolean bl3 = isRightKeyRef = rightRefPath != null && rightRefPath.toString().contains("\\#");
            if (isRightKeyRef) {
                return true;
            }
            if (leftRefPath != null && rightRefPath != null) {
                if (leftRefPath.equals(rightRefPath)) {
                    return true;
                }
                if (this.out != null) {
                    this.out.println("diff reference " + path + ", " + this.leftName + " " + leftRefPath + ", " + this.rightName + " " + rightRefPath + ", " + this.leftName + " class " + left.getClass() + ", " + this.rightName + " class " + right.getClass());
                }
                return false;
            }
            if (this.referenceDetect) {
                if (leftRefPath != null) {
                    if (this.out != null) {
                        this.out.println("diff reference " + path + ", " + this.rightName + " is null, " + this.leftName + " " + leftRefPath + ", class " + left.getClass());
                    }
                    return false;
                }
                if (rightRefPath != null) {
                    if (this.out != null) {
                        this.out.println("diff reference " + path + ", " + this.leftName + " is null, " + this.rightName + " " + rightRefPath + ", class " + right.getClass());
                    }
                    return false;
                }
            }
        }
        if (left instanceof HashSet) {
            return this.diffHashSet((Set)left, (Set)right, path, type, leftClass);
        }
        if (left instanceof Collection) {
            int cmp3;
            Collection leftCollection = (Collection)left;
            Collection rightCollection = (Collection)right;
            if (leftCollection.size() != rightCollection.size()) {
                if (this.out != null) {
                    this.out.println("diff collection size " + path + ", " + this.leftName + " " + leftCollection.size() + ", " + this.rightName + " " + rightCollection.size());
                }
                return false;
            }
            Iterator leftIt = leftCollection.iterator();
            Iterator rightIt = rightCollection.iterator();
            int i2 = 0;
            while (leftIt.hasNext()) {
                Object leftItem = leftIt.next();
                rightIt.hasNext();
                Object rightItem = rightIt.next();
                boolean result = this.diff(leftItem, rightItem, new JSONWriter.Path(path, i2), null);
                if (!result) {
                    this.out.println("diff collection " + path + ", " + leftClass.getName());
                    return false;
                }
                ++i2;
            }
            if (this.comparator != null && (cmp3 = this.comparator.compare(left, right)) != 0) {
                if (this.out != null) {
                    this.out.println("diff collection compare " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
                }
                return false;
            }
            return match;
        }
        if (left instanceof Object[]) {
            int cmp4;
            Object[] leftArray = (Object[])left;
            Object[] rightArray = (Object[])right;
            if (leftArray.length != rightArray.length) {
                if (this.out != null) {
                    this.out.println("diff array size " + path + ", " + this.leftName + " " + leftArray.length + ", " + this.rightName + " " + rightArray.length);
                }
                return false;
            }
            for (i = 0; i < leftArray.length; ++i) {
                Object leftItem = leftArray[i];
                Object rightItem = rightArray[i];
                boolean result = this.diff(leftItem, rightItem, new JSONWriter.Path(path, i), null);
                if (result) continue;
                if (this.out != null) {
                    this.out.println("diff array " + path + ", " + leftClass.getName());
                }
                return false;
            }
            if (this.comparator != null && (cmp4 = this.comparator.compare(left, right)) != 0) {
                if (this.out != null) {
                    this.out.println("diff array compare " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
                }
                return false;
            }
            return match;
        }
        if (left instanceof SortedMap || left instanceof LinkedHashMap || left instanceof ConcurrentSkipListMap) {
            int cmp5;
            Map leftMap = (Map)left;
            Map rightMap = (Map)right;
            if (leftMap.size() != rightMap.size()) {
                if (this.out != null) {
                    this.out.println("diff map size " + path + ", " + this.leftName + " " + leftMap.size() + ", " + this.rightName + " " + rightMap.size() + ", " + leftMap.getClass().getName());
                }
                return false;
            }
            Iterator rightIt = rightMap.entrySet().iterator();
            for (Map.Entry leftEntry : leftMap.entrySet()) {
                Object rightValue;
                Map.Entry rightEntry = rightIt.next();
                Object key = leftEntry.getKey();
                Object leftValue = leftEntry.getValue();
                boolean result = this.diff(leftValue, rightValue = rightEntry.getValue(), new JSONWriter.Path(path, key.toString()), null);
                if (result) continue;
                if (this.out != null) {
                    this.out.println("diff sortedMap " + path + ", " + leftClass.getName());
                }
                return false;
            }
            if (this.comparator != null && (cmp5 = this.comparator.compare(left, right)) != 0) {
                if (this.out != null) {
                    this.out.println("diff sortedMap compare map " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
                }
                return false;
            }
            return match;
        }
        if (left instanceof Map) {
            return this.diffMap((Map)left, (Map)right, path, match, leftClass);
        }
        if (left instanceof String) {
            String leftStr = (String)left;
            String rightStr = (String)right;
            if (leftStr.equals(rightStr)) {
                return true;
            }
            if (leftStr.length() != rightStr.length()) {
                if (this.out != null) {
                    this.out.println("diff str len " + path + ", " + this.leftName + " " + leftStr.length() + ", " + this.rightName + " " + rightStr.length());
                }
                return false;
            }
            for (i = 0; i < leftStr.length(); ++i) {
                char rightChar;
                char leftChar = leftStr.charAt(i);
                if (leftChar == (rightChar = rightStr.charAt(i))) continue;
                if (this.out != null) {
                    this.out.println("diff str " + path + ", at " + i + ", " + this.leftName + " " + leftChar + ", " + this.rightName + " " + rightChar);
                }
                return false;
            }
            if (!leftStr.equals(rightStr)) {
                if (this.out != null) {
                    this.out.println("diff str " + path + ", " + this.leftName + " " + left + ", " + this.rightName + " " + right);
                }
                return false;
            }
            return true;
        }
        for (Class<?> clazz = leftClass; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                boolean result;
                field.setAccessible(true);
                if (this.skipTransient && Modifier.isTransient(field.getModifiers())) continue;
                Object leftFieldValue = null;
                try {
                    leftFieldValue = field.get(left);
                }
                catch (Throwable ex) {
                    if (this.out != null) {
                        this.out.println("get value error " + path + ", " + field.getName() + this.leftName + " " + left);
                    }
                    return false;
                }
                Object rightFieldValue = null;
                try {
                    rightFieldValue = field.get(right);
                }
                catch (Throwable ex) {
                    if (this.out != null) {
                        this.out.println("get value error " + path + ", " + field.getName() + this.rightName + " " + right);
                    }
                    return false;
                }
                if (field.getName().equals("this$0")) {
                    boolean bl = result = leftFieldValue != null == (rightFieldValue != null);
                    if (result) continue;
                    if (this.out != null) {
                        this.out.println("diff this$0 " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
                    }
                    return false;
                }
                result = this.diff(leftFieldValue, rightFieldValue, new JSONWriter.Path(path, field.getName()), field.getGenericType());
                if (result) continue;
                if (this.out != null) {
                    this.out.println("diff object " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
                }
                return false;
            }
        }
        if (this.comparator != null && (cmp = this.comparator.compare(left, right)) != 0) {
            if (this.out != null) {
                this.out.println("diff compare " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
            }
            match = false;
        }
        return match;
    }

    boolean diffHashSet(Set left, Set right, JSONWriter.Path path, Type type, Class leftClass) {
        Type[] actualTypeArguments;
        Class itemClass = null;
        if (type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()).length == 1 && actualTypeArguments[0] instanceof Class) {
            itemClass = (Class)actualTypeArguments[0];
        }
        Set leftSet = left;
        Set rightSet = right;
        if (leftSet.size() != rightSet.size()) {
            if (this.out != null) {
                this.out.println("diff collection size " + path + ", " + this.leftName + " " + leftSet.size() + ", " + this.rightName + " " + rightSet.size());
            }
            return false;
        }
        Iterator leftIt = leftSet.iterator();
        int i = 0;
        while (leftIt.hasNext()) {
            Object castedItem;
            Object leftItem = leftIt.next();
            boolean result = rightSet.contains(leftItem);
            if (!result && !itemClass.isInstance(leftItem) && rightSet.contains(castedItem = TypeUtils.cast(leftItem, itemClass))) {
                result = true;
            }
            if (!result) {
                this.out.println("diff set " + path + ", " + leftClass.getName());
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean diffMap(Map leftMap, Map rightMap, JSONWriter.Path path, boolean match, Class leftClass) {
        int cmp;
        HashMap rightMapClone = new HashMap(rightMap);
        for (Map.Entry leftEntry : leftMap.entrySet()) {
            int cmp2;
            String leftKeyStr;
            boolean result;
            Object leftKey = leftEntry.getKey();
            Object leftValue = leftEntry.getValue();
            Object rightValue = rightMap.get(leftKey);
            if (rightValue == null) {
                JSONWriter.Path keyPath = new JSONWriter.Path(new JSONWriter.Path(path, 0), "key");
                Iterator it = rightMapClone.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry rightEntry = it.next();
                    boolean referenceDetect = this.referenceDetect;
                    PrintStream out = this.out;
                    this.referenceDetect = false;
                    this.out = null;
                    try {
                        if (!this.diff(leftKey, rightEntry.getKey(), keyPath, null)) continue;
                        it.remove();
                        rightValue = rightEntry.getValue();
                        break;
                    }
                    finally {
                        this.referenceDetect = referenceDetect;
                        this.out = out;
                    }
                }
            }
            if (!(result = this.diff(leftValue, rightValue, new JSONWriter.Path(path, leftKeyStr = leftKey != null && ObjectWriterProvider.isPrimitiveOrEnum(leftKey.getClass()) ? leftKey.toString() : "#"), null))) {
                this.out.println("diff map " + path + ", " + leftClass.getName());
                return false;
            }
            if (this.comparator == null || (cmp2 = this.comparator.compare(leftValue, rightValue)) == 0) continue;
            if (this.out != null) {
                this.out.println("diff map value " + path + " " + leftKey + ", class " + leftValue.getClass().getResource(leftValue.getClass().getSimpleName() + ".class"));
            }
            return false;
        }
        Object leftInnerMap = null;
        Object rightInnerMap = null;
        if (leftClass.getName().equals("com.alibaba.fastjson.JSONObject")) {
            Field mapField = BeanUtils.getDeclaredField(leftClass, "map");
            mapField.setAccessible(true);
            try {
                int cmp3;
                leftInnerMap = mapField.get(leftMap);
                rightInnerMap = mapField.get(rightMap);
                boolean result = this.diff(leftInnerMap, rightInnerMap, new JSONWriter.Path(path, "map"), null);
                if (!result) {
                    this.out.println("diff JSONObject1 " + path);
                    return false;
                }
                if (this.comparator != null && (cmp3 = this.comparator.compare(leftInnerMap, rightInnerMap)) != 0) {
                    if (this.out != null) {
                        this.out.println("diff JSONObject1 map compare " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
                    }
                    return false;
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        if (leftMap.size() != rightMap.size()) {
            if (this.out != null) {
                this.out.println("diff map size " + path + ", " + this.leftName + " " + leftMap.size() + ", " + this.rightName + " " + rightMap.size() + ", " + leftMap.getClass().getName());
            }
            return false;
        }
        if (this.comparator != null && (cmp = this.comparator.compare(leftMap, rightMap)) != 0) {
            if (this.out != null) {
                this.out.println("diff map compare " + path + ", class " + leftClass.getResource(leftClass.getSimpleName() + ".class"));
            }
            return false;
        }
        return match;
    }
}

