/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.io.Serializable;
import java.lang.reflect.Type;

abstract class FieldWriterImpl<T>
implements FieldWriter<T> {
    final String name;
    final int ordinal;
    final String format;
    final long hashCode;
    final byte[] nameWithColonUTF8;
    final char[] nameWithColonUTF16;
    byte[] nameJSONB;
    final long features;
    final Type fieldType;
    final Class fieldClass;
    final boolean fieldClassSerializable;

    FieldWriterImpl(String name, int ordinal, long features, String format, Type fieldType, Class fieldClass) {
        this.name = name;
        this.ordinal = ordinal;
        this.format = format;
        this.hashCode = Fnv.hashCode64(name);
        this.features = features;
        this.fieldType = fieldType;
        this.fieldClass = fieldClass;
        this.fieldClassSerializable = fieldClass != null && Serializable.class.isAssignableFrom(fieldClass);
        int nameLength = name.length();
        int utflen = nameLength + 3;
        for (int i = 0; i < nameLength; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        byte[] bytes = new byte[utflen];
        int off = 0;
        bytes[off++] = 34;
        for (int i = 0; i < nameLength; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[off++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytes[off++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[off++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[off++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytes[off++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytes[off++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        bytes[off++] = 34;
        bytes[off++] = 58;
        this.nameWithColonUTF8 = bytes;
        this.nameWithColonUTF16 = new char[nameLength + 3];
        this.nameWithColonUTF16[0] = 34;
        name.getChars(0, name.length(), this.nameWithColonUTF16, 1);
        this.nameWithColonUTF16[this.nameWithColonUTF16.length - 2] = 34;
        this.nameWithColonUTF16[this.nameWithColonUTF16.length - 1] = 58;
    }

    @Override
    public boolean isFieldClassSerializable() {
        return this.fieldClassSerializable;
    }

    @Override
    public int ordinal() {
        return this.ordinal;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void writeEnumJSONB(JSONWriter jsonWriter, Enum e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFieldName() {
        return this.name;
    }

    @Override
    public Class getFieldClass() {
        return this.fieldClass;
    }

    @Override
    public Type getFieldType() {
        return this.fieldType;
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public final void writeFieldName(JSONWriter jsonWriter) {
        if (jsonWriter.isJSONB()) {
            if (this.nameJSONB == null) {
                this.nameJSONB = JSONB.toBytes(this.name);
            }
            jsonWriter.writeNameRaw(this.nameJSONB, this.hashCode);
            return;
        }
        if (jsonWriter.isUTF8()) {
            jsonWriter.writeNameRaw(this.nameWithColonUTF8);
            return;
        }
        if (jsonWriter.isUTF16()) {
            jsonWriter.writeNameRaw(this.nameWithColonUTF16);
            return;
        }
        jsonWriter.writeName(this.name);
        jsonWriter.writeColon();
    }

    public String toString() {
        return this.name;
    }
}

