/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterList;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;

final class FieldWriterListField<T>
extends FieldWriterList<T> {
    final Field field;

    protected FieldWriterListField(String fieldName, Type itemType, int ordinal, long features, String format, Type fieldType, Class fieldClass, Field field) {
        super(fieldName, itemType, ordinal, features, format, fieldType, fieldClass);
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        List value = (List)this.getFieldValue((Object)object);
        JSONWriter.Context context = jsonWriter.getContext();
        if (value == null) {
            long features = this.features | context.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeArrayNull();
                return true;
            }
            return false;
        }
        String refPath = jsonWriter.setPath(this.name, (Object)value);
        if (refPath != null) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeReference(refPath);
            jsonWriter.popPath(value);
            return true;
        }
        this.writeList(jsonWriter, true, value);
        jsonWriter.popPath(value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String refPath;
        List value = (List)this.getFieldValue((Object)object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        if (refDetect && (refPath = jsonWriter.setPath(this.name, (Object)value)) != null) {
            jsonWriter.writeReference(refPath);
            jsonWriter.popPath(value);
            return;
        }
        this.writeList(jsonWriter, false, value);
        if (refDetect) {
            jsonWriter.popPath(value);
        }
    }
}

