/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;

final class ObjectWriterImplMap
extends ObjectWriterBaseModule.PrimitiveImpl {
    static final byte[] TYPE_NAME_JSONObject1O = JSONB.toBytes("JO10");
    static final long TYPE_HASH_JSONObject1O = Fnv.hashCode64("JO10");
    final Type objectType;
    final Class objectClass;
    final Type keyType;
    final Type valueType;
    final boolean valueTypeRefDetect;
    volatile ObjectWriter valueWriter;
    final byte[] jsonbTypeInfo;
    final long typeNameHash;
    final long features;
    final boolean jsonObject1;
    final Field jsonObject1InnerMap;
    long jsonObject1InnerMapOffset = -1L;

    public ObjectWriterImplMap(Class objectClass, long features) {
        this(null, null, objectClass, objectClass, features);
    }

    public ObjectWriterImplMap(Type keyType, Type valueType, Class objectClass, Type objectType, long features) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.objectClass = objectClass;
        this.objectType = objectType;
        this.features = features;
        this.valueTypeRefDetect = valueType == null ? true : !ObjectWriterProvider.isNotReferenceDetect(TypeUtils.getClass(valueType));
        String typeName = TypeUtils.getTypeName(objectClass);
        this.jsonObject1 = "JO1".equals(typeName);
        this.jsonbTypeInfo = JSONB.toBytes(typeName);
        this.typeNameHash = Fnv.hashCode64(typeName);
        if (this.jsonObject1) {
            this.jsonObject1InnerMap = BeanUtils.getDeclaredField(objectClass, "map");
            if (this.jsonObject1InnerMap != null) {
                this.jsonObject1InnerMap.setAccessible(true);
                if (JDKUtils.UNSAFE_SUPPORT) {
                    this.jsonObject1InnerMapOffset = UnsafeUtils.objectFieldOffset(this.jsonObject1InnerMap);
                }
            }
        } else {
            this.jsonObject1InnerMap = null;
        }
    }

    public static ObjectWriterImplMap of(Class objectClass) {
        return new ObjectWriterImplMap(null, null, objectClass, objectClass, 0L);
    }

    public static ObjectWriterImplMap of(Type type) {
        Class<?> objectClass = TypeUtils.getClass(type);
        return new ObjectWriterImplMap(objectClass, 0L);
    }

    public static ObjectWriterImplMap of(Type type, Class defineClass) {
        Type keyType = null;
        Type valueType = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 2) {
                keyType = actualTypeArguments[0];
                valueType = actualTypeArguments[1];
            }
        }
        return new ObjectWriterImplMap(keyType, valueType, defineClass, type, 0L);
    }

    @Override
    public void writeArrayMappingJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        Map map = (Map)object;
        jsonWriter.startObject();
        boolean writeNulls = jsonWriter.isWriteNulls();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                if (!writeNulls) continue;
                jsonWriter.writeString(key);
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(key);
            Class<?> valueType = value.getClass();
            if (valueType == String.class) {
                jsonWriter.writeString((String)value);
                continue;
            }
            ObjectWriter valueWriter = jsonWriter.getObjectWriter(valueType);
            valueWriter.writeJSONB(jsonWriter, value, key, this.valueType, this.features);
        }
        jsonWriter.endObject();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (fieldType == this.objectType && jsonWriter.isWriteMapTypeInfo(object, this.objectClass, features) || jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
            ordered = false;
            if (this.jsonObject1InnerMap != null) {
                if (this.jsonObject1InnerMapOffset != -1L) {
                    innerMap = UnsafeUtils.UNSAFE.getObject(object, this.jsonObject1InnerMapOffset);
                    ordered = innerMap instanceof LinkedHashMap;
                } else {
                    try {
                        innerMap = this.jsonObject1InnerMap.get(object);
                        ordered = innerMap instanceof LinkedHashMap;
                    }
                    catch (IllegalAccessException innerMap) {
                        // empty catch block
                    }
                }
            }
            if (ordered) {
                jsonWriter.writeTypeName(ObjectWriterImplMap.TYPE_NAME_JSONObject1O, ObjectWriterImplMap.TYPE_HASH_JSONObject1O);
            } else {
                jsonWriter.writeTypeName(this.jsonbTypeInfo, this.typeNameHash);
            }
        }
        map = (Map)object;
        context = jsonWriter.getContext();
        jsonWriter.startObject();
        fieldValueType = this.valueType;
        if (fieldType == this.objectType) {
            fieldValueType = this.valueType;
        } else if (fieldType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments()).length == 2) {
            fieldValueType = actualTypeArguments[1];
        }
        contextFeatures = context.getFeatures();
        writeNulls = (contextFeatures & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L;
        fieldBased = (contextFeatures & JSONWriter.Feature.FieldBased.mask) != 0L;
        provider = context.getProvider();
        itemClass = null;
        itemWriter = null;
        symbolTable = jsonWriter.getSymbolTable();
        contextRefDetect = (contextFeatures & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
        i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            block43: {
                block47: {
                    block46: {
                        block44: {
                            block45: {
                                block42: {
                                    entryKey = entry.getKey();
                                    value = entry.getValue();
                                    if (value != null) break block42;
                                    if (writeNulls) {
                                        if (entryKey instanceof String) {
                                            jsonWriter.writeString((String)entryKey);
                                        } else {
                                            entryKeyClass = entryKey.getClass();
                                            keyRefDetect = contextRefDetect != false && ObjectWriterProvider.isNotReferenceDetect(entryKeyClass) == false;
                                            refPath = null;
                                            if (keyRefDetect) {
                                                jsonWriter.setPath(i, entry);
                                                refPath = jsonWriter.setPath("key", entryKey);
                                            }
                                            if (refPath != null) {
                                                jsonWriter.writeReference(refPath);
                                            } else {
                                                keyWriter = provider.getObjectWriter(entryKeyClass, entryKeyClass, fieldBased);
                                                keyWriter.writeJSONB(jsonWriter, entryKey, null, null, 0L);
                                            }
                                            if (keyRefDetect) {
                                                jsonWriter.popPath(entry);
                                                jsonWriter.popPath(entryKey);
                                            }
                                        }
                                        jsonWriter.writeNull();
                                    }
                                    break block43;
                                }
                                if (!(entryKey instanceof String) && (contextFeatures & JSONWriter.Feature.WriteClassName.mask) != 0L) break block44;
                                key = (String)entryKey;
                                if (symbolTable == null) break block45;
                                jsonWriter.writeSymbol(key);
                                if (!(value instanceof String)) break block46;
                                jsonWriter.writeSymbol((String)value);
                                break block43;
                            }
                            jsonWriter.writeString(key);
                            break block46;
                        }
                        if (contextRefDetect) {
                            jsonWriter.config(JSONWriter.Feature.ReferenceDetection, false);
                        }
                        entryKeyClass = entryKey.getClass();
                        keyWriter = provider.getObjectWriter(entryKeyClass, entryKeyClass, fieldBased);
                        keyWriter.writeJSONB(jsonWriter, entryKey, null, null, 0L);
                        if (contextRefDetect) {
                            jsonWriter.config(JSONWriter.Feature.ReferenceDetection, true);
                        }
                    }
                    valueClass = value.getClass();
                    if (valueClass != String.class) break block47;
                    jsonWriter.writeString((String)value);
                    break block43;
                }
                valueRefDetecChanged = false;
                if (valueClass == this.valueType) {
                    valueRefDetect = contextRefDetect != false && this.valueTypeRefDetect != false;
                } else {
                    v0 = valueRefDetect = contextRefDetect != false && ObjectWriterProvider.isNotReferenceDetect(valueClass) == false;
                }
                if (!valueRefDetect) ** GOTO lbl-1000
                if (value == object) {
                    jsonWriter.writeReference("..");
                } else {
                    if (entryKey instanceof String) {
                        refPath = jsonWriter.setPath((String)entryKey, value);
                    } else if (ObjectWriterProvider.isPrimitiveOrEnum(entryKey.getClass())) {
                        refPath = jsonWriter.setPath(entryKey.toString(), value);
                    } else if (map.size() != 1 && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
                        refPath = null;
                        jsonWriter.config(JSONWriter.Feature.ReferenceDetection, false);
                        valueRefDetecChanged = true;
                        valueRefDetect = false;
                    } else {
                        refPath = jsonWriter.setPath(i, value);
                    }
                    if (refPath != null) {
                        jsonWriter.writeReference(refPath);
                        jsonWriter.popPath(value);
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (valueClass == this.valueType && this.valueWriter != null) {
                            valueWriter = this.valueWriter;
                        } else if (itemClass == valueClass) {
                            valueWriter = itemWriter;
                        } else {
                            valueWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                            if (itemWriter == null) {
                                itemWriter = valueWriter;
                                itemClass = valueClass;
                            }
                            if (valueClass == this.valueType) {
                                this.valueWriter = valueWriter;
                            }
                        }
                        valueWriter.writeJSONB(jsonWriter, value, entryKey, fieldValueType, this.features);
                        if (valueRefDetecChanged) {
                            jsonWriter.config(JSONWriter.Feature.ReferenceDetection, true);
                        } else if (valueRefDetect) {
                            jsonWriter.popPath(value);
                        }
                    }
                }
            }
            ++i;
        }
        jsonWriter.endObject();
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.isJSONB()) {
            this.writeJSONB(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        if (this.hasFilter(jsonWriter)) {
            this.writeWithFilter(jsonWriter, object);
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        jsonWriter.startObject();
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            String strKey;
            Object value = entry.getValue();
            Object key = entry.getKey();
            String string = strKey = key == null ? "null" : key.toString();
            if (value == null) {
                if (!jsonWriter.isWriteNulls()) continue;
                jsonWriter.writeName(strKey);
                jsonWriter.writeColon();
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeName(strKey);
            jsonWriter.writeColon();
            Class<?> valueType = value.getClass();
            if (valueType == String.class) {
                jsonWriter.writeString((String)value);
                continue;
            }
            ObjectWriter valueWriter = valueType == this.valueType ? (this.valueWriter != null ? this.valueWriter : (this.valueWriter = jsonWriter.getObjectWriter(valueType))) : jsonWriter.getObjectWriter(valueType);
            if (refDetect && !ObjectWriterProvider.isPrimitiveOrEnum(value.getClass())) {
                if (value == object) {
                    jsonWriter.writeReference("..");
                    continue;
                }
                String refPath = jsonWriter.setPath(strKey, value);
                if (refPath != null) {
                    jsonWriter.writeReference(refPath);
                    jsonWriter.popPath(value);
                    continue;
                }
            }
            valueWriter.write(jsonWriter, value, key, this.valueType, this.features);
            if (!refDetect) continue;
            jsonWriter.popPath(value);
        }
        jsonWriter.endObject();
    }

    @Override
    public void writeWithFilter(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        jsonWriter.startObject();
        Map map = (Map)object;
        JSONWriter.Context ctx = jsonWriter.getContext();
        PropertyPreFilter propertyPreFilter = ctx.getPropertyPreFilter();
        NameFilter nameFilter = ctx.getNameFilter();
        ValueFilter valueFilter = ctx.getValueFilter();
        PropertyFilter propertyFilter = ctx.getPropertyFilter();
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey().toString();
            if (propertyPreFilter != null && !propertyPreFilter.process(jsonWriter, object, key)) continue;
            if (nameFilter != null) {
                key = nameFilter.process(object, key, value);
            }
            if (propertyFilter != null && !propertyFilter.process(object, key, value)) continue;
            jsonWriter.writeName(key);
            jsonWriter.writeColon();
            if (valueFilter != null) {
                value = valueFilter.apply(object, key, value);
            }
            if (value == null) continue;
            Class<?> valueType = value.getClass();
            ObjectWriter valueWriter = jsonWriter.getObjectWriter(valueType);
            valueWriter.write(jsonWriter, value, fieldName, fieldType, this.features);
        }
        jsonWriter.endObject();
    }
}

