/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;

final class JSONWriterPretty
extends JSONWriter {
    final JSONWriter jsonWriter;
    int indent;
    int startObjectOff;

    protected JSONWriterPretty(JSONWriter jsonWriter) {
        super(jsonWriter.context, jsonWriter.charset);
        this.jsonWriter = jsonWriter;
    }

    @Override
    public void writeComma() {
        this.write0(',');
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
    }

    @Override
    public void writeInt32(int value) {
        this.jsonWriter.writeInt32(value);
    }

    @Override
    public void writeInt64(long i) {
        this.jsonWriter.writeInt64(i);
    }

    @Override
    public void writeFloat(float value) {
        this.jsonWriter.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.jsonWriter.writeDouble(value);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        this.jsonWriter.writeDecimal(value);
    }

    @Override
    public void writeBigInt(BigInteger value, long features) {
        this.jsonWriter.writeBigInt(value, features);
    }

    @Override
    public void writeUUID(UUID value) {
        this.jsonWriter.writeUUID(value);
    }

    @Override
    public void writeString(String str) {
        this.jsonWriter.writeString(str);
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
    }

    @Override
    public void writeReference(String path) {
        this.jsonWriter.writeReference(path);
    }

    @Override
    public void startObject() {
        ++this.level;
        this.jsonWriter.startObject = true;
        this.write0('{');
        ++this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
        this.startObjectOff = this.jsonWriter.off;
    }

    @Override
    public void endObject() {
        --this.level;
        --this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
        this.write0('}');
        this.jsonWriter.startObject = false;
    }

    @Override
    public void startArray() {
        ++this.level;
        this.write0('[');
        ++this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
    }

    @Override
    public void endArray() {
        ++this.level;
        --this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
        this.write0(']');
        this.jsonWriter.startObject = false;
    }

    @Override
    public void writeRaw(char[] chars) {
        this.jsonWriter.writeRaw(chars);
    }

    @Override
    public void writeNameRaw(char[] chars) {
        if (this.jsonWriter.startObject) {
            this.jsonWriter.startObject = false;
        } else {
            this.writeComma();
        }
        this.jsonWriter.writeRaw(chars);
    }

    @Override
    public void writeRaw(byte[] bytes) {
        this.jsonWriter.writeRaw(bytes);
    }

    @Override
    public void writeNameRaw(byte[] bytes) {
        if (this.jsonWriter.startObject) {
            this.jsonWriter.startObject = false;
        } else {
            this.writeComma();
        }
        this.jsonWriter.writeRaw(bytes);
    }

    @Override
    public void writeName(String name) {
        if (this.jsonWriter.startObject) {
            this.jsonWriter.startObject = false;
        } else {
            this.writeComma();
        }
        this.jsonWriter.writeString(name);
    }

    @Override
    public void writeNameRaw(byte[] bytes, int offset, int len) {
        this.jsonWriter.writeNameRaw(bytes, offset, len);
    }

    @Override
    public void writeNameRaw(char[] bytes, int offset, int len) {
        this.jsonWriter.writeNameRaw(bytes, offset, len);
    }

    @Override
    protected void write0(char ch) {
        this.jsonWriter.write0(ch);
    }

    @Override
    public void writeRaw(String str) {
        this.jsonWriter.writeRaw(str);
    }

    @Override
    public byte[] getBytes() {
        return this.jsonWriter.getBytes();
    }

    public String toString() {
        return this.jsonWriter.toString();
    }
}

