/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TypeReference<T> {
    protected final Type type;
    protected final Class<? super T> rawType;
    private static final Map primitiveTypeMap = new HashMap<Class, String>(8){
        {
            this.put(Boolean.TYPE, "Z");
            this.put(Character.TYPE, "C");
            this.put(Byte.TYPE, "B");
            this.put(Short.TYPE, "S");
            this.put(Integer.TYPE, "I");
            this.put(Long.TYPE, "J");
            this.put(Float.TYPE, "F");
            this.put(Double.TYPE, "D");
        }
    };

    public TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.rawType = BeanUtils.getRawType(this.type);
    }

    public TypeReference(Type type, boolean raw) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = BeanUtils.canonicalize(type);
        this.rawType = BeanUtils.getRawType(type);
    }

    protected TypeReference(Type ... actualTypeArguments) {
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        Type rawType = argType.getRawType();
        Type[] argTypes = argType.getActualTypeArguments();
        int actualIndex = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (argTypes[i] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                argTypes[i] = actualTypeArguments[actualIndex++];
            }
            if (argTypes[i] instanceof GenericArrayType) {
                argTypes[i] = TypeReference.checkPrimitiveArray((GenericArrayType)argTypes[i]);
            }
            if (!(argTypes[i] instanceof ParameterizedType)) continue;
            argTypes[i] = this.handlerParameterizedType((ParameterizedType)argTypes[i], actualTypeArguments, actualIndex);
        }
        this.type = new ParameterizedTypeImpl(argTypes, thisClass, rawType);
        this.rawType = BeanUtils.getRawType(this.type);
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public T parseObject(String text) {
        return JSON.parseObject(text, this.type);
    }

    public T parseObject(JSONObject object) {
        return object.toJavaObject(this.type);
    }

    public List<T> parseArray(String text) {
        return JSON.parseArray(text, this.type);
    }

    public T parseArray(JSONArray object) {
        return object.toJavaObject(this.type);
    }

    public static TypeReference<?> get(Type type) {
        return new TypeReference<Object>(type, true){};
    }

    static Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class ck;
        Type clz = genericArrayType;
        Type genericComponentType = genericArrayType.getGenericComponentType();
        String prefix = "[";
        while (genericComponentType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericComponentType).getGenericComponentType();
            prefix = prefix + prefix;
        }
        if (genericComponentType instanceof Class && (ck = (Class)genericComponentType).isPrimitive()) {
            try {
                String postfix = (String)primitiveTypeMap.get(ck);
                if (postfix != null) {
                    clz = Class.forName(prefix + postfix);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clz;
    }

    private Type handlerParameterizedType(ParameterizedType type, Type[] actualTypeArguments, int actualIndex) {
        Class<?> thisClass = this.getClass();
        Type rawType = type.getRawType();
        Type[] argTypes = type.getActualTypeArguments();
        for (int i = 0; i < argTypes.length; ++i) {
            if (argTypes[i] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                argTypes[i] = actualTypeArguments[actualIndex++];
            }
            if (argTypes[i] instanceof GenericArrayType) {
                argTypes[i] = TypeReference.checkPrimitiveArray((GenericArrayType)argTypes[i]);
            }
            if (!(argTypes[i] instanceof ParameterizedType)) continue;
            argTypes[i] = this.handlerParameterizedType((ParameterizedType)argTypes[i], actualTypeArguments, actualIndex);
        }
        ParameterizedTypeImpl key = new ParameterizedTypeImpl(argTypes, thisClass, rawType);
        return key;
    }
}

