/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.codec;

import java.time.format.DateTimeFormatter;

public abstract class DateTimeCodec {
    public final String format;
    public final boolean formatUnixTime;
    public final boolean formatMillis;
    public final boolean formatISO8601;
    DateTimeFormatter dateFormatter;

    public DateTimeCodec(String format) {
        this.format = format;
        boolean formatUnixTime = false;
        boolean formatISO8601 = false;
        boolean formatMillis = false;
        if (format != null) {
            switch (format) {
                case "unixtime": {
                    formatUnixTime = true;
                    break;
                }
                case "iso8601": {
                    formatISO8601 = true;
                    break;
                }
                case "millis": {
                    formatMillis = true;
                    break;
                }
            }
        }
        this.formatUnixTime = formatUnixTime;
        this.formatMillis = formatMillis;
        this.formatISO8601 = formatISO8601;
    }

    public DateTimeFormatter getDateFormatter() {
        if (!(this.dateFormatter != null || this.format == null || this.formatMillis || this.formatISO8601 || this.formatUnixTime)) {
            this.dateFormatter = DateTimeFormatter.ofPattern(this.format);
        }
        return this.dateFormatter;
    }
}

