/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public interface ObjectReader<T> {
    public static final long HASH_TYPE = Fnv.hashCode64("@type");

    default public T createInstance() {
        return this.createInstance(0L);
    }

    default public T createInstance(long features) {
        throw new UnsupportedOperationException();
    }

    default public T createInstance(Collection collection) {
        throw new UnsupportedOperationException();
    }

    default public T createInstance(Map map) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Object typeKey = map.get(this.getTypeKey());
        if (typeKey instanceof String) {
            String typeName = (String)typeKey;
            long typeHash = Fnv.hashCode64(typeName);
            ObjectReader reader = this.autoType(provider, typeHash);
            if (reader == null && (reader = provider.getObjectReader(typeName, this.getObjectClass(), this.getFeatures())) == null) {
                throw new JSONException("No suitable ObjectReader found for" + typeName);
            }
            if (reader != this) {
                return reader.createInstance(map);
            }
        }
        T object = this.createInstance(0L);
        for (Map.Entry entry : map.entrySet()) {
            Function typeConvert;
            Class<?> valueClass;
            FieldReader fieldReader = this.getFieldReader(entry.getKey().toString());
            if (fieldReader == null) continue;
            Object fieldValue = entry.getValue();
            Class fieldClass = fieldReader.getFieldClass();
            if (fieldValue != null && (valueClass = fieldValue.getClass()) != fieldClass && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                fieldValue = typeConvert.apply(fieldValue);
            }
            if (!fieldClass.isInstance(fieldValue) && fieldReader.getFormat() == null) {
                fieldValue = TypeUtils.cast(fieldValue, fieldClass);
            }
            fieldReader.accept(object, fieldValue);
        }
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            return (T)buildFunction.apply(object);
        }
        return object;
    }

    default public T createInstanceNoneDefaultConstructor(Map<Long, Object> values) {
        throw new UnsupportedOperationException();
    }

    default public long getFeatures() {
        return 0L;
    }

    default public String getTypeKey() {
        return "@type";
    }

    default public long getTypeKeyHash() {
        return HASH_TYPE;
    }

    default public Class<T> getObjectClass() {
        return null;
    }

    default public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    default public FieldReader getFieldReaderLCase(long hashCode) {
        return null;
    }

    default public boolean setFieldValue(Object object, String fieldName, long fieldNameHashCode, int value) {
        FieldReader fieldReader = this.getFieldReader(fieldNameHashCode);
        if (fieldReader == null) {
            return false;
        }
        fieldReader.accept(object, value);
        return true;
    }

    default public boolean setFieldValue(Object object, String fieldName, long fieldNameHashCode, long value) {
        FieldReader fieldReader = this.getFieldReader(fieldNameHashCode);
        if (fieldReader == null) {
            return false;
        }
        fieldReader.accept(object, value);
        return true;
    }

    default public FieldReader getFieldReader(String fieldName) {
        String fieldNameLCase;
        FieldReader fieldReader = this.getFieldReader(Fnv.hashCode64(fieldName));
        if (fieldReader == null && !(fieldNameLCase = fieldName.toLowerCase()).equals(fieldName)) {
            fieldReader = this.getFieldReader(Fnv.hashCode64(fieldNameLCase));
        }
        return fieldReader;
    }

    default public Function getBuildFunction() {
        return null;
    }

    default public ObjectReader autoType(JSONReader.Context context, long typeHash) {
        return context.getObjectReaderAutoType(typeHash);
    }

    default public ObjectReader autoType(ObjectReaderProvider provider, long typeHash) {
        return provider.getObjectReader(typeHash);
    }

    default public T readJSONBObject(JSONReader jsonReader, long features) {
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray()) {
            return this.readArrayMappingJSONBObject(jsonReader);
        }
        Object object = null;
        jsonReader.nextIfObjectStart();
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.getTypeKeyHash() && i == 0) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader reader = this.autoType(context, typeHash);
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException("No suitable ObjectReader found for" + typeName);
                }
                if (reader != this) {
                    return reader.readJSONBObject(jsonReader, features);
                }
            } else if (hash != 0L) {
                long nameHashCodeLCase;
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures()) && (nameHashCodeLCase = jsonReader.getNameHashCodeLCase()) != hash) {
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    jsonReader.skipValue();
                } else {
                    if (object == null) {
                        object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                    }
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        if (object == null) {
            object = this.createInstance(jsonReader.getContext().getFeatures() | features);
        }
        return object;
    }

    default public T readArrayMappingJSONBObject(JSONReader jsonReader) {
        throw new UnsupportedOperationException();
    }

    default public T readArrayMappingObject(JSONReader jsonReader) {
        throw new UnsupportedOperationException();
    }

    default public T readObject(JSONReader jsonReader) {
        return this.readObject(jsonReader, this.getFeatures());
    }

    default public T readObject(JSONReader jsonReader, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, features);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray(this.getFeatures() | features)) {
            return this.readArrayMappingObject(jsonReader);
        }
        Object object = null;
        jsonReader.nextIfMatch('{');
        int i = 0;
        while (true) {
            long features3;
            if (jsonReader.nextIfMatch('}')) {
                if (object != null) break;
                object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                break;
            }
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.getTypeKeyHash() && i == 0 && ((features3 = features | this.getFeatures() | jsonReader.getContext().getFeatures()) & JSONReader.Feature.SupportAutoType.mask) != 0L) {
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader reader = this.autoType(context, typeHash);
                String typeName = null;
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.getObjectClass(), features3)) == null) {
                    throw new JSONException("No suitable ObjectReader found for" + typeName);
                }
                if (reader != this) {
                    FieldReader fieldReader = reader.getFieldReader(hash);
                    if (fieldReader != null && typeName == null) {
                        typeName = jsonReader.getString();
                    }
                    object = reader.readObject(jsonReader, features | this.getFeatures());
                    if (fieldReader != null) {
                        fieldReader.accept(object, typeName);
                    }
                    return object;
                }
            } else {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    jsonReader.skipValue();
                } else {
                    if (object == null) {
                        object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                    }
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            return (T)buildFunction.apply(object);
        }
        return object;
    }
}

