/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32;
import java.lang.reflect.Type;
import java.util.Arrays;

abstract class FieldWriterInt32<T>
extends FieldWriterImpl<T> {
    volatile byte[][] utf8ValueCache;
    volatile char[][] utf16ValueCache;
    final boolean toString;

    protected FieldWriterInt32(String name, int ordinal, long features, String format, Type fieldType, Class fieldClass) {
        super(name, ordinal, features, format, fieldType, fieldClass);
        this.toString = (features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L || "string".equals(format);
    }

    @Override
    public void writeInt32(JSONWriter jsonWriter, int value) {
        boolean writeNonStringValueAsString;
        if (this.toString) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(Integer.toString(value));
            return;
        }
        boolean bl = writeNonStringValueAsString = (jsonWriter.getFeatures() & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        if (jsonWriter.isUTF8() && !writeNonStringValueAsString) {
            if (value >= -1 && value < 1039) {
                byte[] bytes = null;
                if (this.utf8ValueCache == null) {
                    this.utf8ValueCache = new byte[1040][];
                } else {
                    bytes = this.utf8ValueCache[value + 1];
                }
                if (bytes == null) {
                    int size = value < 0 ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
                    byte[] original = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + size);
                    bytes = Arrays.copyOf(original, original.length);
                    IOUtils.getChars(value, bytes.length, bytes);
                    this.utf8ValueCache[value + 1] = bytes;
                }
                jsonWriter.writeNameRaw(bytes);
                return;
            }
        } else if (jsonWriter.isUTF16() && !writeNonStringValueAsString && value >= -1 && value < 1039) {
            char[] chars = null;
            if (this.utf16ValueCache == null) {
                this.utf16ValueCache = new char[1040][];
            } else {
                chars = this.utf16ValueCache[value + 1];
            }
            if (chars == null) {
                int size = value < 0 ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
                char[] original = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + size);
                chars = Arrays.copyOf(original, original.length);
                IOUtils.getChars(value, chars.length, chars);
                this.utf16ValueCache[value + 1] = chars;
            }
            jsonWriter.writeNameRaw(chars);
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt32(value);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Integer value;
        try {
            value = (Integer)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) == 0L) {
                return false;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeNumberNull();
            return true;
        }
        this.writeInt32(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Integer value = (Integer)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeInt32(value);
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (valueClass == this.fieldClass) {
            return ObjectWriterImplInt32.INSTANCE;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }
}

